/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.transport.SSL;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;

public class X509CertificateTrustManager
implements X509TrustManager {
    KeyStore ks = null;
    TrustManager[] trustManagers;

    public X509CertificateTrustManager(TrustManager[] trustManagerArray, KeyStore keyStore) {
        this.trustManagers = trustManagerArray;
        this.ks = keyStore;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        throw new SecurityException("checkClientTrusted unsupported");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            for (int i = 0; i < this.trustManagers.length; ++i) {
                if (!(this.trustManagers[i] instanceof X509TrustManager)) continue;
                ((X509TrustManager)this.trustManagers[i]).checkServerTrusted(x509CertificateArray, string);
            }
            return;
        }
        catch (CertificateException certificateException) {
            X509Certificate x509Certificate = x509CertificateArray[0];
            String string2 = "Version: " + x509Certificate.getVersion() + "\n";
            string2 = string2.concat("Serial Number: " + x509Certificate.getSerialNumber() + "\n");
            string2 = string2.concat("Signature Algorithm: " + x509Certificate.getSigAlgName() + "\n");
            string2 = string2.concat("Issuer: " + x509Certificate.getIssuerDN().getName() + "\n");
            string2 = string2.concat("Valid From: " + x509Certificate.getNotBefore() + "\n");
            string2 = string2.concat("Valid To: " + x509Certificate.getNotAfter() + "\n");
            string2 = string2.concat("Subject DN: " + x509Certificate.getSubjectDN().getName() + "\n");
            string2 = string2.concat("Public Key: " + x509Certificate.getPublicKey().getFormat() + "\n");
            int n = JOptionPane.showConfirmDialog(null, string2, "Accept Certificate", 0);
            if (n != 0) {
                throw new CertificateException("Certificate Not Accepted");
            }
            return;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(10);
        for (int i = 0; i < this.trustManagers.length; ++i) {
            if (!(this.trustManagers[i] instanceof X509TrustManager)) continue;
            arrayList.addAll(Arrays.asList(((X509TrustManager)this.trustManagers[i]).getAcceptedIssuers()));
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[arrayList.size()];
        x509CertificateArray = arrayList.toArray(x509CertificateArray);
        return x509CertificateArray;
    }
}

