/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.transport;

import java.net.Socket;
import org.tn5250j.framework.transport.SSLInterface;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SocketConnector {
    String sslType = null;
    TN5250jLogger logger = TN5250jLogFactory.getLogger(this.getClass());

    public void setSSLType(String string) {
        this.sslType = string;
    }

    public Socket createSocket(String string, int n) {
        Socket socket = null;
        Exception exception = null;
        if (this.sslType == null || this.sslType.trim().length() == 0 || this.sslType.toUpperCase().equals("NONE")) {
            this.logger.info("Creating Plain Socket");
            try {
                socket = new Socket(string, n);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        } else {
            this.logger.info("Creating SSL [" + this.sslType + "] Socket");
            SSLInterface sSLInterface = null;
            String string2 = "org.tn5250j.framework.transport.SSL.SSLImplementation";
            try {
                Class<?> clazz = Class.forName(string2);
                sSLInterface = (SSLInterface)clazz.newInstance();
            }
            catch (Exception exception3) {
                exception = new Exception("Failed to create SSLInterface Instance. Message is [" + exception3.getMessage() + "]");
            }
            if (sSLInterface != null) {
                sSLInterface.init(this.sslType);
                socket = sSLInterface.createSSLSocket(string, n);
            }
        }
        if (exception != null) {
            this.logger.error(exception);
        }
        if (socket == null) {
            this.logger.warn("No socket was created");
        }
        return socket;
    }
}

