/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;
import org.tn5250j.event.SessionChangeEvent;
import org.tn5250j.event.SessionListener;
import org.tn5250j.event.TabClosedListener;
import org.tn5250j.tools.LangTool;

public final class ButtonTabComponent
extends JPanel
implements SessionListener {
    private static final long serialVersionUID = 1L;
    private final JTabbedPane pane;
    private List<TabClosedListener> closeListeners;
    private final JLabel label;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(false);
            }
        }
    };

    public ButtonTabComponent(JTabbedPane jTabbedPane) {
        super(new BorderLayout(0, 0));
        if (jTabbedPane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = jTabbedPane;
        this.setOpaque(false);
        this.label = new TabLabel();
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        this.add((Component)this.label, "Center");
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton tabButton = new TabButton();
        tabButton.setHorizontalAlignment(11);
        this.add((Component)tabButton, "East");
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        jTabbedPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("indexForTitle".equals(propertyChangeEvent.getPropertyName())) {
                    ButtonTabComponent.this.label.revalidate();
                    ButtonTabComponent.this.label.repaint();
                }
            }
        });
    }

    @Override
    public void onSessionChanged(SessionChangeEvent sessionChangeEvent) {
        if (sessionChangeEvent.getState() == 1) {
            this.label.setEnabled(true);
            this.label.setToolTipText(LangTool.getString("ss.state.connected"));
            this.setToolTipText(LangTool.getString("ss.state.connected"));
        } else {
            this.label.setEnabled(false);
            this.label.setToolTipText(LangTool.getString("ss.state.disconnected"));
            this.setToolTipText(LangTool.getString("ss.state.disconnected"));
        }
    }

    public synchronized void addTabCloseListener(TabClosedListener tabClosedListener) {
        if (this.closeListeners == null) {
            this.closeListeners = new ArrayList<TabClosedListener>(3);
        }
        this.closeListeners.add(tabClosedListener);
    }

    public synchronized void removeTabCloseListener(TabClosedListener tabClosedListener) {
        if (this.closeListeners == null) {
            return;
        }
        this.closeListeners.remove(tabClosedListener);
    }

    protected void fireTabClosed(int n) {
        if (this.closeListeners != null) {
            int n2 = this.closeListeners.size();
            for (int i = 0; i < n2; ++i) {
                TabClosedListener tabClosedListener = this.closeListeners.get(i);
                tabClosedListener.onTabClosed(n);
            }
        }
    }

    private final class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public TabButton() {
            int n = 17;
            this.setPreferredSize(new Dimension(n, n));
            this.setToolTipText(LangTool.getString("popup.close"));
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (n != -1) {
                ButtonTabComponent.this.fireTabClosed(n);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.getModel().isPressed()) {
                graphics2D.translate(1, 1);
            }
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                graphics2D.setColor(Color.MAGENTA);
            }
            int n = 6;
            graphics2D.drawLine(n, n, this.getWidth() - n - 1, this.getHeight() - n - 1);
            graphics2D.drawLine(this.getWidth() - n - 1, n, n, this.getHeight() - n - 1);
            graphics2D.dispose();
        }
    }

    private final class TabLabel
    extends JLabel
    implements MouseListener {
        private static final long serialVersionUID = 1L;

        public TabLabel() {
            this.addMouseListener(this);
        }

        @Override
        public String getText() {
            int n = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (n != -1) {
                return ButtonTabComponent.this.pane.getTitleAt(n);
            }
            return null;
        }

        @Override
        public Icon getIcon() {
            int n = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (n != -1) {
                return ButtonTabComponent.this.pane.getIconAt(n);
            }
            return null;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.actionSelectTab();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.actionSelectTab();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void actionSelectTab() {
            int n = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (n != -1) {
                ButtonTabComponent.this.pane.setSelectedIndex(n);
            }
        }
    }
}

