/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.tools.LangTool;

public class HexCharMapDialog {
    private final DefaultListModel hexListModel;
    private final JList hexList;
    private final Component parent;

    public HexCharMapDialog(Component component, ICodePage iCodePage) {
        assert (iCodePage != null) : new IllegalArgumentException("A codepage is needed!");
        this.parent = component;
        Collator collator = Collator.getInstance();
        CollationKey collationKey = null;
        TreeSet<CollationKey> treeSet = new TreeSet<CollationKey>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 256; ++i) {
            char c = iCodePage.ebcdic2uni(i);
            if (Character.isISOControl(c)) continue;
            stringBuilder.setLength(0);
            if (Integer.toHexString(c).length() == 1) {
                stringBuilder.append("0x0" + Integer.toHexString(c).toUpperCase());
            } else {
                stringBuilder.append("0x" + Integer.toHexString(c).toUpperCase());
            }
            stringBuilder.append(" - " + c);
            collationKey = collator.getCollationKey(stringBuilder.toString());
            treeSet.add(collationKey);
        }
        Iterator iterator = treeSet.iterator();
        this.hexListModel = new DefaultListModel();
        while (iterator.hasNext()) {
            CollationKey collationKey2 = (CollationKey)iterator.next();
            this.hexListModel.addElement(collationKey2.getSourceString());
        }
        this.hexList = new JList(this.hexListModel);
        this.hexList.setSelectionMode(0);
        this.hexList.setSelectedIndex(0);
    }

    public String showModal() {
        JScrollPane jScrollPane = new JScrollPane(this.hexList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setSize(40, 100);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        Object[] objectArray = new String[]{LangTool.getString("hm.optInsert"), LangTool.getString("hm.optCancel")};
        int n = JOptionPane.showOptionDialog(this.parent, new Object[]{jPanel}, LangTool.getString("hm.title"), -1, 1, null, objectArray, objectArray[0]);
        if (n == 0) {
            String string = (String)this.hexList.getSelectedValue();
            return string.substring(string.length() - 1);
        }
        return null;
    }
}

