/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.tn5250j.gui.DefaultSortTableModel;
import org.tn5250j.gui.SortHeaderRenderer;
import org.tn5250j.gui.SortTableModel;

public class JSortTable
extends JTable
implements MouseListener {
    private static final long serialVersionUID = 1L;
    protected int sortedColumnIndex = -1;
    protected boolean sortedColumnAscending = true;

    public JSortTable() {
        this(new DefaultSortTableModel());
    }

    public JSortTable(int n, int n2) {
        this(new DefaultSortTableModel(n, n2));
    }

    public JSortTable(Object[][] objectArray, Object[] objectArray2) {
        this(new DefaultSortTableModel(objectArray, objectArray2));
    }

    public JSortTable(Vector vector, Vector vector2) {
        this(new DefaultSortTableModel(vector, vector2));
    }

    public JSortTable(SortTableModel sortTableModel) {
        super(sortTableModel);
        this.initSortHeader();
    }

    public JSortTable(SortTableModel sortTableModel, TableColumnModel tableColumnModel) {
        super(sortTableModel, tableColumnModel);
        this.initSortHeader();
    }

    public JSortTable(SortTableModel sortTableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(sortTableModel, tableColumnModel, listSelectionModel);
        this.initSortHeader();
    }

    protected void initSortHeader() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new SortHeaderRenderer());
        jTableHeader.addMouseListener(this);
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = tableColumnModel.getColumn(n).getModelIndex();
        SortTableModel sortTableModel = (SortTableModel)this.getModel();
        if (sortTableModel.isSortable(n2)) {
            if (this.sortedColumnIndex == n) {
                this.sortedColumnAscending = !this.sortedColumnAscending;
            }
            this.sortedColumnIndex = n;
            sortTableModel.sortColumn(n2, this.sortedColumnAscending);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

