/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import org.tn5250j.tools.FixedCenterLayout;
import org.tn5250j.tools.LangTool;

public class TN5250jMultiSelectList
extends JComponent {
    private static final long serialVersionUID = 1L;
    protected static final String SELECT_ITEM = ">";
    protected static final String SELECT_ALL = ">>|";
    protected static final String DESELECT_ITEM = "<";
    protected static final String DESELECT_ALL = "|<<";
    protected JList mainList = null;
    protected JList sourceList = null;
    protected JList selectionList = null;
    protected JScrollPane sourcePane = null;
    protected JScrollPane selectionPane = null;
    protected SelectionButton selectItemButton = null;
    protected SelectionButton selectAllButton = null;
    protected SelectionButton deselectItemButton = null;
    protected SelectionButton deselectAllButton = null;
    protected JPanel buttonPanel = null;
    protected EventHandler eventHandler = new EventHandler();
    protected Dimension defaultListSize = new Dimension(100, 200);
    protected FontMetrics lastFontMetrics = null;
    protected String sourceColumnHeader;
    protected String selectionColumnHeader;
    protected String sourceHeader;
    protected String selectionHeader;
    protected JPanel sourcePanel;
    protected JPanel selectionPanel;

    public TN5250jMultiSelectList(ListModel listModel) {
        this();
        this.mainList.setModel(listModel);
        this.init();
    }

    public TN5250jMultiSelectList(Object[] objectArray) {
        this();
        this.mainList.setListData(objectArray);
        this.init();
    }

    public TN5250jMultiSelectList(Vector vector) {
        this();
        this.mainList.setListData(vector);
        this.init();
    }

    public TN5250jMultiSelectList() {
        this(4);
    }

    public TN5250jMultiSelectList(int n) {
        this.mainList = new JList();
        this.mainList.addListSelectionListener(this.eventHandler);
        this.sourceList = new JList();
        this.sourceList.setSelectionMode(2);
        this.sourceList.addListSelectionListener(this.eventHandler);
        this.sourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TN5250jMultiSelectList.this.selectItem();
                }
            }
        });
        this.selectionList = new JList();
        this.selectionList.setSelectionMode(2);
        this.selectionList.addListSelectionListener(this.eventHandler);
        this.selectionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TN5250jMultiSelectList.this.deselectItem();
                }
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(11, 0, 0, 0));
        this.selectItemButton = this.initButton(new SelectionButton(SELECT_ITEM), LangTool.getString("oaa.AddSelected"));
        this.selectAllButton = this.initButton(new SelectionButton(SELECT_ALL), LangTool.getString("oaa.AddAll"));
        this.deselectItemButton = this.initButton(new SelectionButton(DESELECT_ITEM), LangTool.getString("oaa.RemoveSelected"));
        this.deselectAllButton = this.initButton(new SelectionButton(DESELECT_ALL), LangTool.getString("oaa.RemoveAll"));
        Dimension dimension = TN5250jMultiSelectList.getButtonSize();
        this.buttonPanel.setPreferredSize(new Dimension(dimension.width, 4 * dimension.height));
        this.setLayout(new FixedCenterLayout(n));
        this.sourcePanel = new JPanel();
        this.sourcePanel.setLayout(new BorderLayout());
        this.sourcePane = new JScrollPane(this.sourceList);
        this.sourcePane.setPreferredSize(this.defaultListSize);
        this.sourcePanel.add((Component)this.sourcePane, "Center");
        this.selectionPanel = new JPanel();
        this.selectionPanel.setLayout(new BorderLayout());
        this.selectionPane = new JScrollPane(this.selectionList);
        this.selectionPane.setPreferredSize(this.defaultListSize);
        this.selectionPanel.add((Component)this.selectionPane, "Center");
        this.add((Component)this.sourcePanel, "West");
        this.add((Component)this.selectionPanel, "East");
        this.add((Component)this.buttonPanel, "Center");
        this.setUI(new MultiSelectListUI());
    }

    @Override
    public void updateUI() {
        this.setUI(new MultiSelectListUI());
    }

    public Object getPrototypeCellValue() {
        return this.mainList.getPrototypeCellValue();
    }

    public void setPrototypeCellValue(Object object) {
        this.mainList.setPrototypeCellValue(object);
        this.sourceList.setPrototypeCellValue(object);
        this.selectionList.setPrototypeCellValue(object);
    }

    public int getFixedCellWidth() {
        return this.mainList.getFixedCellWidth();
    }

    public void setFixedCellWidth(int n) {
        this.mainList.setFixedCellWidth(n);
        this.sourceList.setFixedCellWidth(n);
        this.selectionList.setFixedCellWidth(n);
    }

    public int getFixedCellHeight() {
        return this.mainList.getFixedCellHeight();
    }

    public void setFixedCellHeight(int n) {
        this.mainList.setFixedCellHeight(n);
        this.sourceList.setFixedCellHeight(n);
        this.selectionList.setFixedCellHeight(n);
    }

    public ListCellRenderer getCellRenderer() {
        return this.mainList.getCellRenderer();
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.mainList.setCellRenderer(listCellRenderer);
        this.sourceList.setCellRenderer(listCellRenderer);
        this.selectionList.setCellRenderer(listCellRenderer);
    }

    public Color getSelectionForeground() {
        return this.mainList.getSelectionForeground();
    }

    public void setSelectionForeground(Color color) {
        this.mainList.setSelectionForeground(color);
        this.sourceList.setSelectionForeground(color);
        this.selectionList.setSelectionForeground(color);
    }

    public Color getSelectionBackground() {
        return this.mainList.getSelectionBackground();
    }

    public void setSelectionBackground(Color color) {
        this.mainList.setSelectionBackground(color);
        this.sourceList.setSelectionBackground(color);
        this.selectionList.setSelectionBackground(color);
    }

    public void setSourceColumnHeader(String string) {
        this.sourceColumnHeader = string;
        JViewport jViewport = new JViewport();
        jViewport.setView(new JLabel(string));
        this.sourcePane.setColumnHeader(jViewport);
    }

    public void setSelectionColumnHeader(String string) {
        this.selectionColumnHeader = string;
        JViewport jViewport = new JViewport();
        jViewport.setView(new JLabel(string));
        this.selectionPane.setColumnHeader(jViewport);
    }

    public void setSourceHeader(String string) {
        this.setSourceHeader(string, 2);
    }

    public void setSourceHeader(String string, int n) {
        this.sourceHeader = string;
        this.sourcePanel.add((Component)new JLabel(string, n), "North");
    }

    public void setSelectionHeader(String string) {
        this.setSelectionHeader(string, 2);
    }

    public void setSelectionHeader(String string, int n) {
        this.selectionHeader = string;
        this.selectionPanel.add((Component)new JLabel(string, n), "North");
    }

    public ListModel getModel() {
        return this.mainList.getModel();
    }

    public void setModel(ListModel listModel) {
        this.mainList.setModel(listModel);
        this.updateView();
    }

    public void setListData(Object[] objectArray) {
        this.mainList.setListData(objectArray);
        this.updateView();
    }

    public void setListData(Vector vector) {
        this.mainList.setListData(vector);
        this.updateView();
    }

    public ListSelectionModel getSelectionModel() {
        return this.mainList.getSelectionModel();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    protected void fireSelectionValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListSelectionListener.class) continue;
            if (listSelectionEvent == null) {
                listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
            }
            ((ListSelectionListener)objectArray[i + 1]).valueChanged(listSelectionEvent);
        }
    }

    public int getSelectionMode() {
        return this.mainList.getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.mainList.getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.mainList.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.mainList.getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int n) {
        return this.mainList.isSelectedIndex(n);
    }

    public boolean isSelectionEmpty() {
        return this.mainList.isSelectionEmpty();
    }

    public void clearSelection() {
        this.mainList.clearSelection();
        this.updateView();
    }

    public void setSelectionInterval(int n, int n2) {
        this.mainList.setSelectionInterval(n, n2);
        this.updateView();
    }

    public void addSelectionInterval(int n, int n2) {
        this.mainList.addSelectionInterval(n, n2);
        this.updateView();
    }

    public void removeSelectionInterval(int n, int n2) {
        this.mainList.removeSelectionInterval(n, n2);
        this.updateView();
    }

    public int getSelectedIndex() {
        return this.mainList.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        this.mainList.setSelectedIndex(n);
        this.updateView();
    }

    public int[] getSelectedIndices() {
        return this.mainList.getSelectedIndices();
    }

    public void setSelectedIndices(int[] nArray) {
        this.mainList.setSelectedIndices(nArray);
        this.updateView();
    }

    public Object[] getSelectedValues() {
        return this.mainList.getSelectedValues();
    }

    public Object getSelectedValue() {
        return this.mainList.getSelectedValue();
    }

    public void setSelectedValue(Object object, boolean bl) {
        this.mainList.setSelectedValue(object, bl);
        this.updateView();
    }

    @Override
    protected String paramString() {
        return super.paramString() + ", the list is: " + this.mainList;
    }

    protected SelectionButton initButton(SelectionButton selectionButton, String string) {
        if (selectionButton != null) {
            this.buttonPanel.add(selectionButton);
            selectionButton.addActionListener(this.eventHandler);
            selectionButton.setToolTipText(string);
        }
        return selectionButton;
    }

    protected void init() {
        this.updateView();
    }

    protected void updateView() {
        ListModel listModel = this.mainList.getModel();
        int[] nArray = this.mainList.getSelectedIndices();
        Vector vector = new Vector(listModel.getSize() - nArray.length);
        Vector vector2 = new Vector(nArray.length);
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (this.mainList.isSelectedIndex(i)) {
                vector2.addElement(listModel.getElementAt(i));
                continue;
            }
            vector.addElement(listModel.getElementAt(i));
        }
        this.sourceList.setListData(vector);
        this.selectionList.setListData(vector2);
        this.updateButtons();
    }

    public void updateButtons() {
        if (!this.sourceList.isEnabled()) {
            this.selectItemButton.setEnabled(false);
            this.selectAllButton.setEnabled(false);
            this.deselectItemButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
        } else {
            this.selectItemButton.setEnabled(!this.sourceList.isSelectionEmpty());
            this.selectAllButton.setEnabled(this.sourceList.getModel().getSize() > 0);
            this.deselectItemButton.setEnabled(!this.selectionList.isSelectionEmpty());
            this.deselectAllButton.setEnabled(this.selectionList.getModel().getSize() > 0);
        }
    }

    public static final Dimension getButtonSize() {
        return new Dimension(48, 32);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.sourcePane.getPreferredSize();
        Dimension dimension2 = this.selectionPane.getPreferredSize();
        Dimension dimension3 = this.buttonPanel.getPreferredSize();
        int n = dimension3.width + 2 * this.getListPreferredWidth();
        int n2 = Math.max(dimension3.height, Math.max(dimension.height, dimension2.height));
        return new Dimension(n, n2);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this.sourceList.getMinimumSize();
        Dimension dimension2 = this.selectionList.getMinimumSize();
        Dimension dimension3 = this.buttonPanel.getMinimumSize();
        int n = dimension3.width + dimension.width + dimension2.width;
        int n2 = Math.max(dimension3.height, Math.max(dimension.height, dimension2.height));
        return new Dimension(n, n2);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = this.sourceList.getMaximumSize();
        Dimension dimension2 = this.selectionList.getMaximumSize();
        Dimension dimension3 = this.buttonPanel.getMaximumSize();
        int n = dimension3.width + dimension.width + dimension2.width;
        int n2 = Math.max(dimension3.height, Math.max(dimension.height, dimension2.height));
        return new Dimension(n, n2);
    }

    @Override
    public void paint(Graphics graphics) {
        this.lastFontMetrics = graphics.getFontMetrics();
        super.paint(graphics);
    }

    public int getListPreferredWidth() {
        ListModel listModel = this.mainList.getModel();
        int n = 0;
        if (this.lastFontMetrics != null) {
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object e = listModel.getElementAt(i);
                if (!(e instanceof String)) continue;
                Math.max(this.lastFontMetrics.stringWidth((String)e), n);
            }
        }
        return n == 0 ? this.defaultListSize.width : n;
    }

    protected void selectItem() {
        int[] nArray = this.mainList.getSelectedIndices();
        Object[] objectArray = this.sourceList.getSelectedValues();
        int[] nArray2 = new int[nArray.length + objectArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        ListModel listModel = this.mainList.getModel();
        int n = nArray.length;
        for (int i = 0; i < listModel.getSize(); ++i) {
            Object e = listModel.getElementAt(i);
            for (int j = 0; j < objectArray.length; ++j) {
                if (e != objectArray[j]) continue;
                nArray2[n++] = i;
            }
        }
        this.doUpdate(this.sourceList, objectArray, nArray2);
    }

    protected void selectAll() {
        this.addSelectionInterval(0, this.mainList.getModel().getSize() - 1);
        this.updateView();
    }

    protected void deselectItem() {
        int[] nArray = this.mainList.getSelectedIndices();
        Object[] objectArray = this.selectionList.getSelectedValues();
        int[] nArray2 = new int[nArray.length - objectArray.length];
        ListModel listModel = this.mainList.getModel();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            Object e = listModel.getElementAt(nArray[i]);
            boolean bl = false;
            for (int j = 0; j < objectArray.length; ++j) {
                if (e != objectArray[j]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            nArray2[n++] = nArray[i];
        }
        this.doUpdate(this.selectionList, objectArray, nArray2);
    }

    protected void doUpdate(JList jList, Object[] objectArray, int[] nArray) {
        if (objectArray != null && objectArray.length > 0) {
            int n = this.getIndexFromItem(jList, objectArray[objectArray.length - 1]);
            this.mainList.setSelectedIndices(nArray);
            this.updateView();
            if ((n -= objectArray.length - 1) < jList.getModel().getSize()) {
                jList.setSelectedIndex(n);
            } else {
                jList.setSelectedIndex(jList.getModel().getSize() - 1);
            }
        }
    }

    public int getIndexFromItem(JList jList, Object object) {
        ListModel listModel = jList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Object e = listModel.getElementAt(i);
            if (!e.equals(object)) continue;
            return i;
        }
        return -1;
    }

    protected void deselectAll() {
        this.mainList.clearSelection();
        this.updateView();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.sourceList.setEnabled(bl);
        this.selectionList.setEnabled(bl);
        this.updateView();
    }

    protected class MultiSelectListUI
    extends ComponentUI {
        protected MultiSelectListUI() {
        }
    }

    class SelectionButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        SelectionButton(String string) {
            super(string);
            this.setEnabled(false);
            this.setMargin(new Insets(8, 8, 8, 8));
        }

        @Override
        public Dimension getPreferredSize() {
            return TN5250jMultiSelectList.getButtonSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private class EventHandler
    implements ActionListener,
    ListSelectionListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof SelectionButton) {
                SelectionButton selectionButton = (SelectionButton)actionEvent.getSource();
                if (selectionButton.equals(TN5250jMultiSelectList.this.selectItemButton)) {
                    TN5250jMultiSelectList.this.selectItem();
                } else if (selectionButton.equals(TN5250jMultiSelectList.this.selectAllButton)) {
                    TN5250jMultiSelectList.this.selectAll();
                } else if (selectionButton.equals(TN5250jMultiSelectList.this.deselectItemButton)) {
                    TN5250jMultiSelectList.this.deselectItem();
                } else if (selectionButton.equals(TN5250jMultiSelectList.this.deselectAllButton)) {
                    TN5250jMultiSelectList.this.deselectAll();
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == TN5250jMultiSelectList.this.mainList) {
                TN5250jMultiSelectList.this.fireSelectionValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
            }
            TN5250jMultiSelectList.this.updateButtons();
        }
    }
}

