/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.ImageIcon;
import org.tn5250j.tools.GUIGraphicsUtils;

public class TN5250jSplashScreen
extends Canvas {
    private static final long serialVersionUID = 1L;
    protected Window dialog = null;
    protected Frame f = null;
    protected Image image;
    private Image offScreenBuffer;
    private Graphics offScreenBufferGraphics;
    private int steps;
    private int progress;
    private Object lock = new Object();

    public TN5250jSplashScreen(String string) {
        this.initialize(GUIGraphicsUtils.createImageIcon(string));
    }

    public TN5250jSplashScreen(ImageIcon imageIcon) {
        this.initialize(imageIcon);
    }

    protected void initialize(ImageIcon imageIcon) {
        int n;
        this.image = imageIcon.getImage();
        if (this.image == null) {
            throw new IllegalArgumentException("Image specified is invalid.");
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        this.f = new Frame();
        this.dialog = new Window(this.f);
        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
        Dimension dimension = new Dimension(this.image.getWidth(this) + 2, this.image.getHeight(this) + 2);
        this.setSize(dimension);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setSize(dimension);
        this.dialog.add((Component)this, "Center");
        this.dialog.pack();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (dimension2.width - dimension.width) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (dimension2.height - dimension.height) / 2) < 0) {
            n = 0;
        }
        this.dialog.setLocation(n2, n);
        this.dialog.validate();
    }

    public void setSteps(int n) {
        this.steps = n;
    }

    public synchronized void updateProgress(int n) {
        if (this.dialog == null || this.f == null) {
            return;
        }
        this.progress = n;
        this.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            System.out.println(" updateProgress " + interruptedException.getMessage());
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        int n = 5;
        int n2 = 14;
        Dimension dimension = this.getSize();
        if (this.offScreenBuffer == null) {
            this.offScreenBuffer = this.createImage(dimension.width, dimension.height);
            this.offScreenBufferGraphics = this.offScreenBuffer.getGraphics();
        }
        this.offScreenBufferGraphics.drawImage(this.image, 1, 1, this);
        this.offScreenBufferGraphics.setColor(new Color(204, 204, 255));
        this.offScreenBufferGraphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
        this.offScreenBufferGraphics.setColor(new Color(204, 204, 255).darker());
        this.offScreenBufferGraphics.fill3DRect(n - 1, this.image.getHeight(this) - (n2 + 2), this.image.getWidth(this) - n * 2, n2 + 1, false);
        this.offScreenBufferGraphics.setColor(new Color(204, 204, 255));
        this.offScreenBufferGraphics.fillRect(n, this.image.getHeight(this) - (n2 + 1), (this.image.getWidth(this) - n * 2) / this.steps * this.progress, n2);
        graphics.drawImage(this.offScreenBuffer, 0, 0, this);
        this.notify();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && this.dialog != null && this.f != null && !this.dialog.isVisible()) {
            this.dialog.setVisible(true);
        } else {
            if (this.dialog != null) {
                this.updateProgress(this.steps + 1);
                this.dialog.setCursor(Cursor.getPredefinedCursor(0));
                this.dialog.dispose();
            }
            if (this.f != null) {
                this.f.dispose();
            }
            this.dialog = null;
            this.f = null;
        }
    }
}

