/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.tn5250j.event.ToggleDocumentListener;

public class ToggleDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    Vector<ToggleDocumentListener> listeners;

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        super.insertString(n, string, attributeSet);
        if (this.getText(0, this.getLength()).length() > 0) {
            this.fireNotEmpty();
        }
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        super.remove(n, n2);
        if (this.getText(0, this.getLength()).length() == 0) {
            this.fireEmpty();
        }
    }

    public synchronized void addToggleDocumentListener(ToggleDocumentListener toggleDocumentListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.addElement(toggleDocumentListener);
    }

    public synchronized void removeToggleDocumentListener(ToggleDocumentListener toggleDocumentListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(toggleDocumentListener);
    }

    public void fireNotEmpty() {
        if (this.listeners != null) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                ToggleDocumentListener toggleDocumentListener = this.listeners.elementAt(i);
                toggleDocumentListener.toggleNotEmpty();
            }
        }
    }

    public void fireEmpty() {
        if (this.listeners != null) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                ToggleDocumentListener toggleDocumentListener = this.listeners.elementAt(i);
                toggleDocumentListener.toggleEmpty();
            }
        }
    }
}

