/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.tn5250j.event.WizardEvent;
import org.tn5250j.event.WizardListener;
import org.tn5250j.gui.WizardPage;

public class Wizard
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected CardLayout cardLayout;
    protected transient Vector<WizardListener> listeners;
    protected transient ActionListener nextListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.next();
        }
    };
    protected transient ActionListener previousListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.previous();
        }
    };
    protected transient ActionListener finishListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.finish();
        }
    };
    protected transient ActionListener cancelListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.cancel();
        }
    };
    protected transient ActionListener helpListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.help();
        }
    };
    protected transient ContainerListener containerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof WizardPage) {
                WizardPage wizardPage = (WizardPage)containerEvent.getChild();
                JButton jButton = wizardPage.getNextButton();
                if (jButton != null) {
                    jButton.addActionListener(Wizard.this.nextListener);
                }
                if ((jButton = wizardPage.getPreviousButton()) != null) {
                    jButton.addActionListener(Wizard.this.previousListener);
                }
                if ((jButton = wizardPage.getFinishButton()) != null) {
                    jButton.addActionListener(Wizard.this.finishListener);
                }
                if ((jButton = wizardPage.getCancelButton()) != null) {
                    jButton.addActionListener(Wizard.this.cancelListener);
                }
                if ((jButton = wizardPage.getHelpButton()) != null) {
                    jButton.addActionListener(Wizard.this.helpListener);
                }
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof WizardPage) {
                WizardPage wizardPage = (WizardPage)containerEvent.getChild();
                JButton jButton = wizardPage.getNextButton();
                if (jButton != null) {
                    jButton.removeActionListener(Wizard.this.nextListener);
                }
                if ((jButton = wizardPage.getPreviousButton()) != null) {
                    jButton.removeActionListener(Wizard.this.previousListener);
                }
                if ((jButton = wizardPage.getFinishButton()) != null) {
                    jButton.removeActionListener(Wizard.this.finishListener);
                }
                if ((jButton = wizardPage.getCancelButton()) != null) {
                    jButton.removeActionListener(Wizard.this.cancelListener);
                }
                if ((jButton = wizardPage.getHelpButton()) != null) {
                    jButton.removeActionListener(Wizard.this.helpListener);
                }
            }
        }
    };

    public Wizard() {
        this.setLayout(new CardLayout());
        this.cardLayout = (CardLayout)this.getLayout();
        this.addContainerListener(this.containerListener);
    }

    public void show(String string) {
        this.cardLayout.show(this, string);
    }

    public void first() {
        this.cardLayout.first(this);
    }

    public void last() {
        this.cardLayout.last(this);
    }

    public boolean next() {
        WizardListener wizardListener;
        Object object;
        boolean bl = false;
        Component component = null;
        Component component2 = null;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            object = this.getComponent(i);
            if (!((Component)object).isVisible()) continue;
            component = object;
            if (i == n - 1) {
                bl = true;
                component2 = this.getComponent(0);
                break;
            }
            component2 = this.getComponent(i + 1);
            break;
        }
        WizardEvent wizardEvent = new WizardEvent(this, component, component2, bl, !bl);
        object = this.listeners.elements();
        while (object.hasMoreElements()) {
            wizardListener = (WizardListener)object.nextElement();
            wizardListener.nextBegin(wizardEvent);
        }
        if (!wizardEvent.getAllowChange()) {
            return false;
        }
        if (component2 != wizardEvent.getNewPage()) {
            this.cardLayout.show(this, wizardEvent.getNewPage().getName());
        } else {
            this.cardLayout.next(this);
        }
        object = this.listeners.elements();
        while (object.hasMoreElements()) {
            wizardListener = object.nextElement();
            wizardListener.nextComplete(wizardEvent);
        }
        return true;
    }

    public boolean previous() {
        WizardListener wizardListener;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        Component component = null;
        Component component2 = null;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            object = this.getComponent(i);
            if (!((Component)object).isVisible()) continue;
            component = object;
            if (i == n - 1) {
                bl = true;
            }
            if (i == 0) {
                component2 = this.getComponent(n - 1);
                bl2 = true;
                break;
            }
            component2 = this.getComponent(i - 1);
            break;
        }
        WizardEvent wizardEvent = new WizardEvent(this, component, component2, bl, !bl2);
        object = this.listeners.elements();
        while (object.hasMoreElements()) {
            wizardListener = (WizardListener)object.nextElement();
            wizardListener.previousBegin(wizardEvent);
        }
        if (!wizardEvent.getAllowChange()) {
            return false;
        }
        if (component2 != wizardEvent.getNewPage()) {
            this.cardLayout.show(this, wizardEvent.getNewPage().getName());
        } else {
            this.cardLayout.previous(this);
        }
        object = this.listeners.elements();
        while (object.hasMoreElements()) {
            wizardListener = object.nextElement();
            wizardListener.previousComplete(wizardEvent);
        }
        return true;
    }

    public boolean finish() {
        boolean bl = false;
        Component component = this.getCurrentPage();
        if (component == this.getComponent(this.getComponentCount() - 1)) {
            bl = true;
        }
        WizardEvent wizardEvent = new WizardEvent(this, component, null, bl, true);
        Enumeration<WizardListener> enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            WizardListener wizardListener = enumeration.nextElement();
            wizardListener.finished(wizardEvent);
        }
        return wizardEvent.getAllowChange();
    }

    public boolean cancel() {
        boolean bl = false;
        Component component = this.getCurrentPage();
        if (component == this.getComponent(this.getComponentCount() - 1)) {
            bl = true;
        }
        WizardEvent wizardEvent = new WizardEvent(this, component, null, bl, true);
        Enumeration<WizardListener> enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            WizardListener wizardListener = enumeration.nextElement();
            wizardListener.canceled(wizardEvent);
        }
        return wizardEvent.getAllowChange();
    }

    public void help() {
        boolean bl = false;
        Component component = this.getCurrentPage();
        if (component == this.getComponent(this.getComponentCount() - 1)) {
            bl = true;
        }
        WizardEvent wizardEvent = new WizardEvent(this, component, null, bl, true);
        Enumeration<WizardListener> enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            WizardListener wizardListener = enumeration.nextElement();
            wizardListener.help(wizardEvent);
        }
    }

    protected Component getCurrentPage() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            return component;
        }
        return null;
    }

    public void addWizardListener(WizardListener wizardListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.add(wizardListener);
    }

    public void removeWizardListener(WizardListener wizardListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(wizardListener);
    }

    @Override
    public Component add(Component component) {
        this.add(component, component.getName());
        return component;
    }
}

