/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.keyboard.KeyMapper;
import org.tn5250j.keyboard.KeyboardHandler;
import org.tn5250j.keyboard.actions.AttributesAction;
import org.tn5250j.keyboard.actions.CloseAction;
import org.tn5250j.keyboard.actions.CopyAction;
import org.tn5250j.keyboard.actions.DebugAction;
import org.tn5250j.keyboard.actions.DispMsgsAction;
import org.tn5250j.keyboard.actions.EmailAction;
import org.tn5250j.keyboard.actions.GuiAction;
import org.tn5250j.keyboard.actions.HotspotsAction;
import org.tn5250j.keyboard.actions.JumpNextAction;
import org.tn5250j.keyboard.actions.JumpPrevAction;
import org.tn5250j.keyboard.actions.NewSessionAction;
import org.tn5250j.keyboard.actions.OpenSameAction;
import org.tn5250j.keyboard.actions.PasteAction;
import org.tn5250j.keyboard.actions.PrintAction;
import org.tn5250j.keyboard.actions.QuickEmailAction;
import org.tn5250j.keyboard.actions.RulerAction;
import org.tn5250j.keyboard.actions.RunScriptAction;
import org.tn5250j.keyboard.actions.SpoolWorkAction;
import org.tn5250j.keyboard.actions.ToggleConnectionAction;
import org.tn5250j.keyboard.actions.TransferAction;

public class DefaultKeyboardHandler
extends KeyboardHandler {
    public DefaultKeyboardHandler(Session5250 session5250) {
        super(session5250);
    }

    @Override
    public boolean isKeyStrokeDefined(String string) {
        return KeyMapper.isKeyStrokeDefined(string);
    }

    @Override
    public KeyStroke getKeyStroke(String string) {
        return KeyMapper.getKeyStroke(string);
    }

    protected void displayInfo(KeyEvent keyEvent, String string) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        String string2 = Character.isISOControl(c) ? "key character = (an unprintable control character)" : "key character = '" + c + "'";
        String string3 = "key code = " + n + " (" + KeyEvent.getKeyText(n) + ")";
        if (n == 257) {
            string3 = string3 + " previous candidate ";
        }
        if (n == 134 || n == 136 || n == 129 || n == 133 || n == 130) {
            string3 = string3 + " dead key ";
        }
        String string4 = "modifiers = " + n2;
        String string5 = KeyEvent.getKeyModifiersText(n2);
        string4 = string5.length() > 0 ? string4 + " (" + string5 + ")" : string4 + " (no modifiers)";
        String string6 = "isKeys = isActionKey (" + keyEvent.isActionKey() + ")" + " isAltDown (" + keyEvent.isAltDown() + ")" + " isAltGraphDown (" + keyEvent.isAltGraphDown() + ")" + " isAltGraphDownLinux (" + this.isAltGr + ")" + " isControlDown (" + keyEvent.isControlDown() + ")" + " isMetaDown (" + keyEvent.isMetaDown() + ")" + " isShiftDown (" + keyEvent.isShiftDown() + ")";
        String string7 = "\n";
        System.out.println(string + string7 + "    " + string2 + string7 + "    " + string3 + string7 + "    " + string4 + string7 + "    " + string6 + string7);
    }

    @Override
    void initKeyBindings() {
        if (this.session.getGUI() == null) {
            return;
        }
        SessionPanel sessionPanel = this.session.getGUI();
        new NewSessionAction(sessionPanel, this.keyMap);
        new ToggleConnectionAction(sessionPanel, this.keyMap);
        new JumpNextAction(sessionPanel, this.keyMap);
        new JumpPrevAction(sessionPanel, this.keyMap);
        new HotspotsAction(sessionPanel, this.keyMap);
        new GuiAction(sessionPanel, this.keyMap);
        new DispMsgsAction(sessionPanel, this.keyMap);
        new AttributesAction(sessionPanel, this.keyMap);
        new PrintAction(sessionPanel, this.keyMap);
        new RulerAction(sessionPanel, this.keyMap);
        new CloseAction(sessionPanel, this.keyMap);
        new TransferAction(sessionPanel, this.keyMap);
        new EmailAction(sessionPanel, this.keyMap);
        new RunScriptAction(sessionPanel, this.keyMap);
        new DebugAction(sessionPanel, this.keyMap);
        new CopyAction(sessionPanel, this.keyMap);
        new PasteAction(sessionPanel, this.keyMap);
        new SpoolWorkAction(sessionPanel, this.keyMap);
        new QuickEmailAction(sessionPanel, this.keyMap);
        new OpenSameAction(sessionPanel, this.keyMap);
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        switch (keyEvent.getID()) {
            case 400: {
                this.processVTKeyTyped(keyEvent);
                break;
            }
            case 401: {
                this.processVTKeyPressed(keyEvent);
                break;
            }
            case 402: {
                this.processVTKeyReleased(keyEvent);
            }
        }
    }

    private void processVTKeyPressed(KeyEvent keyEvent) {
        this.keyProcessed = true;
        int n = keyEvent.getKeyCode();
        if (this.isLinux && n == 65406) {
            this.isAltGr = true;
        }
        if (n == 20 || n == 16 || n == 18 || n == 65406) {
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), false);
        if (this.emulatorAction(keyStroke, keyEvent)) {
            return;
        }
        this.lastKeyStroke = this.isLinux ? KeyMapper.getKeyStrokeText(keyEvent, this.isAltGr) : KeyMapper.getKeyStrokeText(keyEvent);
        if (this.lastKeyStroke != null && !this.lastKeyStroke.equals("null")) {
            if (this.lastKeyStroke.startsWith("[") || this.lastKeyStroke.length() == 1) {
                this.screen.sendKeys(this.lastKeyStroke);
                if (this.recording) {
                    this.recordBuffer.append(this.lastKeyStroke);
                }
            } else {
                this.session.getGUI().executeMacro(this.lastKeyStroke);
            }
            if (this.lastKeyStroke.startsWith("[mark") && (this.lastKeyStroke.equals("[markleft]") || this.lastKeyStroke.equals("[markright]") || this.lastKeyStroke.equals("[markup]") || this.lastKeyStroke.equals("[markdown]"))) {
                this.session.getGUI().doKeyBoundArea(keyEvent, this.lastKeyStroke);
            }
        } else {
            this.keyProcessed = false;
        }
        if (this.keyProcessed) {
            keyEvent.consume();
        }
    }

    private void processVTKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this.isLinux ? (!Character.isLetter(c) && c != '\u20ac' || keyEvent.getModifiers() != 0 && keyEvent.getModifiers() != 1) && (Character.isISOControl(c) || this.keyProcessed) : Character.isISOControl(c) || this.keyProcessed) {
            return;
        }
        String string = "";
        string = string + c;
        if (!this.session.isConnected()) {
            return;
        }
        this.screen.sendKeys(string);
        if (this.recording) {
            this.recordBuffer.append(string);
        }
        this.keyProcessed = true;
        keyEvent.consume();
    }

    private void processVTKeyReleased(KeyEvent keyEvent) {
        if (this.isLinux && keyEvent.getKeyCode() == 65406) {
            this.isAltGr = false;
        }
        if (Character.isISOControl(keyEvent.getKeyChar()) || this.keyProcessed || keyEvent.isConsumed()) {
            return;
        }
        String string = KeyMapper.getKeyStrokeText(keyEvent);
        if (string != null) {
            if (string.startsWith("[")) {
                this.screen.sendKeys(string);
                if (this.recording) {
                    this.recordBuffer.append(string);
                }
            } else {
                this.session.getGUI().executeMacro(string);
            }
        } else {
            this.keyProcessed = false;
        }
        if (this.keyProcessed) {
            keyEvent.consume();
        }
    }
}

