/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard;

import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.KeyStroke;
import org.tn5250j.event.KeyChangeListener;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.interfaces.OptionAccessFactory;
import org.tn5250j.keyboard.KeyStroker;
import org.tn5250j.tools.LangTool;

public class KeyMapper {
    private static HashMap<KeyStroker, String> mappedKeys;
    private static KeyStroker workStroke;
    private static String lastKeyMnemonic;
    private static Vector<KeyChangeListener> listeners;

    public static void init() {
        if (mappedKeys != null) {
            return;
        }
        mappedKeys = new HashMap(60);
        workStroke = new KeyStroker(0, false, false, false, false, 1);
        Properties properties = ConfigureFactory.getInstance().getProperties("keymap");
        if (!KeyMapper.loadKeyStrokes(properties)) {
            mappedKeys.put(new KeyStroker(10, false, false, false, false, 1), "[enter]");
            mappedKeys.put(new KeyStroker(10, false, false, false, false, 4), "[enter].alt2");
            mappedKeys.put(new KeyStroker(8, false, false, false, false, 1), "[backspace]");
            mappedKeys.put(new KeyStroker(9, false, false, false, false, 1), "[tab]");
            mappedKeys.put(new KeyStroker(9, true, false, false, false, 1), "[backtab]");
            mappedKeys.put(new KeyStroker(127, false, false, false, false, 1), "[delete]");
            mappedKeys.put(new KeyStroker(155, false, false, false, false, 1), "[insert]");
            mappedKeys.put(new KeyStroker(19, false, false, false, false, 1), "[clear]");
            mappedKeys.put(new KeyStroker(17, false, true, false, false, 2), "[reset]");
            mappedKeys.put(new KeyStroker(27, false, false, false, false, 1), "[sysreq]");
            mappedKeys.put(new KeyStroker(35, false, false, false, false, 1), "[eof]");
            mappedKeys.put(new KeyStroker(36, false, false, false, false, 1), "[home]");
            mappedKeys.put(new KeyStroker(39, false, false, false, false, 1), "[right]");
            mappedKeys.put(new KeyStroker(39, false, false, true, false, 1), "[nextword]");
            mappedKeys.put(new KeyStroker(37, false, false, false, false, 1), "[left]");
            mappedKeys.put(new KeyStroker(37, false, false, true, false, 1), "[prevword]");
            mappedKeys.put(new KeyStroker(38, false, false, false, false, 1), "[up]");
            mappedKeys.put(new KeyStroker(40, false, false, false, false, 1), "[down]");
            mappedKeys.put(new KeyStroker(34, false, false, false, false, 1), "[pgdown]");
            mappedKeys.put(new KeyStroker(33, false, false, false, false, 1), "[pgup]");
            mappedKeys.put(new KeyStroker(96, false, false, false, false, 1), "[keypad0]");
            mappedKeys.put(new KeyStroker(97, false, false, false, false, 1), "[keypad1]");
            mappedKeys.put(new KeyStroker(98, false, false, false, false, 1), "[keypad2]");
            mappedKeys.put(new KeyStroker(99, false, false, false, false, 1), "[keypad3]");
            mappedKeys.put(new KeyStroker(100, false, false, false, false, 1), "[keypad4]");
            mappedKeys.put(new KeyStroker(101, false, false, false, false, 1), "[keypad5]");
            mappedKeys.put(new KeyStroker(102, false, false, false, false, 1), "[keypad6]");
            mappedKeys.put(new KeyStroker(103, false, false, false, false, 1), "[keypad7]");
            mappedKeys.put(new KeyStroker(104, false, false, false, false, 1), "[keypad8]");
            mappedKeys.put(new KeyStroker(105, false, false, false, false, 1), "[keypad9]");
            mappedKeys.put(new KeyStroker(109, false, false, false, false, 1), "[field-]");
            mappedKeys.put(new KeyStroker(107, false, false, false, false, 1), "[field+]");
            mappedKeys.put(new KeyStroker(112, false, false, false, false, 1), "[pf1]");
            mappedKeys.put(new KeyStroker(113, false, false, false, false, 1), "[pf2]");
            mappedKeys.put(new KeyStroker(114, false, false, false, false, 1), "[pf3]");
            mappedKeys.put(new KeyStroker(115, false, false, false, false, 1), "[pf4]");
            mappedKeys.put(new KeyStroker(116, false, false, false, false, 1), "[pf5]");
            mappedKeys.put(new KeyStroker(117, false, false, false, false, 1), "[pf6]");
            mappedKeys.put(new KeyStroker(118, false, false, false, false, 1), "[pf7]");
            mappedKeys.put(new KeyStroker(119, false, false, false, false, 1), "[pf8]");
            mappedKeys.put(new KeyStroker(120, false, false, false, false, 1), "[pf9]");
            mappedKeys.put(new KeyStroker(121, false, false, false, false, 1), "[pf10]");
            mappedKeys.put(new KeyStroker(122, false, false, false, false, 1), "[pf11]");
            mappedKeys.put(new KeyStroker(123, false, false, false, false, 1), "[pf12]");
            mappedKeys.put(new KeyStroker(112, true, false, false, false, 1), "[pf13]");
            mappedKeys.put(new KeyStroker(113, true, false, false, false, 1), "[pf14]");
            mappedKeys.put(new KeyStroker(114, true, false, false, false, 1), "[pf15]");
            mappedKeys.put(new KeyStroker(115, true, false, false, false, 1), "[pf16]");
            mappedKeys.put(new KeyStroker(116, true, false, false, false, 1), "[pf17]");
            mappedKeys.put(new KeyStroker(117, true, false, false, false, 1), "[pf18]");
            mappedKeys.put(new KeyStroker(118, true, false, false, false, 1), "[pf19]");
            mappedKeys.put(new KeyStroker(119, true, false, false, false, 1), "[pf20]");
            mappedKeys.put(new KeyStroker(120, true, false, false, false, 1), "[pf21]");
            mappedKeys.put(new KeyStroker(121, true, false, false, false, 1), "[pf22]");
            mappedKeys.put(new KeyStroker(122, true, false, false, false, 1), "[pf23]");
            mappedKeys.put(new KeyStroker(123, true, false, false, false, 1), "[pf24]");
            mappedKeys.put(new KeyStroker(112, false, false, true, false, 1), "[help]");
            mappedKeys.put(new KeyStroker(72, false, false, true, false, 1), "[hostprint]");
            mappedKeys.put(new KeyStroker(67, false, true, false, false, 1), "[copy]");
            mappedKeys.put(new KeyStroker(86, false, false, true, false, 1), "[paste]");
            mappedKeys.put(new KeyStroker(39, true, false, false, false, 1), "[markright]");
            mappedKeys.put(new KeyStroker(37, true, false, false, false, 1), "[markleft]");
            mappedKeys.put(new KeyStroker(38, true, false, false, false, 1), "[markup]");
            mappedKeys.put(new KeyStroker(40, true, false, false, false, 1), "[markdown]");
            mappedKeys.put(new KeyStroker(155, true, false, false, false, 1), "[dupfield]");
            mappedKeys.put(new KeyStroker(17, true, true, false, false, 1), "[newline]");
            mappedKeys.put(new KeyStroker(34, false, false, true, false, 1), "[jumpnext]");
            mappedKeys.put(new KeyStroker(33, false, false, true, false, 1), "[jumpprev]");
            KeyMapper.saveKeyMap();
        } else {
            KeyMapper.setKeyMap(properties);
        }
    }

    private static boolean loadKeyStrokes(Properties properties) {
        properties = ConfigureFactory.getInstance().getProperties("keymap");
        return properties != null && properties.size() > 0;
    }

    private static void parseKeyStrokes(Properties properties) {
        String string = "";
        String string2 = "";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (OptionAccessFactory.getInstance().isRestrictedOption(string2)) continue;
            string = properties.getProperty(string2);
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n2 = 1;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            n = Integer.parseInt(stringTokenizer.nextToken());
            bl = stringTokenizer.nextToken().equals("true");
            bl2 = stringTokenizer.nextToken().equals("true");
            bl3 = stringTokenizer.nextToken().equals("true");
            if (stringTokenizer.hasMoreTokens()) {
                bl4 = stringTokenizer.nextToken().equals("true");
                if (stringTokenizer.hasMoreTokens()) {
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                }
            }
            mappedKeys.put(new KeyStroker(n, bl, bl2, bl3, bl4, n2), string2);
        }
    }

    protected static void setKeyMap(Properties properties) {
        KeyMapper.parseKeyStrokes(properties);
    }

    public static final boolean isEqualLast(KeyEvent keyEvent) {
        return workStroke.equals(keyEvent);
    }

    public static final void saveKeyMap() {
        Properties properties = ConfigureFactory.getInstance().getProperties("keymap");
        properties.clear();
        Collection<String> collection = mappedKeys.values();
        Set<KeyStroker> set = mappedKeys.keySet();
        Iterator<KeyStroker> iterator = set.iterator();
        Iterator<String> iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            KeyStroker keyStroker = iterator.next();
            properties.put(iterator2.next(), keyStroker.toString());
        }
        ConfigureFactory.getInstance().saveSettings("keymap", "------ Key Map key=keycode,isShiftDown,isControlDown,isAltDown,isAltGrDown,location --------");
    }

    public static final String getKeyStrokeText(KeyEvent keyEvent) {
        return KeyMapper.getKeyStrokeText(keyEvent, false);
    }

    public static final String getKeyStrokeText(KeyEvent keyEvent, boolean bl) {
        if (!workStroke.equals(keyEvent, bl)) {
            workStroke.setAttributes(keyEvent, bl);
            lastKeyMnemonic = mappedKeys.get(workStroke);
        }
        if (lastKeyMnemonic != null && lastKeyMnemonic.endsWith(".alt2")) {
            lastKeyMnemonic = lastKeyMnemonic.substring(0, lastKeyMnemonic.indexOf(".alt2"));
        }
        return lastKeyMnemonic;
    }

    public static final String getKeyStrokeMnemonic(KeyEvent keyEvent) {
        return KeyMapper.getKeyStrokeMnemonic(keyEvent, false);
    }

    public static final String getKeyStrokeMnemonic(KeyEvent keyEvent, boolean bl) {
        workStroke.setAttributes(keyEvent, bl);
        String string = mappedKeys.get(workStroke);
        if (string != null && string.endsWith(".alt2")) {
            string = string.substring(0, string.indexOf(".alt2"));
        }
        return string;
    }

    public static final int getKeyStrokeCode() {
        return workStroke.hashCode();
    }

    public static final String getKeyStrokeDesc(String string) {
        Collection<String> collection = mappedKeys.values();
        Set<KeyStroker> set = mappedKeys.keySet();
        Iterator<KeyStroker> iterator = set.iterator();
        Iterator<String> iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            KeyStroker keyStroker = iterator.next();
            String string2 = iterator2.next();
            if (!string2.equals(string)) continue;
            return keyStroker.getKeyStrokeDesc();
        }
        return LangTool.getString("key.dead");
    }

    public static final KeyStroker getKeyStroker(String string) {
        Collection<String> collection = mappedKeys.values();
        Set<KeyStroker> set = mappedKeys.keySet();
        Iterator<KeyStroker> iterator = set.iterator();
        Iterator<String> iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            KeyStroker keyStroker = iterator.next();
            String string2 = iterator2.next();
            if (!string2.equals(string)) continue;
            return keyStroker;
        }
        return null;
    }

    public static final boolean isKeyStrokeDefined(String string) {
        Collection<String> collection = mappedKeys.values();
        Set<KeyStroker> set = mappedKeys.keySet();
        Iterator<KeyStroker> iterator = set.iterator();
        Iterator<String> iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            String string2 = iterator2.next();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isKeyStrokeDefined(KeyEvent keyEvent) {
        return KeyMapper.isKeyStrokeDefined(keyEvent, false);
    }

    public static final boolean isKeyStrokeDefined(KeyEvent keyEvent, boolean bl) {
        workStroke.setAttributes(keyEvent, bl);
        return null != mappedKeys.get(workStroke);
    }

    public static final KeyStroke getKeyStroke(String string) {
        Collection<String> collection = mappedKeys.values();
        Set<KeyStroker> set = mappedKeys.keySet();
        Iterator<KeyStroker> iterator = set.iterator();
        Iterator<String> iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            KeyStroker keyStroker = iterator.next();
            String string2 = iterator2.next();
            if (!string2.equals(string)) continue;
            int n = 0;
            if (keyStroker.isShiftDown()) {
                n |= 1;
            }
            if (keyStroker.isControlDown()) {
                n |= 2;
            }
            if (keyStroker.isAltDown()) {
                n |= 8;
            }
            if (keyStroker.isAltGrDown()) {
                n |= 0x20;
            }
            return KeyStroke.getKeyStroke(keyStroker.getKeyCode(), n);
        }
        return KeyStroke.getKeyStroke(0, 0);
    }

    public static final void removeKeyStroke(String string) {
        Collection<String> collection = mappedKeys.values();
        Set<KeyStroker> set = mappedKeys.keySet();
        Iterator<KeyStroker> iterator = set.iterator();
        Iterator<String> iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            KeyStroker keyStroker = iterator.next();
            String string2 = iterator2.next();
            if (!string2.equals(string)) continue;
            mappedKeys.remove(keyStroker);
            return;
        }
    }

    public static final void setKeyStroke(String string, KeyEvent keyEvent) {
        if (keyEvent == null) {
            return;
        }
        Collection<String> collection = mappedKeys.values();
        Set<KeyStroker> set = mappedKeys.keySet();
        Iterator<KeyStroker> iterator = set.iterator();
        Iterator<String> iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            KeyStroker keyStroker = iterator.next();
            String string2 = iterator2.next();
            if (!string2.equals(string)) continue;
            mappedKeys.remove(keyStroker);
            mappedKeys.put(new KeyStroker(keyEvent), string2);
            return;
        }
        mappedKeys.put(new KeyStroker(keyEvent), string);
    }

    public static final void setKeyStroke(String string, KeyEvent keyEvent, boolean bl) {
        if (keyEvent == null) {
            return;
        }
        Collection<String> collection = mappedKeys.values();
        Set<KeyStroker> set = mappedKeys.keySet();
        Iterator<KeyStroker> iterator = set.iterator();
        Iterator<String> iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            KeyStroker keyStroker = iterator.next();
            String string2 = iterator2.next();
            if (!string2.equals(string)) continue;
            mappedKeys.remove(keyStroker);
            mappedKeys.put(new KeyStroker(keyEvent, bl), string2);
            return;
        }
        mappedKeys.put(new KeyStroker(keyEvent, bl), string);
    }

    public static final HashMap<KeyStroker, String> getKeyMap() {
        return mappedKeys;
    }

    public static synchronized void addKeyChangeListener(KeyChangeListener keyChangeListener) {
        if (listeners == null) {
            listeners = new Vector(3);
        }
        listeners.addElement(keyChangeListener);
    }

    public synchronized void removeKeyChangeListener(KeyChangeListener keyChangeListener) {
        if (listeners == null) {
            return;
        }
        listeners.removeElement(keyChangeListener);
    }

    public static void fireKeyChangeEvent() {
        if (listeners != null) {
            int n = listeners.size();
            for (int i = 0; i < n; ++i) {
                KeyChangeListener keyChangeListener = listeners.elementAt(i);
                keyChangeListener.onKeyChanged();
            }
        }
    }
}

