/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.KeyChangeListener;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.keyboard.DefaultKeyboardHandler;
import org.tn5250j.keyboard.KeyMapper;
import org.tn5250j.tools.system.OperatingSystem;

public abstract class KeyboardHandler
extends KeyAdapter
implements KeyChangeListener {
    protected Session5250 session;
    protected SessionPanel sessionGui;
    protected Screen5250 screen;
    protected boolean isLinux;
    protected boolean isAltGr;
    protected boolean keyProcessed = false;
    protected KeyMapper keyMap;
    protected String lastKeyStroke = null;
    protected StringBuffer recordBuffer;
    protected boolean recording;

    public KeyboardHandler(Session5250 session5250) {
        this.session = session5250;
        this.screen = session5250.getScreen();
        this.sessionGui = session5250.getGUI();
        this.isLinux = OperatingSystem.isUnix();
        this.keyMap = new KeyMapper();
        KeyMapper.init();
        KeyMapper.addKeyChangeListener(this);
        this.initKeyBindings();
    }

    public static KeyboardHandler getKeyboardHandlerInstance(Session5250 session5250) {
        return new DefaultKeyboardHandler(session5250);
    }

    abstract void initKeyBindings();

    protected InputMap getInputMap() {
        return this.sessionGui.getInputMap();
    }

    protected ActionMap getActionMap() {
        return this.sessionGui.getActionMap();
    }

    @Override
    public void onKeyChanged() {
        this.getInputMap().clear();
        this.getActionMap().clear();
        this.initKeyBindings();
    }

    public abstract boolean isKeyStrokeDefined(String var1);

    public abstract KeyStroke getKeyStroke(String var1);

    public String getRecordBuffer() {
        return this.recordBuffer.toString();
    }

    public void startRecording() {
        this.recording = true;
        this.recordBuffer = new StringBuffer();
    }

    public void stopRecording() {
        this.recording = false;
        this.recordBuffer = null;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void sessionClosed(SessionPanel sessionPanel) {
        this.keyMap.removeKeyChangeListener(this);
    }

    protected boolean emulatorAction(KeyStroke keyStroke, KeyEvent keyEvent) {
        if (this.sessionGui == null) {
            return false;
        }
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null && this.sessionGui.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                return true;
            }
        }
        return false;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 400: {
                this.keyTyped(keyEvent);
                break;
            }
            case 401: {
                this.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyReleased(keyEvent);
            }
        }
    }
}

