/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.tn5250j.SessionPanel;
import org.tn5250j.interfaces.OptionAccessFactory;
import org.tn5250j.keyboard.KeyMapper;

public abstract class EmulatorAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected SessionPanel session;

    public EmulatorAction(SessionPanel sessionPanel, String string) {
        super(string);
        this.session = sessionPanel;
    }

    public EmulatorAction(SessionPanel sessionPanel, String string, KeyStroke keyStroke, KeyMapper keyMapper) {
        this(sessionPanel, string);
        this.setKeyStroke(string, keyStroke, keyMapper);
    }

    protected void setKeyStroke(String string, KeyStroke keyStroke, KeyMapper keyMapper) {
        if (OptionAccessFactory.getInstance().isRestrictedOption(string)) {
            return;
        }
        if (KeyMapper.isKeyStrokeDefined(string)) {
            keyStroke = KeyMapper.getKeyStroke(string);
        }
        this.session.getInputMap().put(keyStroke, string);
        this.session.getActionMap().put(string, this);
        if (KeyMapper.isKeyStrokeDefined(string + ".alt2")) {
            keyStroke = KeyMapper.getKeyStroke(string + ".alt2");
            this.session.getInputMap().put(keyStroke, string);
            this.session.getActionMap().put(string, this);
        }
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);
}

