/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard.actions;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.KeyStroke;
import org.tn5250j.SessionPanel;
import org.tn5250j.keyboard.KeyMapper;
import org.tn5250j.keyboard.actions.EmulatorAction;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class PasteAction
extends EmulatorAction {
    private static final long serialVersionUID = 1L;
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public PasteAction(SessionPanel sessionPanel, KeyMapper keyMapper) {
        super(sessionPanel, "[paste]", KeyStroke.getKeyStroke(86, 8), keyMapper);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            if (transferable != null) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.session.getScreen().pasteText(string, false);
            }
        }
        catch (HeadlessException headlessException) {
            this.log.debug("HeadlessException", headlessException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.log.debug("the requested data flavor is not supported", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            this.log.debug("data is no longer available in the requested flavor", iOException);
        }
    }
}

