/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard.configure;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tn5250j.TN5250jConstants;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.keyboard.KeyMapper;
import org.tn5250j.keyboard.configure.KeyGetter;
import org.tn5250j.keyboard.configure.KeyGetterInterface;
import org.tn5250j.scripting.InterpreterDriverManager;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.system.OperatingSystem;

public class KeyConfigure
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -421661235666776519L;
    private JPanel keyPanel = new JPanel();
    private JPanel options = new JPanel();
    private JTextArea strokeDesc = new JTextArea();
    private JTextArea strokeDescAlt = new JTextArea();
    private JLabel strokeLocation = new JLabel();
    private JLabel strokeLocationAlt = new JLabel();
    private JList functions;
    private JDialog dialog;
    private boolean mods;
    private String[] macrosList;
    private DefaultListModel lm = new DefaultListModel();
    private boolean macros;
    private boolean special;
    private ICodePage codePage;
    private boolean isLinux;
    private boolean isAltGr;
    private boolean altKey;
    private static final SortedMap<Integer, String> colorMap = new TreeMap<Integer, String>();

    public KeyConfigure(Frame frame, String[] stringArray, ICodePage iCodePage) {
        super(frame);
        this.codePage = iCodePage;
        this.macrosList = stringArray;
        if (OperatingSystem.isUnix() && !OperatingSystem.isMacOS()) {
            this.isLinux = true;
        }
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        BorderLayout borderLayout = new BorderLayout();
        KeyMapper.init();
        this.keyPanel.setLayout(borderLayout);
        this.keyPanel.add((Component)this.createFunctionsPanel(), "West");
        this.keyPanel.add((Component)this.createMappingPanel(), "Center");
        this.getContentPane().add((Component)this.keyPanel, "Center");
        this.getContentPane().add((Component)this.options, "South");
        this.addOptButton(LangTool.getString("key.labelDone", "Done"), "DONE", this.options, true);
        this.setModal(true);
        this.setTitle(LangTool.getString("key.title"));
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
    }

    private JPanel createFunctionsPanel() {
        this.functions = new JList(this.lm);
        this.functions.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    KeyConfigure.this.setKeyDescription(KeyConfigure.this.functions.getSelectedIndex());
                }
            }
        });
        this.loadList(LangTool.getString("key.labelKeys"));
        this.functions.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.functions);
        JPanel jPanel = new JPanel();
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(LangTool.getString("key.labelKeys"));
        jComboBox.addItem(LangTool.getString("key.labelMacros"));
        jComboBox.addItem(LangTool.getString("key.labelSpecial"));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                KeyConfigure.this.loadList((String)jComboBox.getSelectedItem());
            }
        });
        jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("key.labelDesc")));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jComboBox);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private JPanel createMappingPanel() {
        this.strokeDesc.setColumns(30);
        this.strokeDesc.setBackground(this.functions.getBackground());
        this.strokeDesc.setEditable(false);
        this.strokeDescAlt.setColumns(30);
        this.strokeDescAlt.setBackground(this.functions.getBackground());
        this.strokeDescAlt.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("key.labelMapTo")));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new AlignLayout(3, 5, 5));
        jPanel3.add(this.strokeDesc);
        this.addOptButton(LangTool.getString("key.labelMap", "Map Key"), "MAP-Prime", jPanel3, true);
        this.addOptButton(LangTool.getString("key.labelRemove", "Remove"), "REMOVE-Prime", jPanel3, true);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.strokeLocation, "North");
        jPanel2.add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new AlignLayout(3, 5, 5));
        jPanel6.add(this.strokeDescAlt);
        this.addOptButton(LangTool.getString("key.labelMap", "Map Key"), "MAP-Alt", jPanel6, true);
        this.addOptButton(LangTool.getString("key.labelRemove", "Remove"), "REMOVE-Alt", jPanel6, true);
        jPanel5.add((Component)jPanel6, "North");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)this.strokeLocationAlt, "North");
        jPanel5.add((Component)jPanel7, "Center");
        jPanel.add(jPanel2);
        jPanel.add(jPanel5);
        return jPanel;
    }

    private void setKeyDescription(int n) {
        try {
            if (!this.macros && !this.special) {
                KeyDescription keyDescription = (KeyDescription)this.lm.getElementAt(n);
                this.setKeyInformation(TN5250jConstants.mnemonicData[keyDescription.getIndex()]);
            } else {
                Object object;
                if (this.macros) {
                    object = this.lm.getElementAt(n);
                    if (object instanceof String) {
                        System.out.println((String)object);
                        this.setKeyInformation((String)object);
                    } else if (object instanceof Macro) {
                        Macro macro = (Macro)object;
                        this.setKeyInformation(macro.getFullName());
                    }
                }
                if (this.special) {
                    System.out.println((String)this.lm.getElementAt(n));
                    object = this.parseSpecialCharacter((String)this.lm.getElementAt(n));
                    this.setKeyInformation((String)object);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("ar at index " + n + " - " + arrayIndexOutOfBoundsException.getMessage());
        }
    }

    private void setKeyInformation(String string) {
        if (string.endsWith(".alt2")) {
            string = string.substring(0, string.indexOf(".alt2"));
        }
        this.strokeDesc.setText(KeyMapper.getKeyStrokeDesc(string));
        this.strokeDescAlt.setText(KeyMapper.getKeyStrokeDesc(string + ".alt2"));
        this.strokeLocation.setText(this.getLocationDesc(string));
        this.strokeLocationAlt.setText(this.getLocationDesc(string + ".alt2"));
    }

    private String getLocationDesc(String string) {
        String string2 = LangTool.getString("key.labelLocUnknown");
        if (KeyMapper.isKeyStrokeDefined(string)) {
            switch (KeyMapper.getKeyStroker(string).getLocation()) {
                case 2: {
                    string2 = LangTool.getString("key.labelLocLeft");
                    break;
                }
                case 3: {
                    string2 = LangTool.getString("key.labelLocRight");
                    break;
                }
                case 1: {
                    string2 = LangTool.getString("key.labelLocStandard");
                    break;
                }
                case 4: {
                    string2 = LangTool.getString("key.labelLocNumPad");
                }
            }
        }
        return string2;
    }

    private String parseSpecialCharacter(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            return String.valueOf(string.charAt(string2.length() + 2));
        }
        return "";
    }

    private void loadList(String string) {
        this.lm.clear();
        this.lm.removeAllElements();
        if (string.equals(LangTool.getString("key.labelKeys"))) {
            int n;
            Vector<KeyDescription> vector = new Vector<KeyDescription>(TN5250jConstants.mnemonicData.length);
            for (n = 0; n < TN5250jConstants.mnemonicData.length; ++n) {
                vector.addElement(new KeyDescription(LangTool.getString("key." + TN5250jConstants.mnemonicData[n]), n));
            }
            Collections.sort(vector, new KeyDescriptionCompare());
            for (n = 0; n < TN5250jConstants.mnemonicData.length; ++n) {
                this.lm.addElement(vector.get(n));
            }
            this.macros = false;
            this.special = false;
        } else if (string.equals(LangTool.getString("key.labelMacros"))) {
            Vector<String> vector = new Vector<String>();
            if (this.macrosList != null) {
                for (int i = 0; i < this.macrosList.length; ++i) {
                    vector.add(this.macrosList[i]);
                }
            }
            KeyConfigure.scriptDir("scripts", vector);
            KeyConfigure.loadListModel(this.lm, vector, null, 0);
            this.macros = true;
            this.special = false;
        } else {
            Collator collator = Collator.getInstance();
            CollationKey collationKey = null;
            StringBuffer stringBuffer = new StringBuffer();
            TreeSet<CollationKey> treeSet = new TreeSet<CollationKey>();
            this.supportAplColorCodesInSEU(collator, stringBuffer, treeSet);
            for (int i = 0; i < 256; ++i) {
                char c = this.codePage.ebcdic2uni(i);
                char c2 = this.codePage.ebcdic2uni(i);
                if (Character.isISOControl(c)) continue;
                stringBuffer.setLength(0);
                if (Integer.toHexString(c2).length() == 1) {
                    stringBuffer.append("0x0" + Integer.toHexString(c2).toUpperCase());
                } else {
                    stringBuffer.append("0x" + Integer.toHexString(c2).toUpperCase());
                }
                stringBuffer.append(" - " + c + " - " + this.getUnicodeString(c));
                collationKey = collator.getCollationKey(stringBuffer.toString());
                treeSet.add(collationKey);
            }
            for (CollationKey collationKey2 : treeSet) {
                this.lm.addElement(collationKey2.getSourceString());
            }
            this.macros = false;
            this.special = true;
        }
        if (!this.lm.isEmpty()) {
            this.functions.setSelectedIndex(0);
        }
    }

    private void supportAplColorCodesInSEU(Collator collator, StringBuffer stringBuffer, Set<CollationKey> set) {
        for (Map.Entry<Integer, String> entry : colorMap.entrySet()) {
            int n = entry.getKey();
            char c = (char)(65280 + n);
            stringBuffer.setLength(0);
            stringBuffer.append("0FF" + Integer.toHexString(n).toUpperCase());
            stringBuffer.append(" - " + c + " - " + entry.getValue());
            CollationKey collationKey = collator.getCollationKey(stringBuffer.toString());
            set.add(collationKey);
        }
    }

    private String getUnicodeString(char c) {
        String string = Integer.toHexString(c).toUpperCase();
        int n = string.length();
        switch (n) {
            case 2: {
                string = "'\\u00" + string + "'";
                break;
            }
            case 3: {
                string = "'\\u0" + string + "'";
                break;
            }
            default: {
                string = "'\\u" + string + "'";
            }
        }
        return string;
    }

    private JButton addOptButton(String string, String string2, Container container, boolean bl) {
        JButton jButton = new JButton(string);
        jButton.setEnabled(bl);
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        jButton.setAlignmentX(0.5f);
        container.add(jButton);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("DONE")) {
            if (this.mods) {
                KeyMapper.saveKeyMap();
                KeyMapper.fireKeyChangeEvent();
            }
            this.setVisible(false);
        }
        if (actionEvent.getActionCommand().equals("MAP")) {
            this.mapIt();
        }
        if (actionEvent.getActionCommand().equals("REMOVE")) {
            this.removeIt();
        }
        if (actionEvent.getActionCommand().equals("MAP-Prime")) {
            this.altKey = false;
            this.mapIt();
        }
        if (actionEvent.getActionCommand().equals("REMOVE-Prime")) {
            this.altKey = false;
            this.removeIt();
        }
        if (actionEvent.getActionCommand().equals("MAP-Alt")) {
            this.altKey = true;
            this.mapIt();
        }
        if (actionEvent.getActionCommand().equals("REMOVE-Alt")) {
            this.altKey = true;
            this.removeIt();
        }
    }

    private void mapIt() {
        Object[] objectArray = new Object[1];
        JPanel jPanel = new JPanel();
        final KeyGetterInterface keyGetterInterface = this.getMeAKeyProcessor();
        keyGetterInterface.setForeground(Color.blue);
        objectArray[0] = jPanel;
        String string = this.functions.getSelectedValue() instanceof String ? (String)this.functions.getSelectedValue() : (this.functions.getSelectedValue() instanceof Macro ? ((Macro)this.functions.getSelectedValue()).toString() : ((KeyDescription)this.functions.getSelectedValue()).toString());
        keyGetterInterface.setText(LangTool.getString("key.labelMessage") + string);
        jPanel.add(keyGetterInterface);
        Object[] objectArray2 = new String[]{LangTool.getString("key.labelClose")};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, -1, null, objectArray2, null);
        this.dialog = jOptionPane.createDialog(this, this.getTitle());
        keyGetterInterface.setDialog(this.dialog);
        this.dialog.addWindowListener(new WindowAdapter(){
            boolean gotFocus = false;

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (KeyConfigure.this.isAvailable(keyGetterInterface.keyevent)) {
                    KeyConfigure.this.setNewKeyStrokes(keyGetterInterface.keyevent);
                }
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    keyGetterInterface.grabFocus();
                    this.gotFocus = true;
                }
            }
        });
        this.dialog.setVisible(true);
    }

    private boolean isAvailable(KeyEvent keyEvent) {
        boolean bl = true;
        bl = this.isLinux ? KeyMapper.isKeyStrokeDefined(keyEvent, this.isAltGr) : KeyMapper.isKeyStrokeDefined(keyEvent);
        if (bl) {
            Object[] objectArray = new Object[]{this.getKeyDescription(keyEvent)};
            int n = JOptionPane.showConfirmDialog(this, LangTool.messageFormat("messages.mapKeyWarning", objectArray), LangTool.getString("key.labelKeyExists"), 0, 2);
            return n == 0;
        }
        return !bl;
    }

    private String getKeyDescription(KeyEvent keyEvent) {
        String string = this.isLinux ? KeyMapper.getKeyStrokeMnemonic(keyEvent, this.isAltGr) : KeyMapper.getKeyStrokeMnemonic(keyEvent, this.isAltGr);
        if (string != null && string.length() > 1 && string.startsWith("[")) {
            string = LangTool.getString("key." + string);
        }
        return string;
    }

    private KeyGetterInterface getMeAKeyProcessor() {
        return new KeyGetter();
    }

    private void removeIt() {
        if (!this.macros && !this.special) {
            int n = ((KeyDescription)this.functions.getSelectedValue()).getIndex();
            String string = TN5250jConstants.mnemonicData[n];
            if (this.altKey) {
                string = string + ".alt2";
            }
            KeyMapper.removeKeyStroke(string);
            this.setKeyInformation(string);
        } else {
            Object object;
            if (this.macros) {
                object = this.functions.getSelectedValue();
                String string = object instanceof Macro ? ((Macro)object).getFullName() : (String)object;
                if (this.altKey) {
                    string = string + ".alt2";
                }
                KeyMapper.removeKeyStroke(string);
                this.setKeyInformation(string);
            }
            if (this.special) {
                object = "";
                object = "" + object + ((String)this.functions.getSelectedValue()).charAt(7);
                if (this.altKey) {
                    object = object + ".alt2";
                }
                KeyMapper.removeKeyStroke(object);
                this.setKeyInformation((String)object);
            }
        }
        this.mods = true;
    }

    private void setNewKeyStrokes(KeyEvent keyEvent) {
        if (!this.macros && !this.special) {
            int n = ((KeyDescription)this.functions.getSelectedValue()).getIndex();
            String string = TN5250jConstants.mnemonicData[n];
            if (this.altKey) {
                string = string + ".alt2";
            }
            if (this.isLinux) {
                KeyMapper.setKeyStroke(string, keyEvent, this.isAltGr);
            } else {
                KeyMapper.setKeyStroke(string, keyEvent);
            }
            this.setKeyInformation(string);
        } else {
            Object object;
            if (this.macros) {
                object = this.functions.getSelectedValue();
                String string = object instanceof Macro ? ((Macro)object).getFullName() : (String)object;
                if (this.altKey) {
                    string = string + ".alt2";
                }
                System.out.println(string);
                if (this.isLinux) {
                    KeyMapper.setKeyStroke(string, keyEvent, this.isAltGr);
                } else {
                    KeyMapper.setKeyStroke(string, keyEvent);
                }
                this.setKeyInformation(string);
            }
            if (this.special) {
                System.out.println((String)this.functions.getSelectedValue());
                object = this.parseSpecialCharacter((String)this.functions.getSelectedValue());
                if (this.altKey) {
                    object = object + ".alt2";
                }
                KeyMapper.removeKeyStroke(object);
                if (this.isLinux) {
                    KeyMapper.setKeyStroke(object, keyEvent, this.isAltGr);
                } else {
                    KeyMapper.setKeyStroke(object, keyEvent);
                }
                this.setKeyInformation((String)object);
            }
        }
        this.mods = true;
    }

    public static void scriptDir(String string, Vector vector) {
        File file = new File(string);
        try {
            KeyConfigure.loadScripts(vector, file.getCanonicalPath(), file);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    private static void loadScripts(Vector vector, String string, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        Arrays.sort(fileArray, new MacroCompare());
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            File file2 = fileArray[i];
            String string2 = file2.getName();
            if (file2.isHidden()) continue;
            if (file2.isDirectory()) {
                object = new Vector<String>();
                ((Vector)object).addElement(string2.replace('_', ' '));
                KeyConfigure.loadScripts((Vector)object, string + string2 + '/', file2);
                if (((Vector)object).size() == 1) continue;
                vector.addElement(object);
                continue;
            }
            if (!InterpreterDriverManager.isScriptSupported(string2)) continue;
            object = string2.replace('_', ' ');
            int n = ((String)object).lastIndexOf(46);
            if (n > 0) {
                object = ((String)object).substring(0, n);
            }
            Macro macro = new Macro((String)object, file2.getAbsolutePath(), string2);
            vector.addElement(macro);
        }
    }

    private static void loadListModel(DefaultListModel defaultListModel, Vector vector, String string, int n) {
        for (int i = n; i < vector.size(); ++i) {
            Object object;
            Object e = vector.elementAt(i);
            if (e instanceof Macro) {
                object = (Macro)e;
                ((Macro)object).setPrefix(string);
                defaultListModel.addElement(object);
                continue;
            }
            if (e instanceof Vector) {
                object = (Vector)e;
                String string2 = (String)((Vector)object).elementAt(0);
                if (string != null) {
                    KeyConfigure.loadListModel(defaultListModel, (Vector)object, string + '/' + string2 + '/', 1);
                    continue;
                }
                KeyConfigure.loadListModel(defaultListModel, (Vector)object, string2 + '/', 1);
                continue;
            }
            if (!(e instanceof String)) continue;
            defaultListModel.addElement(e);
        }
    }

    static {
        colorMap.put(32, "Green");
        colorMap.put(33, "Green RI");
        colorMap.put(34, "White");
        colorMap.put(35, "White RI");
        colorMap.put(36, "Green UL");
        colorMap.put(37, "Green RI UL");
        colorMap.put(38, "White UL");
        colorMap.put(39, "NonDisplay");
        colorMap.put(40, "Red");
        colorMap.put(41, "Red RI");
        colorMap.put(42, "Red BL");
        colorMap.put(43, "Red RI BL");
        colorMap.put(44, "Red UL");
        colorMap.put(45, "Red UL RI");
        colorMap.put(46, "Red UL BL");
        colorMap.put(48, "Turquoise CS");
        colorMap.put(49, "Turquoise CS RI");
        colorMap.put(50, "Yellow CS");
        colorMap.put(51, "Yellow CS RI");
        colorMap.put(52, "Turquoise UL");
        colorMap.put(53, "Turquoise UL RI ");
        colorMap.put(54, "Yellow UL");
        colorMap.put(56, "Pink");
        colorMap.put(57, "Pink RI");
        colorMap.put(58, "Blue");
        colorMap.put(59, "Blue RI");
        colorMap.put(60, "Pink UL");
        colorMap.put(61, "Pink UL RI");
        colorMap.put(62, "Blue UL");
    }

    public static class MacroCompare
    implements Comparator<File> {
        @Override
        public int compare(File file, File file2) {
            String string = file.toString();
            String string2 = file2.toString();
            return string.compareToIgnoreCase(string2);
        }
    }

    private static class Macro {
        String name;
        String path;
        String prefix;
        String fileName;

        Macro(String string, String string2, String string3) {
            this.name = string;
            this.path = string2;
            this.fileName = string3;
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public String getFullName() {
            if (this.prefix != null) {
                return this.prefix + this.fileName;
            }
            return this.fileName;
        }

        public String toString() {
            if (this.prefix != null) {
                return this.prefix + this.name;
            }
            return this.name;
        }
    }

    private class KeyDescription {
        private int index;
        private String text;

        public KeyDescription(String string, int n) {
            this.text = string;
            this.index = n;
        }

        public String toString() {
            return this.text;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class KeyDescriptionCompare
    implements Comparator<KeyDescription> {
        private KeyDescriptionCompare() {
        }

        @Override
        public int compare(KeyDescription keyDescription, KeyDescription keyDescription2) {
            String string = keyDescription.toString();
            String string2 = keyDescription2.toString();
            return string.compareToIgnoreCase(string2);
        }
    }
}

