/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard.configure;

import java.awt.event.KeyEvent;
import org.tn5250j.keyboard.configure.KeyGetterInterface;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class KeyGetter
extends KeyGetterInterface {
    private static final long serialVersionUID = 1691732474472874354L;
    private static final transient TN5250jLogger LOG = TN5250jLogFactory.getLogger(KeyGetter.class);

    private void displayInfo(KeyEvent keyEvent) {
        String string;
        switch (keyEvent.getID()) {
            case 401: {
                string = "KEY_PRESSED";
                break;
            }
            case 402: {
                string = "KEY_RELEASED";
                break;
            }
            case 400: {
                string = "KEY_TYPED";
                break;
            }
            default: {
                string = "unknown type";
            }
        }
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        int n3 = keyEvent.getKeyLocation();
        String string2 = Character.isISOControl(c) ? "key character = (an unprintable control character)" : "key character = '" + c + "'";
        String string3 = "key code = " + n + " (" + KeyEvent.getKeyText(n) + ")";
        if (n == 257) {
            string3 = string3 + " previous candidate ";
        }
        if (n == 134 || n == 136 || n == 129 || n == 133 || n == 130) {
            string3 = string3 + " dead key ";
        }
        String string4 = "modifiers = " + n2;
        String string5 = KeyEvent.getKeyModifiersText(n2);
        string4 = string5.length() > 0 ? string4 + " (" + string5 + ")" : string4 + " (no modifiers)";
        String string6 = "location = (UNKNOWN)";
        switch (n3) {
            case 2: {
                string6 = "location = " + n3 + " (LEFT)";
                break;
            }
            case 4: {
                string6 = "location = " + n3 + " (NUM_PAD)";
                break;
            }
            case 3: {
                string6 = "location = " + n3 + " (RIGHT)";
                break;
            }
            case 1: {
                string6 = "location = " + n3 + " (STANDARD)";
                break;
            }
            default: {
                string6 = "location = " + n3 + " (UNKNOWN)";
            }
        }
        String string7 = "isKeys = isActionKey (" + keyEvent.isActionKey() + ")" + " isAltDown (" + keyEvent.isAltDown() + ")" + " isAltGraphDown (" + keyEvent.isAltGraphDown() + ")" + " isAltGraphDownLinux (" + this.isAltGr + ")" + " isControlDown (" + keyEvent.isControlDown() + ")" + " isMetaDown (" + keyEvent.isMetaDown() + ")" + " isShiftDown (" + keyEvent.isShiftDown() + ")";
        if (LOG.isDebugEnabled()) {
            LOG.debug(string + "\n" + "    " + string2 + "\n" + "    " + string3 + "\n" + "    " + string4 + "\n" + "    " + string6 + "\n" + "    " + string7 + "\n");
        }
    }

    @Override
    void processVTKeyPressed(KeyEvent keyEvent) {
        this.displayInfo(keyEvent);
        int n = keyEvent.getKeyCode();
        if (this.isLinux && n == 65406) {
            this.isAltGr = true;
        }
        if (n == 0 || n == 20 || n == 16 || n == 18 || n == 65406 || n == 17) {
            return;
        }
        if (!keyEvent.isAltDown() || !keyEvent.isShiftDown() || !keyEvent.isControlDown() || n != 17 && !keyEvent.isActionKey()) {
            this.keyevent = keyEvent;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    @Override
    void processVTKeyTyped(KeyEvent keyEvent) {
        this.displayInfo(keyEvent);
        int n = keyEvent.getKeyCode();
        if (keyEvent.isAltDown() || keyEvent.isShiftDown() || keyEvent.isControlDown() || keyEvent.isActionKey() || n == 17) {
            this.keyevent = keyEvent;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    @Override
    void processVTKeyReleased(KeyEvent keyEvent) {
        this.displayInfo(keyEvent);
        if (this.isLinux && keyEvent.getKeyCode() == 65406) {
            this.isAltGr = false;
        }
        int n = keyEvent.getKeyCode();
        if (keyEvent.isAltDown() || keyEvent.isShiftDown() || keyEvent.isControlDown() || keyEvent.isActionKey() || n == 17) {
            this.keyevent = keyEvent;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }
}

