/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.mailtools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.LangTool;

public class SMTPConfig
extends JDialog {
    private static final long serialVersionUID = 1L;
    JPanel mainPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel configPanel = new JPanel(new GridBagLayout());
    GridBagConstraints gbc;
    JPanel optionsPanel = new JPanel(new FlowLayout(1, 10, 10));
    JLabel labelHost = new JLabel();
    JTextField fieldHost = new JTextField();
    JLabel labelPort = new JLabel();
    JTextField fieldPort = new JTextField();
    JLabel labelDefault = new JLabel();
    JLabel labelName = new JLabel();
    JTextField fieldName = new JTextField();
    JLabel labelFrom = new JLabel();
    JTextField fieldFrom = new JTextField();
    JButton optDone = new JButton();
    JButton optCancel = new JButton();
    JLabel labelFileName = new JLabel();
    JTextField fieldFileName = new JTextField();
    Properties SMTPProperties;
    private static final String smtpFileName = "SMTPProperties.cfg";

    public SMTPConfig(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SMTPConfig() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.setTitle(LangTool.getString("em.configTitle"));
        this.mainPanel.setLayout(this.borderLayout1);
        this.labelHost.setText(LangTool.getString("em.labelHost"));
        this.fieldHost.setColumns(20);
        this.labelPort.setText(LangTool.getString("em.labelPort"));
        this.fieldPort.setColumns(3);
        this.labelDefault.setText(LangTool.getString("em.labelDefault"));
        this.labelName.setText(LangTool.getString("em.labelName"));
        this.fieldName.setColumns(20);
        this.labelFrom.setText(LangTool.getString("em.labelFrom"));
        this.fieldFrom.setColumns(20);
        this.optDone.setPreferredSize(new Dimension(100, 27));
        this.optDone.setText(LangTool.getString("em.optDone"));
        this.optDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SMTPConfig.this.optDone_actionPerformed(actionEvent);
            }
        });
        this.optCancel.setPreferredSize(new Dimension(100, 27));
        this.optCancel.setText(LangTool.getString("em.optCancelLabel"));
        this.optCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SMTPConfig.this.optCancel_actionPerformed(actionEvent);
            }
        });
        this.labelFileName.setText(LangTool.getString("em.labelFileName"));
        this.fieldFileName.setText("tn5250j.txt");
        this.fieldFileName.setColumns(20);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(10, 10, 5, 5);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.labelHost, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(10, 5, 5, 10);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.fieldHost, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.labelPort, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.fieldPort, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 15, 5, 10);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.labelDefault, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.labelName, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.fieldName, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.labelFrom, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.fieldFrom, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(5, 10, 0, 5);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.labelFileName, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 4;
        this.gbc.gridwidth = 2;
        this.gbc.insets = new Insets(5, 5, 0, 10);
        this.gbc.anchor = 17;
        this.configPanel.add((Component)this.fieldFileName, this.gbc);
        this.mainPanel.add((Component)this.configPanel, "North");
        this.optionsPanel.add(this.optDone);
        this.optionsPanel.add(this.optCancel);
        this.mainPanel.add((Component)this.optionsPanel, "South");
        this.getContentPane().add(this.mainPanel);
        if (this.loadConfig(null)) {
            this.setProperties();
        }
        this.centerMe();
    }

    private void centerMe() {
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void setProperties() {
        this.fieldHost.setText(this.SMTPProperties.getProperty("mail.smtp.host"));
        this.fieldPort.setText(this.SMTPProperties.getProperty("mail.smtp.port"));
        this.fieldFrom.setText(this.SMTPProperties.getProperty("mail.smtp.from"));
        this.fieldName.setText(this.SMTPProperties.getProperty("mail.smtp.realname"));
        this.fieldFileName.setText(this.SMTPProperties.getProperty("fileName"));
    }

    private boolean loadConfig(String string) throws Exception {
        this.SMTPProperties = ConfigureFactory.getInstance().getProperties("smtp", smtpFileName);
        return this.SMTPProperties.size() > 0;
    }

    private void optDone_actionPerformed(ActionEvent actionEvent) {
        this.SMTPProperties.setProperty("mail.smtp.host", this.fieldHost.getText());
        this.SMTPProperties.setProperty("mail.smtp.port", this.fieldPort.getText());
        this.SMTPProperties.setProperty("mail.smtp.from", this.fieldFrom.getText());
        this.SMTPProperties.setProperty("mail.smtp.realname", this.fieldName.getText());
        this.SMTPProperties.setProperty("fileName", this.fieldFileName.getText());
        Enumeration<?> enumeration = this.SMTPProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            System.out.println(this.SMTPProperties.get(enumeration.nextElement()));
        }
        ConfigureFactory.getInstance().saveSettings("smtp", smtpFileName, "------ SMTP Defaults --------");
        this.setVisible(false);
    }

    void optCancel_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }
}

