/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.mailtools;

import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.LangTool;

public class SendEMail {
    private String to;
    private String from;
    private String pers;
    private String cc;
    private String subject;
    private String configFile;
    private String message;
    private String attachment;
    private String attachmentName;
    private String fileName;
    Properties SMTPProperties;

    public void setTo(String string) {
        this.to = string;
    }

    public String getTo() {
        return this.to;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public String getFrom() {
        return this.from;
    }

    public void setCC(String string) {
        this.cc = string;
    }

    public String getCC() {
        return this.cc;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setAttachment(String string) {
        this.attachment = string;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setAttachmentName(String string) {
        this.attachmentName = string;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    private boolean loadConfig(String string) throws Exception {
        this.SMTPProperties = ConfigureFactory.getInstance().getProperties("smtp", "SMTPProperties.cfg");
        return this.SMTPProperties.size() > 0;
    }

    public void release() {
        this.to = null;
        this.from = null;
        this.cc = null;
        this.subject = null;
        this.configFile = null;
        this.message = null;
        this.attachment = null;
        this.attachmentName = null;
        this.fileName = null;
    }

    public boolean send() throws Exception {
        try {
            MimeBodyPart mimeBodyPart;
            if (!this.loadConfig(this.configFile)) {
                return false;
            }
            Session session = Session.getDefaultInstance((Properties)this.SMTPProperties, null);
            session.setDebug(false);
            MimeMultipart mimeMultipart = new MimeMultipart();
            MimeMessage mimeMessage = new MimeMessage(session);
            InternetAddress[] internetAddressArray = null;
            InternetAddress[] internetAddressArray2 = null;
            internetAddressArray = InternetAddress.parse((String)this.to, (boolean)false);
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
            if (this.cc != null) {
                internetAddressArray2 = InternetAddress.parse((String)this.cc, (boolean)false);
                mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])internetAddressArray2);
            }
            if (this.subject != null) {
                mimeMessage.setSubject(this.subject.trim());
            }
            if (this.from == null) {
                this.from = this.SMTPProperties.getProperty("mail.smtp.from");
            }
            if (this.from != null && this.from.length() > 0) {
                this.pers = this.SMTPProperties.getProperty("mail.smtp.realname");
                if (this.pers != null) {
                    mimeMessage.setFrom((Address)new InternetAddress(this.from, this.pers));
                }
            }
            if (this.message != null && this.message.length() > 0) {
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setText(this.message, "us-ascii");
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            }
            mimeMessage.setSentDate(new Date());
            if (this.attachment != null && this.attachment.length() > 0) {
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setText(this.attachment, "us-ascii");
                if (this.attachmentName == null || this.attachmentName.length() == 0) {
                    mimeBodyPart.setFileName("tn5250j.txt");
                } else {
                    mimeBodyPart.setFileName(this.attachmentName);
                }
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            }
            if (this.fileName != null && this.fileName.length() > 0) {
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setText("File sent using tn5250j", "us-ascii");
                if (this.attachmentName == null || this.attachmentName.length() == 0) {
                    mimeBodyPart.setFileName("tn5250j.txt");
                } else {
                    mimeBodyPart.setFileName(this.attachmentName);
                }
                FileDataSource fileDataSource = new FileDataSource(this.fileName);
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            }
            mimeMessage.setContent((Multipart)mimeMultipart);
            Transport.send((Message)mimeMessage);
            return true;
        }
        catch (SendFailedException sendFailedException) {
            this.showFailedException(sendFailedException);
            return false;
        }
    }

    private void showFailedException(SendFailedException sendFailedException) {
        String string = sendFailedException.getMessage() + "\n";
        Address[] addressArray = sendFailedException.getInvalidAddresses();
        if (addressArray != null) {
            for (int i = 0; i < addressArray.length; ++i) {
                string = string + "Invalid Address: " + addressArray[i].toString() + "\n";
            }
        }
        JTextArea jTextArea = new JTextArea(string, 6, 50);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JOptionPane.showMessageDialog(null, jScrollPane, LangTool.getString("em.titleConfirmation"), 0);
    }
}

