/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.mailtools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.gui.GenericTn5250JFrame;
import org.tn5250j.gui.TN5250jFileChooser;
import org.tn5250j.mailtools.SMTPConfig;
import org.tn5250j.mailtools.SendEMail;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.encoder.EncodeComponent;

public class SendEMailDialog
extends GenericTn5250JFrame
implements Runnable {
    private static final long serialVersionUID = 1L;
    JComboBox toAddress;
    JTextField subject;
    JTextArea bodyText;
    JTextField attachmentName;
    SessionConfig config;
    SessionPanel session;
    String fileName;
    JRadioButton text;
    JRadioButton graphic;
    GridBagConstraints gbc;
    JRadioButton normal;
    JRadioButton screenshot;
    JButton browse;
    boolean sendScreen;
    SendEMail sendEMail;
    Thread myThread = new Thread(this);

    public SendEMailDialog(Frame frame, SessionPanel sessionPanel) {
        this(frame, sessionPanel, true);
    }

    public SendEMailDialog(Frame frame, SessionPanel sessionPanel, boolean bl) {
        if (!this.isEMailAvailable()) {
            JOptionPane.showMessageDialog(frame, LangTool.getString("messages.noEmailAPI"), "Error", 0, null);
        } else {
            this.session = sessionPanel;
            Screen5250 screen5250 = sessionPanel.getScreen();
            this.sendScreen = bl;
            Object[] objectArray = new Object[]{this.setupMailPanel("tn5250j.txt")};
            Object[] objectArray2 = new String[3];
            int n = 0;
            block7: while (n == 0 || n == 2) {
                this.setOptions((String[])objectArray2);
                n = JOptionPane.showOptionDialog(frame, objectArray, LangTool.getString("em.title"), -1, -1, null, objectArray2, objectArray2[0]);
                switch (n) {
                    case 0: {
                        Object object;
                        Object object2;
                        Object object3;
                        this.sendEMail = new SendEMail();
                        this.sendEMail.setConfigFile("SMTPProperties.cfg");
                        this.sendEMail.setTo((String)this.toAddress.getSelectedItem());
                        this.sendEMail.setSubject(this.subject.getText());
                        if (this.bodyText.getText().length() > 0) {
                            this.sendEMail.setMessage(this.bodyText.getText());
                        }
                        if (this.attachmentName.getText().length() > 0) {
                            if (!this.normal.isSelected()) {
                                this.sendEMail.setAttachmentName(this.attachmentName.getText());
                            } else {
                                this.sendEMail.setAttachmentName(this.fileName);
                            }
                        }
                        if (this.text.isSelected()) {
                            int n2 = screen5250.getScreenLength();
                            object3 = new char[n2];
                            object2 = new char[n2];
                            object = new char[n2];
                            screen5250.GetScreen((char[])object3, n2, 1);
                            screen5250.GetScreen((char[])object2, n2, 4);
                            screen5250.GetScreen((char[])object, n2, 8);
                            StringBuffer stringBuffer = new StringBuffer();
                            int n3 = screen5250.getColumns();
                            int n4 = screen5250.getRows() * n3;
                            int n5 = 0;
                            int n6 = 0;
                            while (n6 < n4) {
                                if (object3[n6] >= 32 && (object2[n6] & '\u0001') == 0) {
                                    if ((object2[n6] & 8) != 0 && object[n6] != true) {
                                        stringBuffer.append('_');
                                    } else {
                                        stringBuffer.append((char)object3[n6]);
                                    }
                                } else if ((object2[n6] & 8) != 0 && object[n6] != true) {
                                    stringBuffer.append('_');
                                } else {
                                    stringBuffer.append(' ');
                                }
                                if (n5 == n3) {
                                    stringBuffer.append('\n');
                                    n5 = 0;
                                }
                                ++n6;
                                ++n5;
                            }
                            this.sendEMail.setAttachment(stringBuffer.toString());
                        } else if (this.graphic.isSelected()) {
                            object3 = new File(System.getProperty("user.dir"));
                            object2 = "tn5250jTemp";
                            try {
                                object = File.createTempFile((String)object2, ".png", (File)object3);
                                System.out.println(((File)object).getName());
                                System.out.println(((File)object).getCanonicalPath());
                                ((File)object).deleteOnExit();
                                EncodeComponent.encode(EncodeComponent.PNG, (Component)sessionPanel, (File)object);
                                this.sendEMail.setFileName(((File)object).getName());
                            }
                            catch (Exception exception) {
                                System.out.println(exception.getMessage());
                            }
                        } else if (this.attachmentName.getText().length() > 0) {
                            object3 = new File(this.attachmentName.getText());
                            this.sendEMail.setFileName(((File)object3).toString());
                        }
                        this.sendIt(frame, this.sendEMail);
                        continue block7;
                    }
                    case 1: {
                        continue block7;
                    }
                    case 2: {
                        this.configureSMTP(frame);
                        continue block7;
                    }
                }
            }
        }
    }

    public SendEMailDialog(Frame frame, SessionPanel sessionPanel, String string) {
        if (!this.isEMailAvailable()) {
            JOptionPane.showMessageDialog(frame, LangTool.getString("messages.noEmailAPI"), "Error", 0, null);
        } else {
            this.session = sessionPanel;
            Object[] objectArray = new Object[]{this.setupMailPanel(string)};
            Object[] objectArray2 = new String[3];
            int n = 0;
            block5: while (n == 0 || n == 2) {
                this.setOptions((String[])objectArray2);
                n = JOptionPane.showOptionDialog(frame, objectArray, LangTool.getString("em.titleFileTransfer"), -1, -1, null, objectArray2, objectArray2[0]);
                switch (n) {
                    case 0: {
                        this.sendEMail = new SendEMail();
                        this.sendEMail.setConfigFile("SMTPProperties.cfg");
                        this.sendEMail.setTo((String)this.toAddress.getSelectedItem());
                        this.sendEMail.setSubject(this.subject.getText());
                        if (this.bodyText.getText().length() > 0) {
                            this.sendEMail.setMessage(this.bodyText.getText());
                        }
                        if (this.attachmentName.getText().length() > 0) {
                            this.sendEMail.setAttachmentName(this.attachmentName.getText());
                        }
                        if (string != null && string.length() > 0) {
                            this.sendEMail.setFileName(string);
                        }
                        this.sendIt(frame, this.sendEMail);
                        continue block5;
                    }
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        this.configureSMTP(frame);
                        continue block5;
                    }
                }
            }
        }
    }

    private void sendIt(Frame frame, SendEMail sendEMail) {
        this.myThread.start();
    }

    public void setSendEMail(SendEMail sendEMail) {
        this.sendEMail = sendEMail;
    }

    @Override
    public void run() {
        try {
            if (this.sendEMail.send()) {
                this.sendEMail.release();
                this.sendEMail = null;
                JOptionPane.showMessageDialog(null, LangTool.getString("em.confirmationMessage") + " " + (String)this.toAddress.getSelectedItem(), LangTool.getString("em.titleConfirmation"), 1);
                if (this.session != null) {
                    this.config.setProperty("emailTo", this.getToTokens(this.config.getStringProperty("emailTo"), this.toAddress));
                    this.config.saveSessionProps();
                    this.setToCombo(this.config.getStringProperty("emailTo"), this.toAddress);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private void configureSMTP(Frame frame) {
        if (frame == null) {
            frame = new JFrame();
        }
        SMTPConfig sMTPConfig = new SMTPConfig(frame, "", true);
        sMTPConfig.setVisible(true);
        sMTPConfig.dispose();
    }

    private JPanel setupMailPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.text = new JRadioButton(LangTool.getString("em.text"));
        this.graphic = new JRadioButton(LangTool.getString("em.graphic"));
        this.normal = new JRadioButton(LangTool.getString("em.normalmail"), true);
        this.screenshot = new JRadioButton(LangTool.getString("em.screenshot"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.text);
        buttonGroup.add(this.graphic);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.normal);
        buttonGroup2.add(this.screenshot);
        this.text.setSelected(false);
        this.text.setEnabled(false);
        this.graphic.setEnabled(false);
        JLabel jLabel = new JLabel(LangTool.getString("em.screendump"));
        JLabel jLabel2 = new JLabel(LangTool.getString("em.to"));
        JLabel jLabel3 = new JLabel(LangTool.getString("em.subject"));
        JLabel jLabel4 = new JLabel(LangTool.getString("em.body"));
        JLabel jLabel5 = new JLabel(LangTool.getString("em.fileName"));
        JLabel jLabel6 = new JLabel(LangTool.getString("em.typeofmail"));
        this.browse = new JButton(LangTool.getString("em.choosefile"));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendEMailDialog.this.browse_actionPerformed(actionEvent);
            }
        });
        this.toAddress = new JComboBox();
        this.toAddress.setPreferredSize(new Dimension(175, 25));
        this.toAddress.setEditable(true);
        this.subject = new JTextField(30);
        this.bodyText = new JTextArea(6, 30);
        JScrollPane jScrollPane = new JScrollPane(this.bodyText);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.attachmentName = new JTextField(string, 30);
        if (string != null && string.length() > 0) {
            this.attachmentName.setText(string);
        } else {
            this.attachmentName.setText("");
        }
        this.text.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SendEMailDialog.this.setAttachmentName();
            }
        });
        this.normal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SendEMailDialog.this.setTypeOfMail();
            }
        });
        if (this.sendScreen) {
            this.screenshot.setSelected(true);
        } else {
            this.normal.setSelected(true);
        }
        this.config = null;
        if (this.session != null) {
            this.config = this.session.getSession().getConfiguration();
            if (this.config.isPropertyExists("emailTo")) {
                this.setToCombo(this.config.getStringProperty("emailTo"), this.toAddress);
            }
        }
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        jPanel.add((Component)jLabel6, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 15, 5, 5);
        jPanel.add((Component)this.normal, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 45, 5, 10);
        jPanel.add((Component)this.screenshot, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 10, 5, 5);
        jPanel.add((Component)jLabel, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 15, 5, 5);
        jPanel.add((Component)this.text, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 45, 5, 10);
        jPanel.add((Component)this.graphic, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        jPanel.add((Component)jLabel2, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 2;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        jPanel.add((Component)this.toAddress, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        jPanel.add((Component)jLabel3, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 2;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        jPanel.add((Component)this.subject, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.gridheight = 3;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        jPanel.add((Component)jLabel4, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 4;
        this.gbc.gridwidth = 2;
        this.gbc.gridheight = 3;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        jPanel.add((Component)jScrollPane, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 7;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        jPanel.add((Component)jLabel5, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 7;
        this.gbc.gridwidth = 2;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        jPanel.add((Component)this.attachmentName, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 8;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(5, 5, 10, 10);
        jPanel.add((Component)this.browse, this.gbc);
        return jPanel;
    }

    private void browse_actionPerformed(ActionEvent actionEvent) {
        String string = System.getProperty("user.dir");
        TN5250jFileChooser tN5250jFileChooser = new TN5250jFileChooser(string);
        int n = tN5250jFileChooser.showOpenDialog(new JFrame());
        if (n == 0) {
            File file = tN5250jFileChooser.getSelectedFile();
            this.fileName = file.getName();
            this.attachmentName.setText(file.toString());
        }
    }

    private void setAttachmentName() {
        if (this.text.isSelected()) {
            this.attachmentName.setText("tn5250j.txt");
        } else if (this.normal.isSelected()) {
            this.attachmentName.setText("tn5250j.png");
        } else {
            this.attachmentName.setText("tn5250j.png");
        }
    }

    private void setTypeOfMail() {
        if (this.normal.isSelected()) {
            this.text.setEnabled(false);
            this.graphic.setEnabled(false);
            this.attachmentName.setText("");
            this.browse.setEnabled(true);
        } else {
            this.text.setEnabled(true);
            this.graphic.setEnabled(true);
            this.text.setSelected(true);
            this.setAttachmentName();
            this.browse.setEnabled(false);
        }
    }

    private void setOptions(String[] stringArray) {
        stringArray[0] = LangTool.getString("em.optSendLabel");
        stringArray[1] = LangTool.getString("em.optCancelLabel");
        File file = new File("SMTPProperties.cfg");
        stringArray[2] = file.exists() ? LangTool.getString("em.optEditLabel") : LangTool.getString("em.optConfigureLabel");
    }

    private void setToCombo(String string, JComboBox jComboBox) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        jComboBox.removeAllItems();
        while (stringTokenizer.hasMoreTokens()) {
            jComboBox.addItem(stringTokenizer.nextToken());
        }
    }

    private String getToTokens(String string, JComboBox jComboBox) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = (String)jComboBox.getSelectedItem();
        stringBuffer.append(string2 + '|');
        int n = jComboBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (string2.equals(jComboBox.getItemAt(i))) continue;
            stringBuffer.append((String)jComboBox.getItemAt(i) + '|');
        }
        return stringBuffer.toString();
    }

    private boolean isEMailAvailable() {
        try {
            Class.forName("javax.mail.Message");
            return true;
        }
        catch (Exception exception) {
            System.out.println(" not there " + exception.getMessage());
            return false;
        }
    }
}

