/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.scripting;

import java.util.HashMap;
import java.util.Map;
import org.tn5250j.SessionPanel;
import org.tn5250j.scripting.InterpreterDriver;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class InterpreterDriverManager {
    private static final transient TN5250jLogger LOG = TN5250jLogFactory.getLogger(InterpreterDriverManager.class);
    private static Map<String, InterpreterDriver> _extensionDriverMap = new HashMap<String, InterpreterDriver>();
    private static Map<String, InterpreterDriver> _languageDriverMap = new HashMap<String, InterpreterDriver>();
    private static final char EXTENSION_SEPARATOR = '.';

    private InterpreterDriverManager() {
    }

    public static void registerDriver(InterpreterDriver interpreterDriver) {
        int n;
        String[] stringArray = interpreterDriver.getSupportedExtensions();
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            _extensionDriverMap.put(stringArray[n], interpreterDriver);
        }
        String[] stringArray2 = interpreterDriver.getSupportedLanguages();
        n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            _languageDriverMap.put(stringArray2[i], interpreterDriver);
        }
    }

    public static void executeScript(SessionPanel sessionPanel, String string, String string2) throws InterpreterDriver.InterpreterException {
        InterpreterDriver interpreterDriver = _languageDriverMap.get(string2);
        if (interpreterDriver == null) {
            LOG.warn("No driver installed to handle language " + string2);
            return;
        }
        interpreterDriver.executeScript(sessionPanel, string);
    }

    public static void executeScriptFile(SessionPanel sessionPanel, String string) throws InterpreterDriver.InterpreterException {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        InterpreterDriver interpreterDriver = _extensionDriverMap.get(string2);
        if (interpreterDriver == null) {
            LOG.warn("No driver installed to handle extension " + string2);
            return;
        }
        interpreterDriver.executeScriptFile(sessionPanel, string);
    }

    public static void executeScriptFile(String string) throws InterpreterDriver.InterpreterException {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        InterpreterDriver interpreterDriver = _extensionDriverMap.get(string2);
        if (interpreterDriver == null) {
            LOG.warn("No driver installed to handle extension " + string2);
            return;
        }
        interpreterDriver.executeScriptFile(string);
    }

    public static boolean isScriptSupported(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        return _extensionDriverMap.containsKey(string2);
    }
}

