/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.tn5250j.SessionConfig;
import org.tn5250j.settings.AttributesPanel;
import org.tn5250j.tools.LangTool;

public class ColorAttributesPanel
extends AttributesPanel {
    private static final long serialVersionUID = 1L;
    JComboBox colorSchemaList;
    JComboBox colorList;
    JColorChooser jcc;
    Schema colorSchema;
    Properties schemaProps;

    public ColorAttributesPanel(SessionConfig sessionConfig) {
        super(sessionConfig, "Colors");
    }

    @Override
    public void initPanel() throws Exception {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(LangTool.getString("sa.colorSchema"));
        jPanel2.setBorder(titledBorder);
        this.colorSchemaList = new JComboBox();
        this.loadSchemas(this.colorSchemaList);
        this.colorSchemaList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof Schema) {
                    System.out.println(" we got a schema ");
                    ColorAttributesPanel.this.colorSchema = (Schema)object;
                } else {
                    ColorAttributesPanel.this.colorSchema = null;
                }
            }
        });
        jPanel2.add(this.colorSchemaList);
        titledBorder = BorderFactory.createTitledBorder(LangTool.getString("sa.colors"));
        jPanel.setBorder(titledBorder);
        this.colorList = new JComboBox();
        this.colorList.addItem(LangTool.getString("sa.bg"));
        this.colorList.addItem(LangTool.getString("sa.blue"));
        this.colorList.addItem(LangTool.getString("sa.red"));
        this.colorList.addItem(LangTool.getString("sa.pink"));
        this.colorList.addItem(LangTool.getString("sa.green"));
        this.colorList.addItem(LangTool.getString("sa.turq"));
        this.colorList.addItem(LangTool.getString("sa.yellow"));
        this.colorList.addItem(LangTool.getString("sa.white"));
        this.colorList.addItem(LangTool.getString("sa.guiField"));
        this.colorList.addItem(LangTool.getString("sa.cursorColor"));
        this.colorList.addItem(LangTool.getString("sa.columnSep"));
        this.colorList.addItem(LangTool.getString("sa.hexAttrColor"));
        this.jcc = new JColorChooser();
        this.jcc.setColor(this.getColorProperty("colorBg"));
        this.colorList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                if (string.equals(LangTool.getString("sa.bg"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorBg());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorBg"));
                    }
                }
                if (string.equals(LangTool.getString("sa.blue"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorBlue());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorBlue"));
                    }
                }
                if (string.equals(LangTool.getString("sa.red"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorRed());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorRed"));
                    }
                }
                if (string.equals(LangTool.getString("sa.pink"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorPink());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorPink"));
                    }
                }
                if (string.equals(LangTool.getString("sa.green"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorGreen());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorGreen"));
                    }
                }
                if (string.equals(LangTool.getString("sa.turq"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorTurq());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorTurq"));
                    }
                }
                if (string.equals(LangTool.getString("sa.yellow"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorYellow());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorYellow"));
                    }
                }
                if (string.equals(LangTool.getString("sa.white"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorWhite());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorWhite"));
                    }
                }
                if (string.equals(LangTool.getString("sa.guiField"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorGuiField());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorGUIField", Color.white));
                    }
                }
                if (string.equals(LangTool.getString("sa.cursorColor"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorBg());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorCursor", ColorAttributesPanel.this.getColorProperty("colorBg")));
                    }
                }
                if (string.equals(LangTool.getString("sa.columnSep"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorSeparator());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorSep", ColorAttributesPanel.this.getColorProperty("colorWhite")));
                    }
                }
                if (string.equals(LangTool.getString("sa.hexAttrColor"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorHexAttr());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorHexAttr", ColorAttributesPanel.this.getColorProperty("colorWhite")));
                    }
                }
            }
        });
        jPanel.add((Component)this.colorList, "North");
        jPanel.add((Component)this.jcc, "Center");
        this.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void save() {
    }

    @Override
    public void applyAttributes() {
        String string = (String)this.colorList.getSelectedItem();
        if (this.colorSchema != null) {
            if (!this.getColorProperty("colorBg").equals(this.colorSchema.getColorBg())) {
                this.changes.firePropertyChange(this, "colorBg", this.getColorProperty("colorBg"), this.colorSchema.getColorBg());
                this.setProperty("colorBg", Integer.toString(this.colorSchema.getColorBg().getRGB()));
            }
            if (!this.getColorProperty("colorBlue").equals(this.colorSchema.getColorBlue())) {
                this.changes.firePropertyChange(this, "colorBlue", this.getColorProperty("colorBlue"), this.colorSchema.getColorBlue());
                this.setProperty("colorBlue", Integer.toString(this.colorSchema.getColorBlue().getRGB()));
            }
            if (!this.getColorProperty("colorRed").equals(this.colorSchema.getColorRed())) {
                this.changes.firePropertyChange(this, "colorRed", this.getColorProperty("colorRed"), this.colorSchema.getColorRed());
                this.setProperty("colorRed", Integer.toString(this.colorSchema.getColorRed().getRGB()));
            }
            if (!this.getColorProperty("colorPink").equals(this.colorSchema.getColorPink())) {
                this.changes.firePropertyChange(this, "colorPink", this.getColorProperty("colorPink"), this.colorSchema.getColorPink());
                this.setProperty("colorPink", Integer.toString(this.colorSchema.getColorPink().getRGB()));
            }
            if (!this.getColorProperty("colorGreen").equals(this.colorSchema.getColorGreen())) {
                this.changes.firePropertyChange(this, "colorGreen", this.getColorProperty("colorGreen"), this.colorSchema.getColorGreen());
                this.setProperty("colorGreen", Integer.toString(this.colorSchema.getColorGreen().getRGB()));
            }
            if (!this.getColorProperty("colorTurq").equals(this.colorSchema.getColorTurq())) {
                this.changes.firePropertyChange(this, "colorTurq", this.getColorProperty("colorTurq"), this.colorSchema.getColorTurq());
                this.setProperty("colorTurq", Integer.toString(this.colorSchema.getColorTurq().getRGB()));
            }
            if (!this.getColorProperty("colorYellow").equals(this.colorSchema.getColorYellow())) {
                this.changes.firePropertyChange(this, "colorYellow", this.getColorProperty("colorYellow"), this.colorSchema.getColorYellow());
                this.setProperty("colorYellow", Integer.toString(this.colorSchema.getColorYellow().getRGB()));
            }
            if (!this.getColorProperty("colorWhite").equals(this.colorSchema.getColorWhite())) {
                this.changes.firePropertyChange(this, "colorWhite", this.getColorProperty("colorWhite"), this.colorSchema.getColorWhite());
                this.setProperty("colorWhite", Integer.toString(this.colorSchema.getColorWhite().getRGB()));
            }
            if (!this.getColorProperty("colorGUIField").equals(this.colorSchema.getColorGuiField())) {
                this.changes.firePropertyChange(this, "colorGUIField", this.getColorProperty("colorGUIField"), this.colorSchema.getColorGuiField());
                this.setProperty("colorGUIField", Integer.toString(this.colorSchema.getColorGuiField().getRGB()));
            }
            if (!this.getColorProperty("colorCursor").equals(this.colorSchema.getColorCursor())) {
                this.changes.firePropertyChange(this, "colorCursor", this.getColorProperty("colorCursor"), this.colorSchema.getColorCursor());
                this.setProperty("colorCursor", Integer.toString(this.colorSchema.getColorCursor().getRGB()));
            }
            if (!this.getColorProperty("colorSep").equals(this.colorSchema.getColorSeparator())) {
                this.changes.firePropertyChange(this, "colorSep", this.getColorProperty("colorSep"), this.colorSchema.getColorSeparator());
                this.setProperty("colorSep", Integer.toString(this.colorSchema.getColorSeparator().getRGB()));
            }
            if (!this.getColorProperty("colorHexAttr").equals(this.colorSchema.getColorHexAttr())) {
                this.changes.firePropertyChange(this, "colorHexAttr", this.getColorProperty("colorHexAttr"), this.colorSchema.getColorHexAttr());
                this.setProperty("colorHexAttr", Integer.toString(this.colorSchema.getColorHexAttr().getRGB()));
            }
        } else {
            Color color = this.jcc.getColor();
            if (string.equals(LangTool.getString("sa.bg")) && !this.getColorProperty("colorBg").equals(color)) {
                this.changes.firePropertyChange(this, "colorBg", this.getColorProperty("colorBg"), color);
                this.setProperty("colorBg", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.blue")) && !this.getColorProperty("colorBlue").equals(color)) {
                this.changes.firePropertyChange(this, "colorBlue", this.getColorProperty("colorBlue"), color);
                this.setProperty("colorBlue", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.red")) && !this.getColorProperty("colorRed").equals(color)) {
                this.changes.firePropertyChange(this, "colorRed", this.getColorProperty("colorRed"), color);
                this.setProperty("colorRed", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.pink")) && !this.getColorProperty("colorPink").equals(color)) {
                this.changes.firePropertyChange(this, "colorPink", this.getColorProperty("colorPink"), color);
                this.setProperty("colorPink", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.green")) && !this.getColorProperty("colorGreen").equals(color)) {
                this.changes.firePropertyChange(this, "colorGreen", this.getColorProperty("colorGreen"), color);
                this.setProperty("colorGreen", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.turq")) && !this.getColorProperty("colorTurq").equals(color)) {
                this.changes.firePropertyChange(this, "colorTurq", this.getColorProperty("colorTurq"), color);
                this.setProperty("colorTurq", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.yellow")) && !this.getColorProperty("colorYellow").equals(color)) {
                this.changes.firePropertyChange(this, "colorYellow", this.getColorProperty("colorYellow"), color);
                this.setProperty("colorYellow", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.white")) && !this.getColorProperty("colorWhite").equals(color)) {
                this.changes.firePropertyChange(this, "colorWhite", this.getColorProperty("colorWhite"), color);
                this.setProperty("colorWhite", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.guiField")) && !this.getColorProperty("colorGUIField").equals(color)) {
                this.changes.firePropertyChange(this, "colorGUIField", this.getColorProperty("colorGUIField"), color);
                this.setProperty("colorGUIField", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.cursorColor")) && !this.getColorProperty("colorCursor").equals(color)) {
                this.changes.firePropertyChange(this, "colorCursor", this.getColorProperty("colorCursor"), color);
                this.setProperty("colorCursor", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.columnSep")) && !this.getColorProperty("colorSep").equals(color)) {
                this.changes.firePropertyChange(this, "colorSep", this.getColorProperty("colorSep"), color);
                this.setProperty("colorSep", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.cursorColor")) && !this.getColorProperty("colorCursor").equals(color)) {
                this.changes.firePropertyChange(this, "colorCursor", this.getColorProperty("colorCursor"), color);
                this.setProperty("colorCursor", Integer.toString(color.getRGB()));
            }
            if (string.equals(LangTool.getString("sa.hexAttrColor")) && !this.getColorProperty("colorHexAttr").equals(color)) {
                this.changes.firePropertyChange(this, "colorHexAttr", this.getColorProperty("colorHexAttr"), color);
                this.setProperty("colorHexAttr", Integer.toString(color.getRGB()));
            }
        }
    }

    private void loadSchemas(JComboBox jComboBox) {
        this.schemaProps = new Properties();
        URL uRL = null;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            uRL = classLoader.getResource("tn5250jSchemas.properties");
            this.schemaProps.load(uRL.openStream());
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        jComboBox.addItem(LangTool.getString("sa.colorDefault"));
        int n = Integer.parseInt((String)this.schemaProps.get("schemas"));
        Schema schema = null;
        String string = "";
        for (int i = 1; i <= n; ++i) {
            schema = new Schema();
            string = "schema" + i;
            schema.setDescription((String)this.schemaProps.get(string + ".title"));
            schema.setColorBg(this.getSchemaProp(string + ".colorBg"));
            schema.setColorRed(this.getSchemaProp(string + ".colorRed"));
            schema.setColorTurq(this.getSchemaProp(string + ".colorTurq"));
            schema.setColorCursor(this.getSchemaProp(string + ".colorCursor"));
            schema.setColorGuiField(this.getSchemaProp(string + ".colorGUIField"));
            schema.setColorWhite(this.getSchemaProp(string + ".colorWhite"));
            schema.setColorYellow(this.getSchemaProp(string + ".colorYellow"));
            schema.setColorGreen(this.getSchemaProp(string + ".colorGreen"));
            schema.setColorPink(this.getSchemaProp(string + ".colorPink"));
            schema.setColorBlue(this.getSchemaProp(string + ".colorBlue"));
            schema.setColorSeparator(this.getSchemaProp(string + ".colorSep"));
            schema.setColorHexAttr(this.getSchemaProp(string + ".colorHexAttr"));
            jComboBox.addItem(schema);
        }
    }

    private int getSchemaProp(String string) {
        if (this.schemaProps.containsKey(string)) {
            return Integer.parseInt((String)this.schemaProps.get(string));
        }
        return 0;
    }

    class Schema {
        private String description;
        private Color bg;
        private Color blue;
        private Color red;
        private Color pink;
        private Color green;
        private Color turq;
        private Color white;
        private Color yellow;
        private Color gui;
        private Color cursor;
        private Color columnSep;
        private Color hexAttr;

        Schema() {
        }

        public String toString() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public void setColorBg(int n) {
            this.bg = new Color(n);
        }

        public Color getColorBg() {
            return this.bg;
        }

        public void setColorBlue(int n) {
            this.blue = new Color(n);
        }

        public Color getColorBlue() {
            return this.blue;
        }

        public void setColorRed(int n) {
            this.red = new Color(n);
        }

        public Color getColorRed() {
            return this.red;
        }

        public void setColorPink(int n) {
            this.pink = new Color(n);
        }

        public Color getColorPink() {
            return this.pink;
        }

        public void setColorGreen(int n) {
            this.green = new Color(n);
        }

        public Color getColorGreen() {
            return this.green;
        }

        public void setColorTurq(int n) {
            this.turq = new Color(n);
        }

        public Color getColorTurq() {
            return this.turq;
        }

        public void setColorYellow(int n) {
            this.yellow = new Color(n);
        }

        public Color getColorYellow() {
            return this.yellow;
        }

        public void setColorWhite(int n) {
            this.white = new Color(n);
        }

        public Color getColorWhite() {
            return this.white;
        }

        public void setColorGuiField(int n) {
            this.gui = new Color(n);
        }

        public Color getColorGuiField() {
            return this.gui;
        }

        public void setColorCursor(int n) {
            this.cursor = new Color(n);
        }

        public Color getColorCursor() {
            return this.cursor;
        }

        public void setColorSeparator(int n) {
            this.columnSep = new Color(n);
        }

        public Color getColorSeparator() {
            return this.columnSep;
        }

        public void setColorHexAttr(int n) {
            this.hexAttr = new Color(n);
        }

        public Color getColorHexAttr() {
            return this.hexAttr;
        }
    }
}

