/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.tn5250j.SessionConfig;
import org.tn5250j.settings.AttributesPanel;
import org.tn5250j.tools.LangTool;

public class CursorAttributesPanel
extends AttributesPanel {
    private static final long serialVersionUID = 1L;
    JRadioButton cFull;
    JRadioButton cHalf;
    JRadioButton cLine;
    JRadioButton chNone;
    JRadioButton chHorz;
    JRadioButton chVert;
    JRadioButton chCross;
    JCheckBox rulerFixed;
    JTextField cursorBottOffset;
    JRadioButton blink;

    public CursorAttributesPanel(SessionConfig sessionConfig) {
        super(sessionConfig, "Cursor");
    }

    @Override
    public void initPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.add((Component)this.contentPane, "North");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.crsSize")));
        this.cFull = new JRadioButton(LangTool.getString("sa.cFull"));
        this.cHalf = new JRadioButton(LangTool.getString("sa.cHalf"));
        this.cLine = new JRadioButton(LangTool.getString("sa.cLine"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.cFull);
        buttonGroup.add(this.cHalf);
        buttonGroup.add(this.cLine);
        int n = 0;
        if (this.getStringProperty("cursorSize").equals("Full")) {
            n = 2;
        }
        if (this.getStringProperty("cursorSize").equals("Half")) {
            n = 1;
        }
        switch (n) {
            case 0: {
                this.cLine.setSelected(true);
                break;
            }
            case 1: {
                this.cHalf.setSelected(true);
                break;
            }
            case 2: {
                this.cFull.setSelected(true);
            }
        }
        jPanel.add(this.cFull);
        jPanel.add(this.cHalf);
        jPanel.add(this.cLine);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.crossHair")));
        this.chNone = new JRadioButton(LangTool.getString("sa.chNone"));
        this.chHorz = new JRadioButton(LangTool.getString("sa.chHorz"));
        this.chVert = new JRadioButton(LangTool.getString("sa.chVert"));
        this.chCross = new JRadioButton(LangTool.getString("sa.chCross"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.chNone);
        buttonGroup2.add(this.chHorz);
        buttonGroup2.add(this.chVert);
        buttonGroup2.add(this.chCross);
        int n2 = 0;
        if (this.getStringProperty("crossHair").equals("Horz")) {
            n2 = 1;
        }
        if (this.getStringProperty("crossHair").equals("Vert")) {
            n2 = 2;
        }
        if (this.getStringProperty("crossHair").equals("Both")) {
            n2 = 3;
        }
        switch (n2) {
            case 0: {
                this.chNone.setSelected(true);
                break;
            }
            case 1: {
                this.chHorz.setSelected(true);
                break;
            }
            case 2: {
                this.chVert.setSelected(true);
                break;
            }
            case 3: {
                this.chCross.setSelected(true);
            }
        }
        jPanel2.add(this.chNone);
        jPanel2.add(this.chHorz);
        jPanel2.add(this.chVert);
        jPanel2.add(this.chCross);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(""));
        this.rulerFixed = new JCheckBox(LangTool.getString("sa.rulerFixed"));
        this.rulerFixed.setSelected(true);
        if (this.getStringProperty("rulerFixed").equals("Yes")) {
            this.rulerFixed.setSelected(false);
        }
        jPanel3.add(this.rulerFixed);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.blinkCursor")));
        this.blink = new JRadioButton(LangTool.getString("sa.blinkYes"));
        JRadioButton jRadioButton = new JRadioButton(LangTool.getString("sa.blinkNo"));
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.blink);
        buttonGroup3.add(jRadioButton);
        this.blink.setSelected(false);
        if (this.getStringProperty("cursorBlink").equals("Yes")) {
            this.blink.setSelected(true);
        } else {
            jRadioButton.setSelected(true);
        }
        jPanel4.add(this.blink);
        jPanel4.add(jRadioButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.curBottOffset")));
        this.cursorBottOffset = new JTextField(5);
        try {
            int n3 = Integer.parseInt(this.getStringProperty("cursorBottOffset", "0"));
            this.cursorBottOffset.setText(Integer.toString(n3));
        }
        catch (NumberFormatException numberFormatException) {
            this.cursorBottOffset.setText("0");
        }
        jPanel5.add(this.cursorBottOffset);
        this.contentPane.add(jPanel);
        this.contentPane.add(jPanel2);
        this.contentPane.add(jPanel3);
        this.contentPane.add(jPanel4);
        this.contentPane.add(jPanel5);
    }

    @Override
    public void save() {
    }

    @Override
    public void applyAttributes() {
        if (this.cFull.isSelected()) {
            this.changes.firePropertyChange(this, "cursorSize", this.getStringProperty("cursorSize"), "Full");
            this.setProperty("cursorSize", "Full");
        }
        if (this.cHalf.isSelected()) {
            this.changes.firePropertyChange(this, "cursorSize", this.getStringProperty("cursorSize"), "Half");
            this.setProperty("cursorSize", "Half");
        }
        if (this.cLine.isSelected()) {
            this.changes.firePropertyChange(this, "cursorSize", this.getStringProperty("cursorSize"), "Line");
            this.setProperty("cursorSize", "Line");
        }
        if (this.chNone.isSelected()) {
            this.changes.firePropertyChange(this, "crossHair", this.getStringProperty("crossHair"), "None");
            this.setProperty("crossHair", "None");
        }
        if (this.chHorz.isSelected()) {
            this.changes.firePropertyChange(this, "crossHair", this.getStringProperty("crossHair"), "Horz");
            this.setProperty("crossHair", "Horz");
        }
        if (this.chVert.isSelected()) {
            this.changes.firePropertyChange(this, "crossHair", this.getStringProperty("crossHair"), "Vert");
            this.setProperty("crossHair", "Vert");
        }
        if (this.chCross.isSelected()) {
            this.changes.firePropertyChange(this, "crossHair", this.getStringProperty("crossHair"), "Both");
            this.setProperty("crossHair", "Both");
        }
        if (this.rulerFixed.isSelected()) {
            this.changes.firePropertyChange(this, "rulerFixed", this.getStringProperty("rulerFixed"), "No");
            this.setProperty("rulerFixed", "No");
        } else {
            this.changes.firePropertyChange(this, "rulerFixed", this.getStringProperty("rulerFixed"), "Yes");
            this.setProperty("rulerFixed", "Yes");
        }
        this.changes.firePropertyChange(this, "cursorBottOffset", this.getStringProperty("cursorBottOffset"), this.cursorBottOffset.getText());
        this.setProperty("cursorBottOffset", this.cursorBottOffset.getText());
        if (this.blink.isSelected()) {
            this.changes.firePropertyChange(this, "cursorBlink", this.getStringProperty("cursorBlink"), "Yes");
            this.setProperty("cursorBlink", "Yes");
        } else {
            this.changes.firePropertyChange(this, "cursorBlink", this.getStringProperty("cursorBlink"), "No");
            this.setProperty("cursorBlink", "No");
        }
    }
}

