/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.tn5250j.SessionConfig;
import org.tn5250j.settings.AttributesPanel;
import org.tn5250j.settings.ColumnSeparator;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;

public class DisplayAttributesPanel
extends AttributesPanel {
    private static final String NO = "No";
    private static final String YES = "Yes";
    private static final long serialVersionUID = 1L;
    private JRadioButton csHide;
    private JRadioButton csLine;
    private JRadioButton csDot;
    private JRadioButton csShortLine;
    private JRadioButton saNormal;
    private JCheckBox guiCheck;
    private JCheckBox guiShowUnderline;

    public DisplayAttributesPanel(SessionConfig sessionConfig) {
        super(sessionConfig, "Display");
    }

    @Override
    public void initPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.add((Component)this.contentPane, "North");
        JPanel jPanel = new JPanel(new FlowLayout(1, 10, 10));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(LangTool.getString("sa.cs"));
        jPanel.setBorder(titledBorder);
        this.csHide = new JRadioButton(LangTool.getString("sa.csHide"));
        this.csHide.setActionCommand("Hide");
        this.csLine = new JRadioButton(LangTool.getString("sa.csLine"));
        this.csLine.setActionCommand("Line");
        this.csDot = new JRadioButton(LangTool.getString("sa.csDot"));
        this.csDot.setActionCommand("Dot");
        this.csShortLine = new JRadioButton(LangTool.getString("sa.csShortLine"));
        this.csShortLine.setActionCommand("ShortLine");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.csHide);
        buttonGroup.add(this.csLine);
        buttonGroup.add(this.csDot);
        buttonGroup.add(this.csShortLine);
        this.csLine.setSelected(ColumnSeparator.Line == ColumnSeparator.getFromName(this.getStringProperty("colSeparator")));
        this.csDot.setSelected(ColumnSeparator.Dot == ColumnSeparator.getFromName(this.getStringProperty("colSeparator")));
        this.csShortLine.setSelected(ColumnSeparator.ShortLine == ColumnSeparator.getFromName(this.getStringProperty("colSeparator")));
        this.csHide.setSelected(ColumnSeparator.Hide == ColumnSeparator.getFromName(this.getStringProperty("colSeparator")));
        jPanel.add(this.csHide);
        jPanel.add(this.csLine);
        jPanel.add(this.csDot);
        jPanel.add(this.csShortLine);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.showAttr")));
        this.saNormal = new JRadioButton(LangTool.getString("sa.showNormal"));
        this.saNormal.setActionCommand("Normal");
        JRadioButton jRadioButton = new JRadioButton(LangTool.getString("sa.showHex"));
        jRadioButton.setActionCommand("Hex");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.saNormal);
        buttonGroup2.add(jRadioButton);
        if (this.getStringProperty("showAttr").equals("Hex")) {
            jRadioButton.setSelected(true);
        } else {
            this.saNormal.setSelected(true);
        }
        jPanel2.add(this.saNormal);
        jPanel2.add(jRadioButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.cgp")));
        jPanel3.setLayout(new AlignLayout(1, 5, 5));
        this.guiCheck = new JCheckBox(LangTool.getString("sa.guiCheck"));
        this.guiCheck.setSelected(YES.equals(this.getStringProperty("guiInterface")));
        jPanel3.add(this.guiCheck);
        this.guiShowUnderline = new JCheckBox(LangTool.getString("sa.guiShowUnderline"));
        this.guiShowUnderline.setSelected(YES.equals(this.getStringProperty("guiShowUnderline")));
        jPanel3.add(this.guiShowUnderline);
        this.contentPane.add(jPanel);
        this.contentPane.add(jPanel2);
        this.contentPane.add(jPanel3);
    }

    @Override
    public void save() {
    }

    @Override
    public void applyAttributes() {
        if (this.csHide.isSelected()) {
            this.changes.firePropertyChange(this, "colSeparator", this.getStringProperty("colSeparator"), "Hide");
            this.setProperty("colSeparator", "Hide");
        } else if (this.csLine.isSelected()) {
            this.changes.firePropertyChange(this, "colSeparator", this.getStringProperty("colSeparator"), "Line");
            this.setProperty("colSeparator", "Line");
        } else if (this.csShortLine.isSelected()) {
            this.changes.firePropertyChange(this, "colSeparator", this.getStringProperty("colSeparator"), "ShortLine");
            this.setProperty("colSeparator", "ShortLine");
        } else {
            this.changes.firePropertyChange(this, "colSeparator", this.getStringProperty("colSeparator"), "Dot");
            this.setProperty("colSeparator", "Dot");
        }
        if (this.saNormal.isSelected()) {
            this.changes.firePropertyChange(this, "showAttr", this.getStringProperty("showAttr"), "Normal");
            this.setProperty("showAttr", "Normal");
        } else {
            this.changes.firePropertyChange(this, "showAttr", this.getStringProperty("showAttr"), "Hex");
            this.setProperty("showAttr", "Hex");
        }
        if (this.guiCheck.isSelected()) {
            this.changes.firePropertyChange(this, "guiInterface", this.getStringProperty("guiInterface"), YES);
            this.setProperty("guiInterface", YES);
        } else {
            this.changes.firePropertyChange(this, "guiInterface", this.getStringProperty("guiInterface"), NO);
            this.setProperty("guiInterface", NO);
        }
        if (this.guiShowUnderline.isSelected()) {
            this.changes.firePropertyChange(this, "guiShowUnderline", this.getStringProperty("guiShowUnderline"), YES);
            this.setProperty("guiShowUnderline", YES);
        } else {
            this.changes.firePropertyChange(this, "guiShowUnderline", this.getStringProperty("guiShowUnderline"), NO);
            this.setProperty("guiShowUnderline", NO);
        }
    }
}

