/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.tn5250j.SessionConfig;
import org.tn5250j.settings.AttributesPanel;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;

public class FontAttributesPanel
extends AttributesPanel {
    private static final long serialVersionUID = 1L;
    JComboBox fontsList;
    JCheckBox useAntialias;
    JTextField verticalScale;
    JTextField horizontalScale;
    JTextField pointSize;

    public FontAttributesPanel(SessionConfig sessionConfig) {
        super(sessionConfig, "Fonts");
    }

    @Override
    public void initPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.add((Component)this.contentPane, "North");
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(LangTool.getString("sa.font"));
        jPanel.setBorder(titledBorder);
        this.fontsList = new JComboBox();
        String string = this.getStringProperty("font");
        for (int i = 0; i < fontArray.length; ++i) {
            if (fontArray[i].getFontName().indexOf(46) >= 0) continue;
            this.fontsList.addItem(fontArray[i].getFontName());
        }
        this.fontsList.setSelectedItem(string);
        this.useAntialias = new JCheckBox(LangTool.getString("sa.useAntialias"));
        this.useAntialias.setSelected(this.getBooleanProperty("useAntialias", true));
        jPanel.add(this.fontsList);
        jPanel.add(this.useAntialias);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new AlignLayout(2, 5, 5));
        titledBorder = BorderFactory.createTitledBorder(LangTool.getString("sa.scaleLabel"));
        jPanel2.setBorder(titledBorder);
        this.verticalScale = new JTextField("1.2", 5);
        this.horizontalScale = new JTextField("1.0", 5);
        this.pointSize = new JTextField("0", 5);
        if (this.getStringProperty("fontScaleWidth").length() != 0) {
            this.horizontalScale.setText(this.getStringProperty("fontScaleWidth"));
        }
        if (this.getStringProperty("fontScaleHeight").length() != 0) {
            this.verticalScale.setText(this.getStringProperty("fontScaleHeight"));
        }
        if (this.getStringProperty("fontPointSize").length() != 0) {
            this.pointSize.setText(this.getStringProperty("fontPointSize"));
        }
        jPanel2.add(new JLabel(LangTool.getString("sa.fixedPointSize")));
        jPanel2.add(this.pointSize);
        jPanel2.add(new JLabel(LangTool.getString("sa.horScaleLabel")));
        jPanel2.add(this.horizontalScale);
        jPanel2.add(new JLabel(LangTool.getString("sa.vertScaleLabel")));
        jPanel2.add(this.verticalScale);
        this.contentPane.add(jPanel);
        this.contentPane.add(jPanel2);
    }

    @Override
    public void save() {
    }

    @Override
    public void applyAttributes() {
        if (!this.getStringProperty("font").equals(this.fontsList.getSelectedItem())) {
            this.changes.firePropertyChange(this, "font", this.getStringProperty("font"), this.fontsList.getSelectedItem());
            this.setProperty("font", (String)this.fontsList.getSelectedItem());
        }
        if (this.useAntialias.isSelected()) {
            this.changes.firePropertyChange(this, "useAntialias", this.getStringProperty("useAntialias"), "Yes");
            this.setProperty("useAntialias", "Yes");
        } else {
            this.changes.firePropertyChange(this, "useAntialias", this.getStringProperty("useAntialias"), "No");
            this.setProperty("useAntialias", "No");
        }
        this.changes.firePropertyChange(this, "fontScaleHeight", this.getStringProperty("fontScaleHeight"), this.verticalScale.getText());
        this.setProperty("fontScaleHeight", this.verticalScale.getText());
        this.changes.firePropertyChange(this, "fontScaleWidth", this.getStringProperty("fontScaleWidth"), this.horizontalScale.getText());
        this.setProperty("fontScaleWidth", this.horizontalScale.getText());
        this.changes.firePropertyChange(this, "fontPointSize", this.getStringProperty("fontPointSize"), this.pointSize.getText());
        this.setProperty("fontPointSize", this.pointSize.getText());
    }
}

