/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.tn5250j.SessionConfig;
import org.tn5250j.gui.TN5250jFontsSelection;
import org.tn5250j.settings.AttributesPanel;
import org.tn5250j.tools.LangTool;

public class PrinterAttributesPanel
extends AttributesPanel {
    private static final long serialVersionUID = 1L;
    JCheckBox defaultPrinter;
    JButton setPortAttributes;
    JButton setLandAttributes;
    Paper pappyPort;
    Paper pappyLand;
    JComboBox fontsList;
    TN5250jFontsSelection fs;

    public PrinterAttributesPanel(SessionConfig sessionConfig) {
        super(sessionConfig, "Printer");
    }

    @Override
    public void initPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.add((Component)this.contentPane, "North");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.print")));
        this.defaultPrinter = new JCheckBox(LangTool.getString("sa.defaultPrinter"));
        if (this.getStringProperty("defaultPrinter").equals("Yes")) {
            this.defaultPrinter.setSelected(true);
        }
        jPanel.add(this.defaultPrinter);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        this.pappyPort = pageFormat.getPaper();
        this.pappyLand = pageFormat.getPaper();
        if (this.getStringProperty("print.portWidth").length() != 0 && this.getStringProperty("print.portHeight").length() != 0 && this.getStringProperty("print.portImageWidth").length() != 0 && this.getStringProperty("print.portImageHeight").length() != 0 && this.getStringProperty("print.portImage.X").length() != 0 && this.getStringProperty("print.portImage.Y").length() != 0) {
            this.pappyPort.setSize(Double.parseDouble(this.getStringProperty("print.portWidth")), Double.parseDouble(this.getStringProperty("print.portHeight")));
            this.pappyPort.setImageableArea(Double.parseDouble(this.getStringProperty("print.portImage.X")), Double.parseDouble(this.getStringProperty("print.portImage.Y")), Double.parseDouble(this.getStringProperty("print.portImageWidth")), Double.parseDouble(this.getStringProperty("print.portImageHeight")));
        }
        if (this.getStringProperty("print.landWidth").length() != 0 && this.getStringProperty("print.landHeight").length() != 0 && this.getStringProperty("print.landImageWidth").length() != 0 && this.getStringProperty("print.landImageHeight").length() != 0 && this.getStringProperty("print.landImage.X").length() != 0 && this.getStringProperty("print.landImage.Y").length() != 0) {
            this.pappyLand.setSize(Double.parseDouble(this.getStringProperty("print.landWidth")), Double.parseDouble(this.getStringProperty("print.landHeight")));
            this.pappyLand.setImageableArea(Double.parseDouble(this.getStringProperty("print.landImage.X")), Double.parseDouble(this.getStringProperty("print.landImage.Y")), Double.parseDouble(this.getStringProperty("print.landImageWidth")), Double.parseDouble(this.getStringProperty("print.landImageHeight")));
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.pageParameters")));
        jPanel2.setLayout(new BorderLayout());
        this.setPortAttributes = new JButton(LangTool.getString("sa.columns24"));
        this.setPortAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterAttributesPanel.this.getPortraitAttributes();
            }
        });
        this.setLandAttributes = new JButton(LangTool.getString("sa.columns132"));
        this.setLandAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterAttributesPanel.this.getLandscapeAttributes();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.setPortAttributes);
        jPanel3.add(this.setLandAttributes);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel();
        this.fs = new TN5250jFontsSelection();
        if (this.getStringProperty("print.font").length() != 0) {
            this.fs.setSelectedItem(this.getStringProperty("print.font"));
        }
        jPanel4.add(this.fs);
        jPanel2.add((Component)jPanel4, "South");
        this.contentPane.add(jPanel);
        this.contentPane.add(jPanel2);
    }

    private void getPortraitAttributes() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(1);
        pageFormat.setPaper(this.pappyPort);
        pageFormat = printerJob.pageDialog(pageFormat);
        this.pappyPort = pageFormat.getPaper();
    }

    private void getLandscapeAttributes() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(0);
        pageFormat.setPaper(this.pappyLand);
        pageFormat = printerJob.pageDialog(pageFormat);
        this.pappyLand = pageFormat.getPaper();
    }

    @Override
    public void save() {
    }

    @Override
    public void applyAttributes() {
        if (this.defaultPrinter.isSelected()) {
            this.changes.firePropertyChange(this, "defaultPrinter", this.getStringProperty("defaultPrinter"), "Yes");
            this.setProperty("defaultPrinter", "Yes");
        } else {
            this.changes.firePropertyChange(this, "defaultPrinter", this.getStringProperty("defaultPrinter"), "No");
            this.setProperty("defaultPrinter", "No");
        }
        this.changes.firePropertyChange(this, "print.portWidth", this.getStringProperty("print.portWidth"), new Double(this.pappyPort.getWidth()));
        this.setProperty("print.portWidth", Double.toString(this.pappyPort.getWidth()));
        this.changes.firePropertyChange(this, "print.portImageWidth", this.getStringProperty("print.portImageWidth"), new Double(this.pappyPort.getImageableWidth()));
        this.setProperty("print.portImageWidth", Double.toString(this.pappyPort.getImageableWidth()));
        this.changes.firePropertyChange(this, "print.portHeight", this.getStringProperty("print.portHeight"), new Double(this.pappyPort.getHeight()));
        this.setProperty("print.portHeight", Double.toString(this.pappyPort.getHeight()));
        this.changes.firePropertyChange(this, "print.portImageHeight", this.getStringProperty("print.portImageHeight"), new Double(this.pappyPort.getImageableHeight()));
        this.setProperty("print.portImageHeight", Double.toString(this.pappyPort.getImageableHeight()));
        this.changes.firePropertyChange(this, "print.portImage.X", this.getStringProperty("print.portImage.X"), new Double(this.pappyPort.getImageableX()));
        this.setProperty("print.portImage.X", Double.toString(this.pappyPort.getImageableX()));
        this.changes.firePropertyChange(this, "print.portImage.Y", this.getStringProperty("print.portImage.Y"), new Double(this.pappyPort.getImageableY()));
        this.setProperty("print.portImage.Y", Double.toString(this.pappyPort.getImageableY()));
        this.changes.firePropertyChange(this, "print.landWidth", this.getStringProperty("print.landWidth"), new Double(this.pappyLand.getWidth()));
        this.setProperty("print.landWidth", Double.toString(this.pappyLand.getWidth()));
        this.changes.firePropertyChange(this, "print.landImageWidth", this.getStringProperty("print.landImageWidth"), new Double(this.pappyLand.getImageableWidth()));
        this.setProperty("print.landImageWidth", Double.toString(this.pappyLand.getImageableWidth()));
        this.changes.firePropertyChange(this, "print.landHeight", this.getStringProperty("print.landHeight"), new Double(this.pappyLand.getHeight()));
        this.setProperty("print.landHeight", Double.toString(this.pappyLand.getHeight()));
        this.changes.firePropertyChange(this, "print.landImageHeight", this.getStringProperty("print.landImageHeight"), new Double(this.pappyLand.getImageableHeight()));
        this.setProperty("print.landImageHeight", Double.toString(this.pappyLand.getImageableHeight()));
        this.changes.firePropertyChange(this, "print.landImage.X", this.getStringProperty("print.landImage.X"), new Double(this.pappyLand.getImageableX()));
        this.setProperty("print.landImage.X", Double.toString(this.pappyLand.getImageableX()));
        this.changes.firePropertyChange(this, "print.landImage.Y", this.getStringProperty("print.landImage.Y"), new Double(this.pappyLand.getImageableY()));
        this.setProperty("print.landImage.Y", Double.toString(this.pappyLand.getImageableY()));
        if (this.fs.getSelectedItem() != null) {
            this.changes.firePropertyChange(this, "print.font", this.getStringProperty("print.font"), this.fs.getSelectedItem());
            this.setProperty("print.font", (String)this.fs.getSelectedItem());
        }
    }
}

