/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tn5250j.SessionConfig;
import org.tn5250j.settings.AttributesPanel;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;

public class SignoffAttributesPanel
extends AttributesPanel {
    private static final long serialVersionUID = 1L;
    JCheckBox signoffCheck;
    JTextField fromRow;
    JTextField fromCol;
    JTextField toRow;
    JTextField toCol;

    public SignoffAttributesPanel(SessionConfig sessionConfig) {
        super(sessionConfig, "Signoff");
    }

    @Override
    public void initPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.add((Component)this.contentPane, "North");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.titleSignoff")));
        this.signoffCheck = new JCheckBox(LangTool.getString("sa.confirmSignoff"));
        this.signoffCheck.setSelected(this.getStringProperty("confirmSignoff").equals("Yes"));
        this.signoffCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SignoffAttributesPanel.this.doItemStateChanged(itemEvent);
            }
        });
        jPanel.add(this.signoffCheck);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.titleSignoffRegion")));
        AlignLayout alignLayout = new AlignLayout(4, 5, 5);
        jPanel2.setLayout(alignLayout);
        jPanel2.add(new JLabel(LangTool.getString("sa.fromRow")));
        this.fromRow = new JTextField("1", 5);
        jPanel2.add(this.fromRow);
        jPanel2.add(new JLabel(LangTool.getString("sa.fromColumn")));
        this.fromCol = new JTextField("1", 5);
        jPanel2.add(this.fromCol);
        jPanel2.add(new JLabel(LangTool.getString("sa.toRow")));
        this.toRow = new JTextField("24", 5);
        jPanel2.add(this.toRow);
        jPanel2.add(new JLabel(LangTool.getString("sa.toColumn")));
        this.toCol = new JTextField("80", 5);
        jPanel2.add(this.toCol);
        this.loadRegion();
        this.toggleRegion(this.signoffCheck.isSelected());
        this.contentPane.add(jPanel);
        this.contentPane.add(jPanel2);
    }

    private void loadRegion() {
        Rectangle rectangle = this.getRectangleProperty("signOnRegion");
        if (rectangle.x == 0) {
            this.fromRow.setText("1");
        } else {
            this.fromRow.setText(Integer.toString(rectangle.x));
        }
        if (rectangle.y == 0) {
            this.fromCol.setText("1");
        } else {
            this.fromCol.setText(Integer.toString(rectangle.y));
        }
        if (rectangle.width == 0) {
            this.toRow.setText("24");
        } else {
            this.toRow.setText(Integer.toString(rectangle.width));
        }
        if (rectangle.height == 0) {
            this.toCol.setText("80");
        } else {
            this.toCol.setText(Integer.toString(rectangle.height));
        }
    }

    private void doItemStateChanged(ItemEvent itemEvent) {
        this.toggleRegion(false);
        if (itemEvent.getStateChange() == 1 && this.signoffCheck.isSelected()) {
            this.toggleRegion(true);
        }
    }

    private void toggleRegion(boolean bl) {
        this.fromRow.setEnabled(bl);
        this.fromCol.setEnabled(bl);
        this.toRow.setEnabled(bl);
        this.toCol.setEnabled(bl);
    }

    @Override
    public void save() {
    }

    @Override
    public void applyAttributes() {
        if (this.signoffCheck.isSelected()) {
            this.changes.firePropertyChange(this, "confirmSignoff", this.getStringProperty("confirmSignoff"), "Yes");
            this.setProperty("confirmSignoff", "Yes");
        } else {
            this.changes.firePropertyChange(this, "confirmSignoff", this.getStringProperty("confirmSignoff"), "No");
            this.setProperty("confirmSignoff", "No");
        }
        Rectangle rectangle = new Rectangle(Integer.parseInt(this.fromRow.getText()), Integer.parseInt(this.fromCol.getText()), Integer.parseInt(this.toRow.getText()), Integer.parseInt(this.toCol.getText()));
        if (rectangle.x < 0) {
            rectangle.x = 1;
        }
        if (rectangle.y < 0) {
            rectangle.y = 1;
        }
        if (rectangle.width > 24) {
            rectangle.width = 24;
        }
        if (rectangle.height > 80) {
            rectangle.height = 80;
        }
        this.setRectangleProperty("signOnRegion", rectangle);
    }
}

