/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.spoolfile;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class ExportFileFilter
extends FileFilter {
    private Hashtable filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public ExportFileFilter() {
    }

    public ExportFileFilter(String string) {
        this(string, null);
    }

    public ExportFileFilter(String string, String string2) {
        this();
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public ExportFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public ExportFileFilter(String[] stringArray, String string) {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExtension(stringArray[i]);
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters.get(this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        if (file != null) {
            return this.getExtension(file.getName());
        }
        return null;
    }

    public String getExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(string.toLowerCase(), this);
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration enumeration = this.filters.keys();
                if (enumeration != null) {
                    this.fullDescription = this.fullDescription + "." + (String)enumeration.nextElement();
                    while (enumeration.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", ." + (String)enumeration.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public String setExtension(File file) {
        return this.setExtension(file.getAbsolutePath());
    }

    public String setExtension(String string) {
        if (string != null & this.getExtension(string) == null) {
            Enumeration enumeration = this.filters.keys();
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("htm")) {
                string2 = "html";
            }
            string = string + "." + string2.toLowerCase();
        }
        return string;
    }
}

