/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.spoolfile;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.PrintObjectTransformedInputStream;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.vaccess.FileFilter;
import com.ibm.as400.vaccess.IFSFileDialog;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.WizardEvent;
import org.tn5250j.event.WizardListener;
import org.tn5250j.gui.GenericTn5250JFrame;
import org.tn5250j.gui.TN5250jFileChooser;
import org.tn5250j.gui.Wizard;
import org.tn5250j.gui.WizardPage;
import org.tn5250j.mailtools.SendEMailDialog;
import org.tn5250j.spoolfile.ExportFileFilter;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;

public class SpoolExportWizard
extends GenericTn5250JFrame
implements WizardListener {
    private static final long serialVersionUID = 1L;
    JPanel contentPane;
    JLabel statusBar = new JLabel();
    JPanel spoolPanel = new JPanel();
    JPanel spoolData = new JPanel();
    JPanel spoolOptions = new JPanel();
    JPanel destPanel = new JPanel();
    JLabel labelSpooledFile = new JLabel();
    JLabel spooledFile = new JLabel();
    JLabel labelJobName = new JLabel();
    JLabel jobName = new JLabel();
    JLabel labelUser = new JLabel();
    JLabel user = new JLabel();
    JLabel labelNumber = new JLabel();
    JLabel number = new JLabel();
    JLabel labelFileNumber = new JLabel();
    JLabel spooledFileNumber = new JLabel();
    JLabel labelSystem = new JLabel();
    JLabel systemName = new JLabel();
    JLabel labelPages = new JLabel();
    JLabel pages = new JLabel();
    JComboBox cvtType;
    JTextField pcPathInfo;
    JTextField ifsPathInfo;
    JButton pcSave;
    JButton ifsSave;
    JRadioButton pc;
    JRadioButton ifs;
    JRadioButton email;
    JTextField title;
    JTextField subject;
    JTextField author;
    JTextField fontSize;
    JComboBox pageSize;
    JRadioButton portrait;
    JRadioButton landscape;
    JCheckBox openAfter;
    JTextField editor;
    JButton getEditor;
    SpooledFile splfile;
    SessionPanel session;
    JPanel twoPDF;
    JPanel twoText;
    Wizard wizard;
    WizardPage page;
    WizardPage pagePDF;
    WizardPage pageText;
    JButton nextButton;
    private PdfWriter bos;
    private Document document;
    private Font font;
    private FileOutputStream fw;
    private IFSFileOutputStream ifsfw;
    private String conicalPath;
    private Thread workingThread;

    public SpoolExportWizard(SpooledFile spooledFile, SessionPanel sessionPanel) {
        this.enableEvents(64L);
        this.splfile = spooledFile;
        this.session = sessionPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.wizard = new Wizard();
        this.wizard.addWizardListener(this);
        this.getContentPane().add(this.wizard);
        this.page = new WizardPage(30);
        this.page.setName(LangTool.getString("spool.titlePage1"));
        this.setTitle(this.page.getName());
        this.nextButton = this.page.getNextButton();
        this.page.getContentPane().add((Component)this.pageOne(), "Center");
        this.wizard.add(this.page);
        this.pagePDF = new WizardPage(29);
        this.pagePDF.setName(LangTool.getString("spool.titlePage2PDF"));
        this.pagePDF.getContentPane().add((Component)this.pageTwoPDF(), "Center");
        this.wizard.add(this.pagePDF);
        this.pageText = new WizardPage(29);
        this.pageText.setName(LangTool.getString("spool.titlePage2Txt"));
        this.pageText.getContentPane().add((Component)this.pageTwoText(), "Center");
        this.wizard.add(this.pageText);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private JPanel pageTwoPDF() {
        this.twoPDF = new JPanel();
        this.twoPDF.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.labelProps")));
        jPanel.setLayout(new AlignLayout(2, 5, 5));
        jPanel.add(new JLabel(LangTool.getString("spool.labelPropsTitle")));
        this.title = new JTextField(40);
        jPanel.add(this.title);
        jPanel.add(new JLabel(LangTool.getString("spool.labelPropsSubject")));
        this.subject = new JTextField(40);
        jPanel.add(this.subject);
        jPanel.add(new JLabel(LangTool.getString("spool.labelPropsAuthor")));
        this.author = new JTextField(40);
        jPanel.add(this.author);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.labelOpts")));
        jPanel2.setLayout(new AlignLayout(2, 5, 5));
        jPanel2.add(new JLabel(LangTool.getString("spool.labelOptsFontSize")));
        this.fontSize = new JTextField(5);
        jPanel2.add(this.fontSize);
        jPanel2.add(new JLabel(LangTool.getString("spool.labelOptsPageSize")));
        this.pageSize = new JComboBox();
        jPanel2.add(this.pageSize);
        this.pageSize.addItem("A3");
        this.pageSize.addItem("A4");
        this.pageSize.addItem("A5");
        this.pageSize.addItem("LETTER");
        this.pageSize.addItem("LEGAL");
        this.pageSize.addItem("LEDGER");
        this.portrait = new JRadioButton(LangTool.getString("spool.labelOptsPortrait"));
        jPanel2.add(this.portrait);
        this.landscape = new JRadioButton(LangTool.getString("spool.labelOptsLandscape"));
        jPanel2.add(this.landscape);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.portrait);
        buttonGroup.add(this.landscape);
        this.landscape.setSelected(true);
        this.twoPDF.add((Component)jPanel, "North");
        this.twoPDF.add((Component)jPanel2, "Center");
        return this.twoPDF;
    }

    private JPanel pageTwoText() {
        this.twoText = new JPanel();
        this.twoText.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.labelTextProps")));
        jPanel.setLayout(new AlignLayout(2, 5, 5));
        this.openAfter = new JCheckBox(LangTool.getString("spool.labelUseExternal"));
        jPanel.add(this.openAfter);
        jPanel.add(new JLabel());
        this.editor = new JTextField(30);
        jPanel.add(this.editor);
        this.getEditor = new JButton("Browse");
        this.getEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpoolExportWizard.this.getEditor();
            }
        });
        jPanel.add(this.getEditor);
        if (this.session.getSession().getConfiguration().isPropertyExists("useExternal")) {
            this.openAfter.setEnabled(true);
        }
        if (this.session.getSession().getConfiguration().isPropertyExists("externalViewer")) {
            this.editor.setText(this.session.getSession().getConfiguration().getStringProperty("externalViewer"));
        }
        this.twoText.add((Component)jPanel, "Center");
        return this.twoText;
    }

    private JPanel pageOne() throws Exception {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.statusBar.setText(" ");
        this.statusBar.setBorder(BorderFactory.createEtchedBorder());
        this.spoolPanel.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.spoolPanel, "Center");
        this.contentPane.add((Component)this.statusBar, "South");
        this.labelSpooledFile.setText(LangTool.getString("spool.labelSpooledFile"));
        this.labelJobName.setText(LangTool.getString("spool.labelJobName"));
        this.labelUser.setText(LangTool.getString("spool.labelJobUser"));
        this.labelNumber.setText(LangTool.getString("spool.labelJobNumber"));
        this.labelFileNumber.setText(LangTool.getString("spool.labelSpoolNumber"));
        this.labelSystem.setText(LangTool.getString("spool.labelSystem"));
        this.labelPages.setText(LangTool.getString("spool.labelPages"));
        this.spoolData.setLayout(new AlignLayout(2, 5, 5));
        this.spoolData.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.labelSpoolInfo")));
        this.spooledFile.setText(this.splfile.getName());
        this.jobName.setText(this.splfile.getJobName());
        this.user.setText(this.splfile.getJobUser());
        this.spooledFileNumber.setText(Integer.toString(this.splfile.getNumber()));
        this.number.setText(this.splfile.getJobNumber());
        this.systemName.setText(this.splfile.getSystem().getSystemName());
        this.pages.setText(this.splfile.getIntegerAttribute(111).toString());
        this.spoolData.add((Component)this.labelSystem, null);
        this.spoolData.add((Component)this.systemName, null);
        this.spoolData.add((Component)this.labelSpooledFile, null);
        this.spoolData.add((Component)this.spooledFile, null);
        this.spoolData.add((Component)this.labelJobName, null);
        this.spoolData.add((Component)this.jobName, null);
        this.spoolData.add((Component)this.labelUser, null);
        this.spoolData.add((Component)this.user, null);
        this.spoolData.add((Component)this.labelNumber, null);
        this.spoolData.add((Component)this.number, null);
        this.spoolData.add((Component)this.labelFileNumber, null);
        this.spoolData.add((Component)this.spooledFileNumber, null);
        this.spoolData.add((Component)this.labelPages, null);
        this.spoolData.add((Component)this.pages, null);
        this.spoolPanel.add((Component)this.spoolOptions, "South");
        this.spoolPanel.add((Component)this.spoolData, "Center");
        this.spoolOptions.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        AlignLayout alignLayout = new AlignLayout(3, 5, 5);
        jPanel.setLayout(alignLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.labelExportInfo")));
        this.cvtType = new JComboBox();
        this.cvtType.addItem(LangTool.getString("spool.toPDF"));
        this.cvtType.addItem(LangTool.getString("spool.toText"));
        jPanel.add(new JLabel(LangTool.getString("spool.labelFormat")));
        jPanel.add(this.cvtType);
        jPanel.add(new JLabel(""));
        this.pc = new JRadioButton(LangTool.getString("spool.labelPCPath"));
        this.pcPathInfo = new JTextField(30);
        this.pcSave = new JButton("...");
        this.pcSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpoolExportWizard.this.getPCFile();
            }
        });
        jPanel.add(this.pc);
        jPanel.add(this.pcPathInfo);
        jPanel.add(this.pcSave);
        this.ifs = new JRadioButton(LangTool.getString("spool.labelIFSPath"));
        this.ifsPathInfo = new JTextField(30);
        this.ifsSave = new JButton("...");
        this.ifsSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpoolExportWizard.this.getIFSFile();
            }
        });
        jPanel.add(this.ifs);
        jPanel.add(this.ifsPathInfo);
        jPanel.add(this.ifsSave);
        this.email = new JRadioButton(LangTool.getString("spool.labelEmail"));
        jPanel.add(this.email);
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel(""));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.pc);
        buttonGroup.add(this.ifs);
        buttonGroup.add(this.email);
        this.pc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SpoolExportWizard.this.doItemStateChanged(itemEvent);
            }
        });
        this.ifs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SpoolExportWizard.this.doItemStateChanged(itemEvent);
            }
        });
        this.email.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SpoolExportWizard.this.doItemStateChanged(itemEvent);
            }
        });
        this.pc.setSelected(true);
        this.spoolOptions.add((Component)jPanel, "Center");
        return this.contentPane;
    }

    private void doItemStateChanged(ItemEvent itemEvent) {
        this.pcPathInfo.setEnabled(false);
        this.ifsPathInfo.setEnabled(false);
        this.pcSave.setEnabled(false);
        this.ifsSave.setEnabled(false);
        if (itemEvent.getStateChange() == 1) {
            if (this.pc.isSelected()) {
                this.pcPathInfo.setEnabled(true);
                this.pcSave.setEnabled(true);
                this.pcPathInfo.grabFocus();
            }
            if (this.ifs.isSelected()) {
                this.ifsPathInfo.setEnabled(true);
                this.ifsSave.setEnabled(true);
                this.ifsPathInfo.grabFocus();
            }
        }
    }

    private boolean pagesValid() {
        if (this.pc.isSelected()) {
            if (this.pcPathInfo.getText().length() == 0) {
                this.getPCFile();
            }
            if (this.pcPathInfo.getText().length() == 0) {
                return false;
            }
        }
        return true;
    }

    private void getPCFile() {
        String string = System.getProperty("user.dir");
        TN5250jFileChooser tN5250jFileChooser = new TN5250jFileChooser(string);
        ExportFileFilter exportFileFilter = ((String)this.cvtType.getSelectedItem()).equals(LangTool.getString("spool.toPDF")) ? new ExportFileFilter("pdf", "PDF Files") : new ExportFileFilter("txt", "Text Files");
        tN5250jFileChooser.addChoosableFileFilter(exportFileFilter);
        int n = tN5250jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = tN5250jFileChooser.getSelectedFile();
            this.pcPathInfo.setText(exportFileFilter.setExtension(file));
        }
    }

    private void getIFSFile() {
        IFSFileDialog iFSFileDialog = new IFSFileDialog((Frame)this, "Save As", this.splfile.getSystem());
        FileFilter[] fileFilterArray = new FileFilter[]{new FileFilter("All files (*.*)", "*.*"), this.cvtType.getSelectedIndex() == 0 ? new FileFilter("PDF files (*.pdf)", "*.pdf") : new FileFilter("Text files (*.txt)", "*.txt")};
        iFSFileDialog.setFileFilter(fileFilterArray, 1);
        if (iFSFileDialog.showDialog() == 1) {
            this.ifsPathInfo.setText(iFSFileDialog.getAbsolutePath());
        }
    }

    private void getEditor() {
        String string = System.getProperty("user.dir");
        TN5250jFileChooser tN5250jFileChooser = new TN5250jFileChooser(string);
        int n = tN5250jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = tN5250jFileChooser.getSelectedFile();
            try {
                this.editor.setText(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void doExport() {
        if (!this.pagesValid()) {
            return;
        }
        this.workingThread = null;
        this.workingThread = this.cvtType.getSelectedIndex() == 0 ? new Thread(new Runnable(){

            @Override
            public void run() {
                SpoolExportWizard.this.cvtToPDF();
            }
        }) : new Thread(new Runnable(){

            @Override
            public void run() {
                SpoolExportWizard.this.cvtToText();
            }
        });
        this.workingThread.start();
    }

    private void emailMe() {
        SendEMailDialog sendEMailDialog = new SendEMailDialog((Frame)this, this.session, this.conicalPath);
    }

    private void cvtToText() {
        try {
            this.openOutputFile();
            PrintStream printStream = this.ifs.isSelected() ? new PrintStream((OutputStream)this.ifsfw) : new PrintStream(this.fw);
            AS400 aS400 = new AS400(this.systemName.getText());
            String string = this.spooledFile.getText();
            int n = Integer.parseInt(this.spooledFileNumber.getText());
            String string2 = this.jobName.getText();
            String string3 = this.user.getText();
            String string4 = this.number.getText();
            SpooledFile spooledFile = new SpooledFile(aS400, string, n, string2, string3, string4);
            PrintParameterList printParameterList = new PrintParameterList();
            printParameterList.setParameter(-8, "/QSYS.LIB/QWPDEFAULT.WSCST");
            printParameterList.setParameter(65, "*WSCST");
            PrintObjectTransformedInputStream printObjectTransformedInputStream = spooledFile.getTransformedInputStream(printParameterList);
            int n2 = printObjectTransformedInputStream.available();
            byte[] byArray = new byte[n2 + 1];
            int n3 = 0;
            int n4 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            this.updateStatus("Starting Output");
            while (n2 > 0) {
                if (n2 > byArray.length) {
                    byArray = new byte[n2 + 1];
                }
                n3 = printObjectTransformedInputStream.read(byArray, 0, n2);
                block11: for (int i = 0; i < n3; ++i) {
                    switch (byArray[i]) {
                        case 0: {
                            continue block11;
                        }
                        case 10: {
                            printStream.println(stringBuffer.toString().toCharArray());
                            stringBuffer.setLength(0);
                            continue block11;
                        }
                        case 13: {
                            continue block11;
                        }
                        case 12: {
                            printStream.println(stringBuffer.toString().toCharArray());
                            stringBuffer.setLength(0);
                            continue block11;
                        }
                        default: {
                            stringBuffer.append(SpoolExportWizard.byte2char(byArray[i], "cp850"));
                        }
                    }
                }
                this.updateStatus("Bytes read " + (n4 += n3));
                n2 = printObjectTransformedInputStream.available();
            }
            if (stringBuffer.length() > 0) {
                printStream.println(stringBuffer.toString().toCharArray());
            }
            printStream.flush();
            printStream.close();
            this.updateStatus("Total bytes converted " + n4);
            if (this.openAfter.isSelected()) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    String[] stringArray = new String[]{this.editor.getText(), this.pcPathInfo.getText()};
                    runtime.exec(stringArray);
                    if (this.openAfter.isSelected()) {
                        this.session.getSession().getConfiguration().setProperty("useExternal", "");
                    } else {
                        this.session.getSession().getConfiguration().removeProperty("useExternal");
                    }
                    this.session.getSession().getConfiguration().setProperty("externalViewer", this.editor.getText());
                    this.session.getSession().getConfiguration().saveSessionProps();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    JOptionPane.showMessageDialog(this, throwable.getMessage(), "error", 0);
                }
            }
            if (this.email.isSelected()) {
                this.emailMe();
            }
        }
        catch (Exception exception) {
            this.updateStatus("Error: " + exception.getMessage());
            System.out.println("Error: " + exception.getMessage());
        }
    }

    private void cvtToPDF() {
        try {
            this.openOutputFile();
            PrintParameterList printParameterList = new PrintParameterList();
            printParameterList.setParameter(-8, "/QSYS.LIB/QWPDEFAULT.WSCST");
            printParameterList.setParameter(65, "*WSCST");
            PrintObjectTransformedInputStream printObjectTransformedInputStream = this.splfile.getTransformedInputStream(printParameterList);
            int n = printObjectTransformedInputStream.available();
            byte[] byArray = new byte[n + 1];
            int n2 = 0;
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            this.updateStatus("Starting Output");
            while (n > 0) {
                if (n > byArray.length) {
                    byArray = new byte[n + 1];
                }
                n2 = printObjectTransformedInputStream.read(byArray, 0, n);
                block9: for (int i = 0; i < n2; ++i) {
                    switch (byArray[i]) {
                        case 0: {
                            continue block9;
                        }
                        case 10: {
                            stringBuffer.append((char)byArray[i]);
                            continue block9;
                        }
                        case 13: {
                            continue block9;
                        }
                        case 12: {
                            this.writeBuffer(stringBuffer.toString());
                            this.document.newPage();
                            stringBuffer.setLength(0);
                            continue block9;
                        }
                        default: {
                            stringBuffer.append(SpoolExportWizard.byte2char(byArray[i], "cp850"));
                        }
                    }
                }
                this.updateStatus("Bytes read " + (n3 += n2));
                n = printObjectTransformedInputStream.available();
            }
            this.closeOutputFile();
            this.updateStatus("Total bytes converted " + n3);
            if (this.email.isSelected()) {
                this.emailMe();
            }
        }
        catch (Exception exception) {
            this.updateStatus("Error: " + exception.getMessage());
            System.out.println("Error: " + exception.getMessage());
        }
    }

    private void writeBuffer(String string) {
        if (!this.document.isOpen()) {
            this.document.open();
        }
        try {
            this.document.add((Element)new Paragraph(string, this.font));
        }
        catch (DocumentException documentException) {
            System.out.println((Object)documentException);
        }
    }

    public void openOutputFile() {
        try {
            Object object;
            File file;
            this.updateStatus("Opening File");
            String string = ".txt";
            String string2 = "";
            if (this.cvtType.getSelectedIndex() == 0) {
                string = ".pdf";
            }
            if (this.email.isSelected()) {
                file = new File(System.getProperty("user.dir"));
                String string3 = this.spooledFile.getText().trim() + '_' + this.jobName.getText().trim() + '_' + this.user.getText().trim() + '_' + this.spooledFileNumber.getText().trim() + '_' + this.number.getText().trim();
                object = File.createTempFile(string3, string, file);
                System.out.println(((File)object).getName());
                System.out.println(((File)object).getCanonicalPath());
                this.conicalPath = ((File)object).getCanonicalPath();
                ((File)object).deleteOnExit();
                this.fw = new FileOutputStream((File)object);
            } else if (this.ifs.isSelected()) {
                string2 = this.ifsPathInfo.getText().trim();
                this.ifsfw = new IFSFileOutputStream(this.splfile.getSystem(), string2);
            } else {
                string2 = this.pcPathInfo.getText().trim();
                this.fw = new FileOutputStream(string2);
            }
            if (this.cvtType.getSelectedIndex() > 0) {
                return;
            }
            if (this.document == null) {
                this.document = new Document();
                this.bos = this.ifs.isSelected() ? PdfWriter.getInstance((Document)this.document, (OutputStream)this.ifsfw) : PdfWriter.getInstance((Document)this.document, (OutputStream)this.fw);
                file = BaseFont.createFont((String)"Courier", (String)"Cp1252", (boolean)false);
                float f = 9.0f;
                if (this.fontSize.getText().length() > 0) {
                    f = Float.parseFloat(this.fontSize.getText().trim());
                }
                this.font = new Font((BaseFont)file, f, 0);
                if (this.author.getText().length() > 0) {
                    this.document.addAuthor(this.author.getText());
                }
                if (this.title.getText().length() > 0) {
                    this.document.addTitle(this.title.getText());
                }
                if (this.subject.getText().length() > 0) {
                    this.document.addSubject(this.subject.getText());
                }
                if (((String)(object = (String)this.pageSize.getSelectedItem())).equals("A3")) {
                    if (this.portrait.isSelected()) {
                        this.document.setPageSize(PageSize.A3);
                    } else {
                        this.document.setPageSize(PageSize.A3.rotate());
                    }
                }
                if (((String)object).equals("A4")) {
                    if (this.portrait.isSelected()) {
                        this.document.setPageSize(PageSize.A4);
                    } else {
                        this.document.setPageSize(PageSize.A4.rotate());
                    }
                }
                if (((String)object).equals("A5")) {
                    if (this.portrait.isSelected()) {
                        this.document.setPageSize(PageSize.A5);
                    } else {
                        this.document.setPageSize(PageSize.A5.rotate());
                    }
                }
                if (((String)object).equals("LETTER")) {
                    if (this.portrait.isSelected()) {
                        this.document.setPageSize(PageSize.LETTER);
                    } else {
                        this.document.setPageSize(PageSize.LETTER.rotate());
                    }
                }
                if (((String)object).equals("LEGAL")) {
                    if (this.portrait.isSelected()) {
                        this.document.setPageSize(PageSize.LEGAL);
                    } else {
                        this.document.setPageSize(PageSize.LEGAL.rotate());
                    }
                }
                if (((String)object).equals("LEDGER")) {
                    if (this.portrait.isSelected()) {
                        this.document.setPageSize(PageSize.LEDGER);
                    } else {
                        this.document.setPageSize(PageSize.LEDGER.rotate());
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Cannot open 1 " + iOException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("Cannot open 2 " + exception.getMessage());
        }
    }

    private void closeOutputFile() {
        this.document.close();
        this.document = null;
    }

    private void updateStatus(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpoolExportWizard.this.statusBar.setText(string);
            }
        });
    }

    @Override
    public void nextBegin(WizardEvent wizardEvent) {
        if (((String)this.cvtType.getSelectedItem()).equals(LangTool.getString("spool.toText"))) {
            this.twoText.add((Component)this.statusBar, "South");
            wizardEvent.setNewPage(this.pageText);
        } else {
            this.twoPDF.add((Component)this.statusBar, "South");
            wizardEvent.setNewPage(this.pagePDF);
        }
    }

    @Override
    public void nextComplete(WizardEvent wizardEvent) {
        this.setTitle(wizardEvent.getNewPage().getName());
    }

    @Override
    public void previousBegin(WizardEvent wizardEvent) {
        wizardEvent.setNewPage(this.page);
        this.contentPane.add((Component)this.statusBar, "South");
    }

    @Override
    public void previousComplete(WizardEvent wizardEvent) {
        this.setTitle(wizardEvent.getNewPage().getName());
    }

    @Override
    public void finished(WizardEvent wizardEvent) {
        this.doExport();
    }

    @Override
    public void canceled(WizardEvent wizardEvent) {
        if (this.workingThread != null) {
            this.workingThread.interrupt();
            this.workingThread = null;
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void help(WizardEvent wizardEvent) {
        System.out.println(wizardEvent.getCurrentPage().getName());
    }

    public static char byte2char(byte by, String string) {
        char c = ' ';
        try {
            byte[] byArray = new byte[]{by};
            c = new String(byArray, string).charAt(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException);
            System.err.println("Error while converting byte to char, returning blank...");
        }
        return c;
    }
}

