/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.spoolfile;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.PrintObjectListEvent;
import com.ibm.as400.access.PrintObjectListListener;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.SpooledFileList;
import com.ibm.as400.vaccess.SpooledFileViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.gui.DefaultSortTableModel;
import org.tn5250j.gui.GenericTn5250JFrame;
import org.tn5250j.gui.JSortTable;
import org.tn5250j.spoolfile.SpoolExportWizard;
import org.tn5250j.spoolfile.SpoolFilterPane;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;

public class SpoolExporter
extends GenericTn5250JFrame {
    private static final long serialVersionUID = 1L;
    SpoolFilterPane filter;
    SpoolTableModel stm;
    JScrollPane scrollPane;
    ListSelectionModel rowSM;
    JSortTable spools;
    JLabel status;
    AS400 system;
    tnvt vt;
    SessionPanel session;
    Vector data = new Vector();
    Vector row = new Vector();
    Vector names = new Vector();
    SpooledFileList splfList;

    public SpoolExporter(tnvt tnvt2, SessionPanel sessionPanel) {
        this.vt = tnvt2;
        this.session = sessionPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(LangTool.getString("spool.title"));
        this.setIconImages(GUIGraphicsUtils.getApplicationIcons());
        this.getContentPane().add((Component)this.createFilterPanel(), "North");
        this.stm = new SpoolTableModel();
        this.spools = new JSortTable(this.stm);
        TableColumn tableColumn = null;
        for (int i = 0; i < this.stm.getColumnCount(); ++i) {
            tableColumn = this.spools.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(this.stm.getColumnPreferredSize(i));
        }
        this.spools.setAutoResizeMode(0);
        this.spools.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SpoolExporter.this.spools_mouseClicked(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    SpoolExporter.this.showPopupMenu(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    SpoolExporter.this.showPopupMenu(mouseEvent);
                }
            }
        });
        this.spools.setShowGrid(false);
        this.scrollPane = new JScrollPane(this.spools);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.spools.setPreferredScrollableViewportSize(new Dimension(this.spools.getPreferredScrollableViewportSize().width, this.spools.getFontMetrics(this.spools.getFont()).getHeight() * 8));
        this.scrollPane.getViewport().setBackground(this.spools.getBackground());
        this.scrollPane.setBackground(this.spools.getBackground());
        this.rowSM = this.spools.getSelectionModel();
        this.rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            }
        });
        this.rowSM.setSelectionMode(0);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.status = new JLabel("0 " + LangTool.getString("spool.count"));
        this.status.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)this.status, "South");
        this.packFrame = true;
        this.centerFrame();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (SpoolExporter.this.system != null) {
                    if (SpoolExporter.this.splfList != null) {
                        SpoolExporter.this.splfList.close();
                        SpoolExporter.this.splfList = null;
                    }
                    SpoolExporter.this.system.disconnectAllServices();
                }
                SpoolExporter.this.setVisible(false);
                SpoolExporter.this.dispose();
            }
        });
    }

    private JPanel createFilterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.filterTitle")));
        this.filter = new SpoolFilterPane();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(LangTool.getString("spool.load"));
        JButton jButton2 = new JButton(LangTool.getString("spool.resetAll"));
        JButton jButton3 = new JButton(LangTool.getString("spool.resetPanel"));
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpoolExporter.this.runLoader();
            }
        });
        jPanel2.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpoolExporter.this.filter.resetCurrent();
            }
        });
        jPanel2.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpoolExporter.this.filter.resetAll();
            }
        });
        jPanel.add((Component)this.filter, "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void runLoader() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SpoolExporter.this.loadSpoolFiles();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    private void loadSpoolFiles() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.splfList != null) {
            this.splfList.removePrintObjectListListener((PrintObjectListListener)this.stm);
            this.splfList.close();
            this.splfList = null;
        }
        this.data.clear();
        try {
            this.updateStatus(LangTool.getString("spool.working"));
            if (this.system == null) {
                this.system = new AS400(this.vt.getHostName());
            }
            this.splfList = new SpooledFileList(this.system);
            this.splfList.setUserFilter(this.filter.getUser());
            this.splfList.setQueueFilter("/QSYS.LIB/" + this.filter.getLibrary() + ".LIB/" + this.filter.getQueue() + ".OUTQ");
            if (this.filter.getUserData().length() > 0) {
                this.splfList.setUserDataFilter(this.filter.getUserData());
            }
            this.stm.setDataVector(this.data, this.names);
            TableColumn tableColumn = null;
            for (int i = 0; i < this.stm.getColumnCount(); ++i) {
                tableColumn = this.spools.getColumnModel().getColumn(i);
                tableColumn.setPreferredWidth(this.stm.getColumnPreferredSize(i));
            }
            this.splfList.openAsynchronously();
            this.splfList.addPrintObjectListListener((PrintObjectListListener)this.stm);
            if (this.splfList != null) {
                this.updateStatus(this.splfList.size() + " " + LangTool.getString("spool.count"));
            }
        }
        catch (Exception exception) {
            this.updateStatus(exception.getMessage(), true);
        }
    }

    private void loadStringAttribute(SpooledFile spooledFile, Vector vector, int n) {
        try {
            vector.add(spooledFile.getStringAttribute(n));
        }
        catch (Exception exception) {
            vector.add("Attribute Not supported");
        }
    }

    private void loadIntegerAttribute(SpooledFile spooledFile, Vector vector, int n) {
        try {
            vector.add(spooledFile.getIntegerAttribute(n));
        }
        catch (Exception exception) {
            vector.add("Attribute Not supported");
        }
    }

    private void loadCreateDateTime(SpooledFile spooledFile, Vector vector) {
        try {
            String string = SpoolExporter.formatDate(spooledFile.getStringAttribute(34)) + " " + SpoolExporter.formatTime(spooledFile.getStringAttribute(110));
            vector.add(string);
        }
        catch (Exception exception) {
            vector.add("Attribute Not supported");
        }
    }

    static String formatDate(String string) {
        if (string != null) {
            char[] cArray = string.toCharArray();
            if (cArray.length != 7) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray, 1, 6);
            if (cArray[0] == '0') {
                stringBuffer.insert(0, "19");
            } else {
                stringBuffer.insert(0, "20");
            }
            stringBuffer.insert(4, '/');
            stringBuffer.insert(7, '/');
            return stringBuffer.toString();
        }
        return "";
    }

    static String formatTime(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(stringBuffer.length() - 2, ':');
            stringBuffer.insert(stringBuffer.length() - 5, ':');
            return stringBuffer.toString();
        }
        return "";
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        final int n = this.spools.rowAtPoint(mouseEvent.getPoint());
        final int n2 = this.spools.convertColumnIndexToModel(this.spools.columnAtPoint(mouseEvent.getPoint()));
        AbstractAction abstractAction = new AbstractAction(LangTool.getString("spool.optionView")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(n + " is selected ");
                SpoolExporter.this.spools.setCursor(Cursor.getPredefinedCursor(3));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpoolExporter.this.displayViewer(SpoolExporter.this.getSpooledFile(n));
                    }
                });
            }
        };
        jPopupMenu.add(abstractAction);
        abstractAction = new AbstractAction(LangTool.getString("spool.optionProps")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(null, "Not Available yet", "Not yet", 2);
            }
        };
        jPopupMenu.add(abstractAction);
        jPopupMenu.addSeparator();
        abstractAction = new AbstractAction(LangTool.getString("spool.optionExport")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpoolExportWizard spoolExportWizard = new SpoolExportWizard(SpoolExporter.this.getSpooledFile(n), SpoolExporter.this.session);
                spoolExportWizard.setVisible(true);
            }
        };
        jPopupMenu.add(abstractAction);
        jPopupMenu.addSeparator();
        switch (n2) {
            case 0: 
            case 3: 
            case 6: {
                abstractAction = new AbstractAction(LangTool.getString("spool.labelFilter")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SpoolExporter.this.setFilter(n, n2);
                    }
                };
                jPopupMenu.add(abstractAction);
                jPopupMenu.addSeparator();
            }
        }
        abstractAction = new AbstractAction(LangTool.getString("spool.optionHold")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpoolExporter.this.doSpoolStuff(SpoolExporter.this.getSpooledFile(n), actionEvent.getActionCommand());
            }
        };
        jPopupMenu.add(abstractAction);
        abstractAction = new AbstractAction(LangTool.getString("spool.optionRelease")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpoolExporter.this.doSpoolStuff(SpoolExporter.this.getSpooledFile(n), actionEvent.getActionCommand());
            }
        };
        jPopupMenu.add(abstractAction);
        abstractAction = new AbstractAction(LangTool.getString("spool.optionDelete")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpoolExporter.this.doSpoolStuff(SpoolExporter.this.getSpooledFile(n), actionEvent.getActionCommand());
            }
        };
        jPopupMenu.add(abstractAction);
        GUIGraphicsUtils.positionPopup(this.spools, jPopupMenu, mouseEvent.getX(), mouseEvent.getY());
    }

    private SpooledFile getSpooledFile(int n) {
        Vector vector = (Vector)this.data.get(n);
        SpooledFile spooledFile = new SpooledFile(this.system, (String)vector.get(0), ((Integer)vector.get(1)).intValue(), (String)vector.get(2), (String)vector.get(3), (String)vector.get(4));
        return spooledFile;
    }

    private void doSpoolStuff(SpooledFile spooledFile, String string) {
        try {
            if (string.equals(LangTool.getString("spool.optionHold"))) {
                spooledFile.hold(null);
            }
            if (string.equals(LangTool.getString("spool.optionRelease"))) {
                spooledFile.release();
            }
            if (string.equals(LangTool.getString("spool.optionDelete"))) {
                spooledFile.delete();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    void spools_mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            final int n = this.spools.rowAtPoint(mouseEvent.getPoint());
            this.spools.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpoolExporter.this.displayViewer(SpoolExporter.this.getSpooledFile(n));
                }
            });
        }
    }

    private void displayViewer(SpooledFile spooledFile) {
        SpooledFileViewer spooledFileViewer = new SpooledFileViewer(spooledFile, 1);
        try {
            spooledFileViewer.load();
            JFrame jFrame = new JFrame(LangTool.getString("spool.viewerTitle"));
            jFrame.setIconImage(this.getIconImage());
            jFrame.getContentPane().add((Component)spooledFileViewer);
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            this.updateStatus(exception.getMessage(), true);
        }
        this.spools.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setFilter(int n, int n2) {
        switch (n2) {
            case 0: {
                this.filter.setSpoolName((String)this.spools.getModel().getValueAt(n, n2));
                break;
            }
            case 3: {
                this.filter.setUser((String)this.spools.getModel().getValueAt(n, n2));
                break;
            }
            case 6: {
                this.filter.setUserData((String)this.spools.getModel().getValueAt(n, n2));
                break;
            }
        }
        System.out.println((String)this.spools.getModel().getValueAt(n, n2));
    }

    private void updateStatus(final String string, boolean bl) {
        if (bl) {
            this.status.setForeground(Color.red);
        } else {
            this.status.setForeground(Color.black);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpoolExporter.this.status.setText(string);
            }
        });
    }

    private void updateStatus(String string) {
        this.updateStatus(string, false);
    }

    class SpoolTableModel
    extends DefaultSortTableModel
    implements PrintObjectListListener {
        private static final long serialVersionUID = 1L;
        String[] cols;
        int[] colsSizes;
        final String colLayout = "Spool Name|100|Spool Number|90|Job Name|100|Job User|100|Job Number|90|Queue|200|User Data|100|Status|100|Total Pages|90|Current Page|90|Copies|90|Form Type|100|Priority|40|Creation Date/Time|175|Size|120";

        public SpoolTableModel() {
            StringTokenizer stringTokenizer = new StringTokenizer("Spool Name|100|Spool Number|90|Job Name|100|Job User|100|Job Number|90|Queue|200|User Data|100|Status|100|Total Pages|90|Current Page|90|Copies|90|Form Type|100|Priority|40|Creation Date/Time|175|Size|120", "|");
            this.colsSizes = new int[stringTokenizer.countTokens() / 2];
            this.cols = new String[stringTokenizer.countTokens() / 2];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.cols[n] = stringTokenizer.nextToken();
                this.colsSizes[n++] = Integer.parseInt(stringTokenizer.nextToken());
            }
        }

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.cols[n];
        }

        public int getColumnPreferredSize(int n) {
            return this.colsSizes[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void listClosed(PrintObjectListEvent printObjectListEvent) {
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    SpoolTableModel.this.fireTableDataChanged();
                }
            });
        }

        public void listCompleted(PrintObjectListEvent printObjectListEvent) {
            SpoolExporter.this.setCursor(Cursor.getPredefinedCursor(0));
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    SpoolTableModel.this.fireTableDataChanged();
                }
            });
        }

        public void listErrorOccurred(PrintObjectListEvent printObjectListEvent) {
            System.err.println("list error occurred : " + printObjectListEvent.getException().getMessage());
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    SpoolTableModel.this.fireTableDataChanged();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listObjectAdded(PrintObjectListEvent printObjectListEvent) {
            boolean bl = SpoolExporter.this.filter.getSpoolName().length() > 0;
            String string = SpoolExporter.this.filter.getSpoolName();
            SpooledFile spooledFile = (SpooledFile)printObjectListEvent.getObject();
            Vector<String> vector = new Vector<String>();
            if (bl && !string.equals(spooledFile.getName())) {
                return;
            }
            vector.add(spooledFile.getName());
            SpoolExporter.this.loadIntegerAttribute(spooledFile, vector, 105);
            SpoolExporter.this.loadStringAttribute(spooledFile, vector, 59);
            SpoolExporter.this.loadStringAttribute(spooledFile, vector, 62);
            SpoolExporter.this.loadStringAttribute(spooledFile, vector, 60);
            SpoolExporter.this.loadStringAttribute(spooledFile, vector, -6);
            SpoolExporter.this.loadStringAttribute(spooledFile, vector, 116);
            SpoolExporter.this.loadStringAttribute(spooledFile, vector, 106);
            SpoolExporter.this.loadIntegerAttribute(spooledFile, vector, 111);
            SpoolExporter.this.loadIntegerAttribute(spooledFile, vector, 30);
            SpoolExporter.this.loadIntegerAttribute(spooledFile, vector, 28);
            SpoolExporter.this.loadStringAttribute(spooledFile, vector, 48);
            SpoolExporter.this.loadStringAttribute(spooledFile, vector, 72);
            SpoolExporter.this.loadCreateDateTime(spooledFile, vector);
            SpoolExporter.this.loadIntegerAttribute(spooledFile, vector, 125);
            Vector vector2 = SpoolExporter.this.data;
            synchronized (vector2) {
                SpoolExporter.this.data.add(vector);
            }
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    SpoolTableModel.this.fireTableDataChanged();
                    SpoolExporter.this.updateStatus(SpoolExporter.this.data.size() + " " + LangTool.getString("spool.count"));
                }
            });
        }

        public void listOpened(PrintObjectListEvent printObjectListEvent) {
            System.out.println("list opened");
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    SpoolTableModel.this.fireTableDataChanged();
                }
            });
        }
    }
}

