/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sql;

import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import org.tn5250j.event.FTPStatusEvent;
import org.tn5250j.event.FTPStatusListener;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class AS400Xtfr {
    private boolean loggedIn;
    private String hostName;
    private int timeout = 50000;
    private boolean connected;
    private ArrayList ffd;
    private tnvt vt;
    private Vector<FTPStatusListener> listeners;
    private FTPStatusEvent status;
    private boolean aborted;
    private char decChar;
    private OutputFilterInterface ofi;
    private Thread getThread;
    private String user;
    private String pass;
    private Connection connection;

    public AS400Xtfr(tnvt tnvt2) {
        this.vt = tnvt2;
        this.status = new FTPStatusEvent(this);
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.getDefault());
        this.decChar = decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public void setOutputFilter(OutputFilterInterface outputFilterInterface) {
        this.ofi = outputFilterInterface;
    }

    public void setDecimalChar(char c) {
        this.decChar = c;
    }

    public boolean connect(String string) {
        this.connection = null;
        this.hostName = string.toUpperCase();
        try {
            this.printFTPInfo("Connecting to " + this.hostName);
            Driver driver = (Driver)Class.forName("com.ibm.as400.access.AS400JDBCDriver").newInstance();
            DriverManager.registerDriver(driver);
            this.connection = DriverManager.getConnection("jdbc:as400://" + this.hostName + ";decimal separator=" + this.decChar + ";extended metadata=true;translate binary=true", this.user, this.pass);
            this.printFTPInfo("jdbc:as400://" + this.hostName + ";decimal separator=" + this.decChar + ";extended metadata=true;translate binary=true");
            this.fireInfoEvent();
            this.printFTPInfo("Connected to " + this.hostName);
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.printFTPInfo("Error: JDBC Driver not found.  Please check classpath.");
        }
        catch (Exception exception) {
            this.printFTPInfo("Error: " + exception.getMessage() + "\n\n" + "There was an error connecting to host " + string.toUpperCase() + "\n\nPlease make sure that you run " + "the command STRHOSTSVR");
            System.out.println("Exception while retrieving data : " + exception.getMessage());
        }
        return false;
    }

    public void disconnect() {
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void addFTPStatusListener(FTPStatusListener fTPStatusListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.addElement(fTPStatusListener);
    }

    private void fireStatusEvent() {
        if (this.listeners != null) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                FTPStatusListener fTPStatusListener = this.listeners.elementAt(i);
                fTPStatusListener.statusReceived(this.status);
            }
        }
    }

    private void fireCommandEvent() {
        if (this.listeners != null) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                FTPStatusListener fTPStatusListener = this.listeners.elementAt(i);
                fTPStatusListener.commandStatusReceived(this.status);
            }
        }
    }

    private void fireInfoEvent() {
        if (this.listeners != null) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                FTPStatusListener fTPStatusListener = this.listeners.elementAt(i);
                fTPStatusListener.fileInfoReceived(this.status);
            }
        }
    }

    public synchronized void removeFTPStatusListener(FTPStatusListener fTPStatusListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(fTPStatusListener);
    }

    public boolean login(String string, String string2) {
        this.aborted = false;
        this.loggedIn = true;
        this.user = string;
        this.pass = string2;
        return true;
    }

    public boolean isFieldSelected(int n) {
        FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(n);
        return fileFieldDef.isWriteField();
    }

    protected void selectAll() {
        for (int i = 0; i < this.ffd.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(i);
            fileFieldDef.setWriteField(true);
        }
    }

    protected void selectNone() {
        for (int i = 0; i < this.ffd.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(i);
            fileFieldDef.setWriteField(false);
        }
    }

    public boolean isFieldsSelected() {
        for (int i = 0; i < this.ffd.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(i);
            if (!fileFieldDef.isWriteField()) continue;
            return true;
        }
        return false;
    }

    public void setFieldSelected(int n, boolean bl) {
        FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(n);
        fileFieldDef.setWriteField(bl);
    }

    public String getFieldName(int n) {
        FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(n);
        return fileFieldDef.getFieldName();
    }

    public int getNumberOfFields() {
        return this.ffd.size();
    }

    public boolean getFile(String string, String string2, String string3, boolean bl) {
        boolean bl2 = true;
        if (this.connection == null) {
            this.printFTPInfo("Not connected to any server!");
            return false;
        }
        final String string4 = string2;
        final String string5 = string3;
        final boolean bl3 = bl;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object;
                    int n;
                    DatabaseMetaData databaseMetaData = AS400Xtfr.this.connection.getMetaData();
                    Statement statement = AS400Xtfr.this.connection.createStatement();
                    ResultSet resultSet = statement.executeQuery(string5);
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n2 = resultSetMetaData.getColumnCount();
                    ResultSet resultSet2 = databaseMetaData.getColumns(null, "VISIONR", "CXREF", null);
                    while (resultSet2.next()) {
                        System.out.println(resultSet2.getString(12));
                    }
                    if (AS400Xtfr.this.ffd != null) {
                        AS400Xtfr.this.ffd.clear();
                        AS400Xtfr.this.ffd = null;
                    }
                    AS400Xtfr.this.ffd = new ArrayList();
                    AS400Xtfr.this.printFTPInfo("Number of columns: " + resultSetMetaData.getColumnCount());
                    for (n = 1; n <= n2; ++n) {
                        AS400Xtfr.this.printFTPInfo("Column " + n + ": " + resultSetMetaData.getColumnLabel(n) + " " + resultSetMetaData.getColumnName(n) + " " + resultSetMetaData.getColumnType(n) + " " + resultSetMetaData.getColumnTypeName(n) + " " + resultSetMetaData.getPrecision(n) + " " + resultSetMetaData.getScale(n) + " cn " + resultSetMetaData.getCatalogName(n) + " tn " + resultSetMetaData.getTableName(n) + " sn " + resultSetMetaData.getSchemaName(n));
                        object = new FileFieldDef(AS400Xtfr.this.vt, AS400Xtfr.this.decChar);
                        if (bl3) {
                            ((FileFieldDef)object).setFieldName(resultSetMetaData.getColumnName(n));
                        } else {
                            ((FileFieldDef)object).setFieldName(resultSetMetaData.getColumnLabel(n));
                        }
                        ((FileFieldDef)object).setNeedsTranslation(false);
                        ((FileFieldDef)object).setStartOffset("0");
                        ((FileFieldDef)object).setFieldLength(Integer.toString(resultSetMetaData.getColumnDisplaySize(n)));
                        ((FileFieldDef)object).setNumDigits(Integer.toString(resultSetMetaData.getPrecision(n)));
                        ((FileFieldDef)object).setDecPositions(Integer.toString(resultSetMetaData.getScale(n)));
                        switch (resultSetMetaData.getColumnType(n)) {
                            case 2: {
                                ((FileFieldDef)object).setFieldType("S");
                                break;
                            }
                            case 3: {
                                ((FileFieldDef)object).setFieldType("P");
                                break;
                            }
                            default: {
                                ((FileFieldDef)object).setFieldType(" ");
                            }
                        }
                        ((FileFieldDef)object).setFieldText("");
                        ((FileFieldDef)object).setWriteField(true);
                        AS400Xtfr.this.ffd.add(object);
                    }
                    AS400Xtfr.this.writeHeader(string4);
                    n = 0;
                    object = new StringBuffer();
                    while (resultSet.next() && !AS400Xtfr.this.aborted) {
                        for (int i = 1; i <= n2; ++i) {
                            ((FileFieldDef)AS400Xtfr.this.ffd.get(i - 1)).setFieldData(resultSet.getString(i));
                        }
                        AS400Xtfr.this.status.setCurrentRecord(n++);
                        AS400Xtfr.this.status.setFileLength(n + 1);
                        ((StringBuffer)object).setLength(0);
                        AS400Xtfr.this.ofi.parseFields(null, AS400Xtfr.this.ffd, (StringBuffer)object);
                        AS400Xtfr.this.fireStatusEvent();
                    }
                    AS400Xtfr.this.printFTPInfo("Transfer Successful ");
                    AS400Xtfr.this.status.setCurrentRecord(n);
                    AS400Xtfr.this.status.setFileLength(n);
                    AS400Xtfr.this.fireStatusEvent();
                    AS400Xtfr.this.writeFooter();
                }
                catch (SQLException sQLException) {
                    AS400Xtfr.this.printFTPInfo("SQL Exception ! " + sQLException.getMessage());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    AS400Xtfr.this.printFTPInfo("File Not found Exception ! " + fileNotFoundException.getMessage());
                }
                finally {
                    try {
                        if (AS400Xtfr.this.connection != null) {
                            AS400Xtfr.this.connection.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    if (AS400Xtfr.this.ffd != null) {
                        AS400Xtfr.this.ffd.clear();
                        AS400Xtfr.this.ffd = null;
                    }
                    System.gc();
                }
            }
        };
        this.getThread = new Thread(runnable);
        this.getThread.start();
        return bl2;
    }

    private void printFTPInfo(String string) {
        this.status.setMessage(string);
        this.fireCommandEvent();
    }

    private void writeHeader(String string) throws FileNotFoundException {
        this.ofi.createFileInstance(string);
        this.ofi.writeHeader(string, this.hostName, this.ffd, this.decChar);
    }

    private void writeFooter() {
        this.ofi.writeFooter(this.ffd);
    }
}

