/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sql;

import com.ibm.as400.access.AS400;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.SQLQueryBuilderPane;
import com.ibm.as400.vaccess.SQLResultSetTablePane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Driver;
import java.sql.DriverManager;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.system.OperatingSystem;

public class SqlWizard
extends JFrame {
    private static final long serialVersionUID = 1L;
    private SQLConnection connection;
    private AS400 system;
    private SQLQueryBuilderPane queryBuilder;
    private SQLResultSetTablePane tablePane;
    private String name;
    private String password;
    private String host;
    private String queryText;
    private JTextArea queryTextArea;

    public SqlWizard(String string, String string2, String string3) {
        this.host = string;
        this.name = string2;
        this.password = string3;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        try {
            this.setIconImages(GUIGraphicsUtils.getApplicationIcons());
            this.setTitle(LangTool.getString("xtfr.wizardTitle"));
            Driver driver = (Driver)Class.forName("com.ibm.as400.access.AS400JDBCDriver").newInstance();
            DriverManager.registerDriver(driver);
            this.connection = new SQLConnection("jdbc:as400://" + this.host, this.name, this.password);
            this.queryBuilder = new SQLQueryBuilderPane(this.connection);
            this.queryBuilder.setTableSchemas(new String[]{"*USRLIBL"});
            this.queryBuilder.load();
            JButton jButton = new JButton(LangTool.getString("xtfr.tableDone"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SqlWizard.this.fillQueryTextArea();
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(jButton);
            this.getContentPane().add((Component)this.queryBuilder, "Center");
            this.getContentPane().add((Component)jPanel, "South");
            Dimension dimension = new Dimension(OperatingSystem.getScreenBounds().width, OperatingSystem.getScreenBounds().height);
            this.pack();
            if (this.getSize().width > dimension.width) {
                this.setSize(dimension.width, this.getSize().height);
            }
            if (this.getSize().height > dimension.height) {
                this.setSize(this.getSize().width, dimension.height);
            }
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension3 = this.getSize();
            if (dimension3.height > dimension2.height) {
                dimension3.height = dimension2.height;
            }
            if (dimension3.width > dimension2.width) {
                dimension3.width = dimension2.width;
            }
            this.setLocation((dimension2.width - dimension3.width) / 2, (dimension2.height - dimension3.height) / 2);
            this.setVisible(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "Error loading AS400 JDBC Driver", "Error", 0);
        }
    }

    private void fillQueryTextArea() {
        this.queryTextArea.append(this.queryBuilder.getQuery());
        this.setVisible(false);
        this.dispose();
    }

    public void setQueryTextArea(JTextArea jTextArea) {
        this.queryTextArea = jTextArea;
    }
}

