/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class ENHGridLayout
extends GridLayout {
    private static final long serialVersionUID = 1L;
    protected int hgap;
    protected int vgap;
    protected int rows;
    protected int cols;
    protected int[] row_heights = new int[0];
    protected int[] col_widths = new int[0];
    public static final int VARIABLE = 0;

    public ENHGridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public ENHGridLayout(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
    }

    protected void getGridSizes(Container container, boolean bl) {
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        int n2 = this.rows;
        int n3 = this.cols;
        if (n2 > 0) {
            n3 = (n + n2 - 1) / n2;
        } else {
            n2 = (n + n3 - 1) / n3;
        }
        this.row_heights = new int[n2];
        this.col_widths = new int[n3];
        for (int i = 0; i < n; ++i) {
            int n4;
            Component component = container.getComponent(i);
            Dimension dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
            int n5 = i / n3;
            if (dimension.height > this.row_heights[n5]) {
                this.row_heights[n5] = dimension.height;
            }
            if (dimension.width <= this.col_widths[n4 = i % n3]) continue;
            this.col_widths[n4] = dimension.width;
        }
    }

    final int sum(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getGridSizes(container, false);
        return new Dimension(insets.left + insets.right + this.sum(this.col_widths) + (this.col_widths.length + 1) * this.hgap, insets.top + insets.bottom + this.sum(this.row_heights) + (this.row_heights.length + 1) * this.vgap);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getGridSizes(container, true);
        return new Dimension(insets.left + insets.right + this.sum(this.col_widths) + (this.col_widths.length + 1) * this.hgap, insets.top + insets.bottom + this.sum(this.row_heights) + (this.row_heights.length + 1) * this.vgap);
    }

    protected void setBounds(int n, int n2, int n3, Component component, int n4, int n5, int n6, int n7) {
        component.setBounds(n4, n5, n6, n7);
    }

    @Override
    public void layoutContainer(Container container) {
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        Insets insets = container.getInsets();
        this.getGridSizes(container, false);
        int n2 = this.rows;
        int n3 = this.cols;
        if (n2 > 0) {
            n3 = (n + n2 - 1) / n2;
        } else {
            n2 = (n + n3 - 1) / n3;
        }
        Dimension dimension = container.getSize();
        int n4 = insets.left + this.hgap;
        for (int i = 0; i < n3; ++i) {
            int n5 = insets.top + this.vgap;
            for (int j = 0; j < n2; ++j) {
                int n6 = j * n3 + i;
                if (n6 < n) {
                    int n7 = Math.max(0, Math.min(this.col_widths[i], dimension.width - insets.right - n4));
                    int n8 = Math.max(0, Math.min(this.row_heights[j], dimension.height - insets.bottom - n5));
                    this.setBounds(n6, j, i, container.getComponent(n6), n4, n5, n7, n8);
                }
                n5 += this.row_heights[j] + this.vgap;
            }
            n4 += this.col_widths[i] + this.hgap;
        }
    }
}

