/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.tn5250j.event.FTPStatusEvent;
import org.tn5250j.event.FTPStatusListener;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.tools.As400Util;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class FTP5250Prot {
    private Socket ftpConnectionSocket;
    private BufferedReader ftpInputStream;
    private PrintStream ftpOutputStream;
    private InetAddress localHost;
    private boolean loggedIn;
    private String lastResponse;
    private int lastIntResponse;
    private String hostName;
    private int timeout = 50000;
    private boolean connected;
    private String remoteDir;
    private ArrayList ffd;
    private tnvt vt;
    private int recordLength;
    private int recordOutLength;
    private int fileSize;
    private Vector<FTPStatusListener> listeners;
    private FTPStatusEvent status;
    private boolean aborted;
    private char decChar;
    private OutputFilterInterface ofi;
    private Vector members;
    private Thread getThread;

    public FTP5250Prot(tnvt tnvt2) {
        this.vt = tnvt2;
        this.status = new FTPStatusEvent(this);
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.getDefault());
        this.decChar = decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public void setOutputFilter(OutputFilterInterface outputFilterInterface) {
        this.ofi = outputFilterInterface;
    }

    public void setDecimalChar(char c) {
        this.decChar = c;
    }

    public boolean connect(String string, int n) {
        try {
            this.hostName = string;
            this.ftpConnectionSocket = new Socket(string, n);
            this.ftpConnectionSocket.setSoTimeout(this.timeout);
            this.localHost = this.ftpConnectionSocket.getLocalAddress();
            this.ftpInputStream = new BufferedReader(new InputStreamReader(this.ftpConnectionSocket.getInputStream()));
            this.ftpOutputStream = new PrintStream(this.ftpConnectionSocket.getOutputStream());
            this.parseResponse();
            this.fileSize = 0;
            if (this.lastIntResponse == 220) {
                this.connected = true;
                return true;
            }
            this.connected = false;
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void disconnect() {
        try {
            if (this.isConnected()) {
                this.executeCommand("QUIT");
                this.ftpOutputStream.close();
                this.ftpInputStream.close();
                this.ftpConnectionSocket.close();
                this.connected = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void addFTPStatusListener(FTPStatusListener fTPStatusListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.addElement(fTPStatusListener);
    }

    private void fireStatusEvent() {
        if (this.listeners != null) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                FTPStatusListener fTPStatusListener = this.listeners.elementAt(i);
                fTPStatusListener.statusReceived(this.status);
            }
        }
    }

    private void fireCommandEvent() {
        if (this.listeners != null) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                FTPStatusListener fTPStatusListener = this.listeners.elementAt(i);
                fTPStatusListener.commandStatusReceived(this.status);
            }
        }
    }

    private void fireInfoEvent() {
        if (this.listeners != null) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                FTPStatusListener fTPStatusListener = this.listeners.elementAt(i);
                fTPStatusListener.fileInfoReceived(this.status);
            }
        }
    }

    public synchronized void removeFTPStatusListener(FTPStatusListener fTPStatusListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(fTPStatusListener);
    }

    public boolean login(String string, String string2) {
        if (this.ftpOutputStream == null) {
            this.printFTPInfo("Not connected to any server!");
            return false;
        }
        this.aborted = false;
        this.loggedIn = true;
        this.executeCommand("USER", string);
        int n = this.executeCommand("PASS", string2);
        if (n != 230) {
            this.loggedIn = false;
            return false;
        }
        this.loggedIn = true;
        if (!this.isConnectedToOS400()) {
            this.printFTPInfo("Remote server is not an OS/400.  Disconnecting!");
            this.disconnect();
        }
        this.getRemoteDirectory();
        return true;
    }

    protected void printDirListing() {
        try {
            String string;
            Socket socket = this.createPassiveSocket("NLST");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                System.out.println(string);
            }
            socket.close();
            this.parseResponse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isConnectedToOS400() {
        this.executeCommand("SYST");
        return this.lastResponse.toUpperCase().indexOf("OS/400") >= 0;
    }

    public boolean isFieldSelected(int n) {
        FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(n);
        return fileFieldDef.isWriteField();
    }

    protected void selectAll() {
        for (int i = 0; i < this.ffd.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(i);
            fileFieldDef.setWriteField(true);
        }
    }

    protected void selectNone() {
        for (int i = 0; i < this.ffd.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(i);
            fileFieldDef.setWriteField(false);
        }
    }

    public boolean isFieldsSelected() {
        for (int i = 0; i < this.ffd.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(i);
            if (!fileFieldDef.isWriteField()) continue;
            return true;
        }
        return false;
    }

    public void setFieldSelected(int n, boolean bl) {
        FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(n);
        fileFieldDef.setWriteField(bl);
    }

    public String getFieldName(int n) {
        FileFieldDef fileFieldDef = (FileFieldDef)this.ffd.get(n);
        return fileFieldDef.getFieldName();
    }

    public int getNumberOfFields() {
        return this.ffd.size();
    }

    private void getRemoteDirectory() {
        this.executeCommand("PWD");
        int n = this.lastResponse.indexOf("\"");
        int n2 = this.lastResponse.lastIndexOf("\"");
        this.remoteDir = n != -1 && n2 != -1 ? this.lastResponse.substring(n + 1, n2) : "Can't parse remote dir!";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket createPassiveSocket(String string) {
        ServerSocket serverSocket = null;
        try {
            byte[] byArray = this.localHost.getAddress();
            serverSocket = new ServerSocket(0);
            serverSocket.setSoTimeout(this.timeout);
            StringBuffer stringBuffer = new StringBuffer("PORT ");
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(byArray[i] & 0xFF);
                stringBuffer.append(",");
            }
            stringBuffer.append(serverSocket.getLocalPort() >>> 8 & 0xFF);
            stringBuffer.append(",");
            stringBuffer.append(serverSocket.getLocalPort() & 0xFF);
            this.executeCommand(stringBuffer.toString());
            this.executeCommand(string);
            if (this.lastResponse.startsWith("5") || this.lastResponse.startsWith("4")) {
                Socket socket = null;
                return socket;
            }
            Socket socket = serverSocket.accept();
            socket.setSoTimeout(this.timeout);
            Socket socket2 = socket;
            return socket2;
        }
        catch (IOException iOException) {
            this.printFTPInfo("I/O error while setting up a ServerSocket on the client machine!" + iOException);
            Socket socket = null;
            return socket;
        }
        finally {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                this.printFTPInfo("createPassiveSocket.close() exception!" + iOException);
            }
        }
    }

    protected boolean getFileInfo(String string, boolean bl) {
        int n = string.indexOf(".");
        String string2 = null;
        String string3 = null;
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string2 = string;
        }
        final String string4 = string2;
        final String string5 = string3;
        final boolean bl2 = bl;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FTP5250Prot.this.executeCommand("RCMD", "dspffd FILE(" + string4 + ") OUTPUT(*OUTFILE) " + "OUTFILE(QTEMP/FFD) ");
                if (FTP5250Prot.this.lastResponse.startsWith("2") && FTP5250Prot.this.loadFFD(bl2) && FTP5250Prot.this.lastResponse.startsWith("2") && FTP5250Prot.this.getMbrInfo(string4, string5)) {
                    FTP5250Prot.this.fireInfoEvent();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFFD(boolean bl) {
        Object object;
        Socket socket = null;
        BufferedReader bufferedReader = null;
        String string = "QTEMP/FFD";
        String string2 = "";
        Vector<String> vector = null;
        try {
            Object object2;
            Object object3;
            String string3;
            socket = this.createPassiveSocket("RETR " + string);
            if (socket == null) {
                boolean bl2 = false;
                return bl2;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            if (this.ffd != null) {
                this.ffd.clear();
                this.ffd = null;
            }
            this.ffd = new ArrayList();
            while ((string3 = bufferedReader.readLine()) != null) {
                object3 = new FileFieldDef(this.vt, this.decChar);
                if (bl) {
                    ((FileFieldDef)object3).setFieldName(string3.substring(129, 139));
                } else {
                    object2 = "";
                    object2 = string3.substring(261, 281).trim() + " " + string3.substring(281, 301).trim() + " " + string3.substring(301, 321).trim();
                    if (((String)object2).length() > 0) {
                        ((FileFieldDef)object3).setFieldName((String)object2);
                    } else {
                        ((FileFieldDef)object3).setFieldName(string3.substring(168, 218).trim());
                        if (((FileFieldDef)object3).getFieldName().trim().length() == 0) {
                            ((FileFieldDef)object3).setFieldName(string3.substring(129, 139));
                        }
                    }
                }
                ((FileFieldDef)object3).setStartOffset(string3.substring(149, 154));
                ((FileFieldDef)object3).setFieldLength(string3.substring(159, 164));
                ((FileFieldDef)object3).setNumDigits(string3.substring(164, 166));
                ((FileFieldDef)object3).setDecPositions(string3.substring(166, 168));
                ((FileFieldDef)object3).setFieldType(string3.substring(321, 322));
                ((FileFieldDef)object3).setFieldText(string3.substring(168, 218));
                if (string3.substring(503, 504).equals("Y")) {
                    if (vector == null) {
                        vector = new Vector<String>(3);
                    }
                    vector.add(((FileFieldDef)object3).getFieldName());
                    this.printFTPInfo("Warning -- File allows null fields!!!");
                }
                ((FileFieldDef)object3).setWriteField(true);
                string2 = string3.substring(124, 129);
                this.ffd.add(object3);
            }
            this.printFTPInfo("Field Information Transfer complete!");
            if (vector != null) {
                object3 = new JPanel();
                ((Container)object3).setLayout(new BorderLayout());
                object2 = new JLabel(LangTool.getString("messages.nullFieldWarning"));
                object = new JTextArea(6, 30);
                ((JTextComponent)object).setEditable(false);
                JScrollPane jScrollPane = new JScrollPane((Component)object);
                String string4 = new String();
                for (int i = 0; i < vector.size(); ++i) {
                    string4 = string4 + vector.get(i) + "\n";
                }
                ((JTextComponent)object).setText(string4);
                ((Container)object3).add((Component)object2, "North");
                ((Container)object3).add((Component)jScrollPane, "Center");
                JOptionPane.showMessageDialog(null, object3, "Warning", 2);
            }
        }
        catch (Exception exception) {
            this.printFTPInfo("I/O error!");
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        int n = 0;
        int n2 = 0;
        int n3 = Integer.parseInt(string2);
        this.printFTPInfo("<----------------- File Field Information ---------------->");
        for (int i = 0; i < this.ffd.size(); ++i) {
            object = (FileFieldDef)this.ffd.get(i);
            n += ((FileFieldDef)object).getFieldLength();
            n2 += ((FileFieldDef)object).getBufferOutLength();
            this.printFTPInfo(((FileFieldDef)object).toString());
        }
        this.recordLength = n;
        this.recordOutLength = n2;
        System.out.println(n3 + " " + n + " " + n2);
        this.parseResponse();
        return true;
    }

    protected boolean getMbrInfo(String string, String string2) {
        this.executeCommand("RCMD", "dspfd FILE(" + string + ")" + " TYPE(*MBR)" + " OUTPUT(*OUTFILE) " + "OUTFILE(QTEMP/FML) ");
        if (!this.lastResponse.startsWith("2")) {
            return false;
        }
        return !this.getMbrSize(string2) || this.lastResponse.startsWith("2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getMbrSize(String string) {
        boolean bl = true;
        if (this.ftpOutputStream == null) {
            this.printFTPInfo("Not connected to any server!");
            return false;
        }
        if (!this.loggedIn) {
            this.printFTPInfo("Login was not successful! Aborting!");
            return false;
        }
        Socket socket = null;
        FilterInputStream filterInputStream = null;
        this.executeCommand("TYPE", "I");
        String string2 = "QTEMP/FML";
        this.members = new Vector(10);
        try {
            socket = this.createPassiveSocket("RETR " + string2);
            if (socket != null) {
                filterInputStream = new DataInputStream(socket.getInputStream());
                byte[] byArray = new byte[858];
                int n = 0;
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer(10);
                this.printFTPInfo("<----------------- Member Information ---------------->");
                int n3 = 0;
                while (n3 != -1 && !this.aborted && (n3 = filterInputStream.read()) != -1) {
                    ++n;
                    byArray[n2++] = (byte)n3;
                    if (n2 != byArray.length) continue;
                    stringBuffer.setLength(0);
                    for (int i = 0; i < 10; ++i) {
                        stringBuffer.append(this.vt.getCodePage().ebcdic2uni(byArray[163 + i] & 0xFF));
                    }
                    this.printFTPInfo(stringBuffer + " " + As400Util.packed2int(byArray, 345, 5));
                    this.members.add(new MemberInfo(stringBuffer.toString(), As400Util.packed2int(byArray, 345, 5)));
                    n2 = 0;
                }
                this.printFTPInfo("Member list Transfer complete!");
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            this.printFTPInfo("Error! " + exception);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        this.parseResponse();
        return bl;
    }

    public String getFullFileName(String string) {
        int n = string.indexOf(".");
        String string2 = null;
        String string3 = null;
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string2 = string;
        }
        if (this.members != null) {
            if (string3 == null) {
                MemberInfo memberInfo = (MemberInfo)this.members.get(0);
                this.fileSize = memberInfo.getSize();
                this.status.setFileLength(memberInfo.getSize());
                string3 = memberInfo.getName();
            } else {
                Iterator iterator = this.members.iterator();
                MemberInfo memberInfo = null;
                while (iterator.hasNext()) {
                    memberInfo = (MemberInfo)iterator.next();
                    if (!memberInfo.getName().trim().equalsIgnoreCase(string3.trim())) continue;
                    this.fileSize = memberInfo.getSize();
                    this.status.setFileLength(memberInfo.getSize());
                    break;
                }
            }
        }
        if (string3 != null) {
            return string2.trim() + "." + string3.trim();
        }
        return string2.trim();
    }

    public int getFileSize() {
        return this.fileSize;
    }

    protected boolean printHelp() {
        this.executeCommand("HELP");
        return true;
    }

    protected boolean getFile(String string, String string2) {
        boolean bl = true;
        if (this.ftpOutputStream == null) {
            this.printFTPInfo("Not connected to any server!");
            return false;
        }
        if (!this.loggedIn) {
            this.printFTPInfo("Login was not successful! Aborting!");
            return false;
        }
        final String string3 = string2;
        final String string4 = string;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Socket socket = null;
                FilterInputStream filterInputStream = null;
                String string = string3;
                FTP5250Prot.this.executeCommand("TYPE", "I");
                try {
                    socket = FTP5250Prot.this.createPassiveSocket("RETR " + string4);
                    if (socket != null) {
                        filterInputStream = new DataInputStream(socket.getInputStream());
                        FTP5250Prot.this.writeHeader(string);
                        byte[] byArray = new byte[FTP5250Prot.this.recordLength];
                        StringBuffer stringBuffer = new StringBuffer(FTP5250Prot.this.recordOutLength);
                        int n = 0;
                        int n2 = 0;
                        int n3 = 0;
                        while (n3 != -1 && !FTP5250Prot.this.aborted && (n3 = filterInputStream.read()) != -1) {
                            ++n;
                            byArray[n2++] = (byte)n3;
                            if (n2 == FTP5250Prot.this.recordLength) {
                                stringBuffer.setLength(0);
                                FTP5250Prot.this.parseFFD(byArray, stringBuffer);
                                n2 = 0;
                                FTP5250Prot.this.status.setCurrentRecord(n / FTP5250Prot.this.recordLength);
                                FTP5250Prot.this.fireStatusEvent();
                            }
                            Thread.yield();
                        }
                        System.out.println(n);
                        if (n == 0) {
                            FTP5250Prot.this.status.setCurrentRecord(n);
                            FTP5250Prot.this.fireStatusEvent();
                        } else if (!FTP5250Prot.this.aborted) {
                            FTP5250Prot.this.parseResponse();
                        }
                        FTP5250Prot.this.writeFooter();
                        FTP5250Prot.this.printFTPInfo("Transfer complete!");
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    FTP5250Prot.this.printFTPInfo("Interrupted! " + interruptedIOException.getMessage());
                }
                catch (Exception exception) {
                    FTP5250Prot.this.printFTPInfo("Error! " + exception);
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                    try {
                        filterInputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        FTP5250Prot.this.writeFooter();
                    }
                    catch (Exception exception) {}
                    FTP5250Prot.this.disconnect();
                }
            }
        };
        this.getThread = new Thread(runnable);
        this.getThread.setPriority(2);
        this.getThread.start();
        return bl;
    }

    private void parseFFD(byte[] byArray, StringBuffer stringBuffer) {
        this.ofi.parseFields(byArray, this.ffd, stringBuffer);
    }

    public void setAborted() {
        this.aborted = true;
    }

    private void printFTPInfo(String string) {
        this.status.setMessage(string);
        this.fireCommandEvent();
    }

    private int executeCommand(String string) {
        return this.executeCommand(string, null);
    }

    private int executeCommand(String string, String string2) {
        if (this.ftpOutputStream == null) {
            this.printFTPInfo("Not connected to any server!");
            return 0;
        }
        if (!this.loggedIn) {
            this.printFTPInfo("Login was not successful! Aborting!");
            return 0;
        }
        if (string2 != null) {
            this.ftpOutputStream.print(string + " " + string2 + "\r\n");
        } else {
            this.ftpOutputStream.print(string + "\r\n");
        }
        if (!string.equals("PASS")) {
            this.printFTPInfo("SENT: " + string + " " + (string2 != null ? string2 : ""));
        } else {
            this.printFTPInfo("SENT: PASS ****************");
        }
        this.parseResponse();
        return this.lastIntResponse;
    }

    private String parseResponse() {
        try {
            String string;
            if (this.ftpInputStream == null) {
                return "0000 Response Invalid";
            }
            String string2 = string = this.ftpInputStream.readLine();
            boolean bl = true;
            while (!(string2 != null && string2.length() >= 4 && Character.isDigit(string2.charAt(0)) && Character.isDigit(string2.charAt(1)) && Character.isDigit(string2.charAt(2)) && string2.charAt(3) == ' ')) {
                if (bl) {
                    string = string + "\n";
                    bl = false;
                }
                string2 = this.ftpInputStream.readLine();
                string = string + string2 + "\n";
            }
            this.lastIntResponse = Integer.parseInt(string.substring(0, 3));
            this.lastResponse = string;
            this.printFTPInfo(this.lastResponse);
            return this.lastResponse;
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            return "0000 Response Invalid";
        }
    }

    private void writeHeader(String string) throws FileNotFoundException {
        this.ofi.createFileInstance(string);
        this.ofi.writeHeader(string, this.hostName, this.ffd, this.decChar);
    }

    private void writeFooter() {
        this.ofi.writeFooter(this.ffd);
    }

    class MemberInfo {
        private String name;
        private int size;

        MemberInfo(String string, int n) {
            this.name = string;
            this.size = n;
        }

        public String getName() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }
    }
}

