/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class FixedCenterLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int hgap;
    protected Component west;
    protected Component east;
    protected Component center;

    public FixedCenterLayout() {
        this(0);
    }

    public FixedCenterLayout(int n) {
        this.hgap = n;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object != null && !(object instanceof String)) {
                throw new IllegalArgumentException("Cannot add to layout: constraint must be a string or null");
            }
            this.addLayoutComponent((String)object, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String string, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (string == null || "Center".equals(string)) {
                this.center = component;
            } else if ("East".equals(string)) {
                this.east = component;
            } else if ("West".equals(string)) {
                this.west = component;
            } else {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component == this.center) {
                this.center = null;
            } else if (component == this.east) {
                this.east = null;
            } else if (component == this.west) {
                this.west = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            this.addMinimumSize(dimension, this.east);
            this.addMinimumSize(dimension, this.west);
            this.addMinimumSize(dimension, this.center);
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            this.addPreferredSize(dimension, this.east);
            this.addPreferredSize(dimension, this.west);
            this.addPreferredSize(dimension, this.center);
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Insets insets = container.getInsets();
            int n2 = insets.top;
            int n3 = container.getBounds().height - insets.bottom;
            int n4 = insets.left;
            int n5 = container.getBounds().width - insets.right;
            int n6 = n = (n5 - n4) / 2;
            if (this.center != null) {
                Dimension dimension = this.center.getPreferredSize();
                n = (n5 - n4 - dimension.width) / 2;
                n6 = n + dimension.width;
                this.center.setBounds(n, n2, dimension.width, n3 - n2);
            }
            if (this.west != null) {
                this.west.setBounds(n4, n2, n - n4 - this.hgap, n3 - n2);
            }
            if (this.east != null) {
                this.east.setBounds(n6 + this.hgap, n2, n5 - n6 - 2 * this.hgap, n3 - n2);
            }
        }
    }

    private void addMinimumSize(Dimension dimension, Component component) {
        if (component != null) {
            this.addSize(dimension, component.getMinimumSize());
        }
    }

    private void addPreferredSize(Dimension dimension, Component component) {
        if (component != null) {
            this.addSize(dimension, component.getPreferredSize());
        }
    }

    private void addSize(Dimension dimension, Dimension dimension2) {
        dimension.width += dimension2.width + this.hgap;
        dimension.height = Math.max(dimension2.height, dimension.height);
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + "]";
    }
}

