/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tn5250j.tools.system.OperatingSystem;

public class GUIGraphicsUtils {
    private static final Insets GROOVE_INSETS = new Insets(2, 2, 2, 2);
    private static final Insets ETCHED_INSETS = new Insets(2, 2, 2, 2);
    public static final int RAISED = 1;
    public static final int INSET = 2;
    public static final int WINDOW_NORMAL = 3;
    public static final int WINDOW_GRAPHIC = 4;
    private static String defaultFont;
    private static ImageIcon lockImgOpen;
    private static ImageIcon lockImgClose;
    private static List<Image> tnicon;
    static final String[] windowsFonts;
    static final String[] nixFonts;
    static final String[] macFonts;

    public static void draw3DLeft(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        if (n == 1) {
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2 + n4, n3);
            graphics.drawLine(n2, n3 + 1, n2 + n4, n3 + 1);
            graphics.drawLine(n2, n3, n2, n3 + n5 - 2);
            graphics.drawLine(n2 + 1, n3, n2 + 1, n3 + n5 - 2);
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3 + n5 - 2, n2 + n4, n3 + n5 - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n2 + 1, n3 + n5 - 3, n2 + n4, n3 + n5 - 3);
        }
        if (n == 2) {
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3, n2 + n4, n3);
            graphics.drawLine(n2, n3 + 1, n2 + n4, n3 + 1);
            graphics.drawLine(n2, n3, n2, n3 + n5 - 2);
            graphics.drawLine(n2 + 1, n3, n2 + 1, n3 + n5 - 2);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3 + n5 - 2, n2 + n4, n3 + n5 - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n2 + 1, n3 + n5 - 3, n2 + n4, n3 + n5 - 3);
        }
        graphics.setColor(color);
    }

    public static void draw3DMiddle(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        if (n == 1) {
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2 + n4, n3);
            graphics.drawLine(n2, n3 + 1, n2 + n4, n3 + 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3 + n5 - 2, n2 + n4, n3 + n5 - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n2, n3 + n5 - 3, n2 + n4, n3 + n5 - 3);
        }
        if (n == 2) {
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3, n2 + n4, n3);
            graphics.drawLine(n2, n3 + 1, n2 + n4, n3 + 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3 + n5 - 2, n2 + n4, n3 + n5 - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n2, n3 + n5 - 3, n2 + n4, n3 + n5 - 3);
        }
        graphics.setColor(color);
    }

    public static void draw3DRight(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        if (n == 1) {
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2 + n4 - 2, n3);
            graphics.drawLine(n2, n3 + 1, n2 + n4 - 3, n3 + 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3 + n5 - 2, n2 + n4 - 2, n3 + n5 - 2);
            graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n2 + n4 - 2, n3 + 1, n2 + n4 - 2, n3 + n5 - 3);
            graphics.drawLine(n2, n3 + n5 - 3, n2 + n4 - 2, n3 + n5 - 3);
        }
        if (n == 2) {
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3, n2 + n4 - 2, n3);
            graphics.drawLine(n2, n3 + 1, n2 + n4 - 3, n3 + 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3 + n5 - 2, n2 + n4 - 2, n3 + n5 - 2);
            graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n2 + n4 - 2, n3 + 1, n2 + n4 - 2, n3 + n5 - 3);
            graphics.drawLine(n2, n3 + n5 - 3, n2 + n4 - 2, n3 + n5 - 3);
        }
        graphics.setColor(color);
    }

    public static void draw3DOne(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        if (n == 2) {
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3, n2 + n4 - 2, n3);
            graphics.drawLine(n2, n3 + 1, n2 + n4 - 3, n3 + 1);
            graphics.drawLine(n2, n3, n2, n3 + n5 - 2);
            graphics.drawLine(n2 + 1, n3, n2 + 1, n3 + n5 - 2);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3 + n5 - 2, n2 + n4 - 2, n3 + n5 - 2);
            graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n2 + n4 - 2, n3 + 1, n2 + n4 - 2, n3 + n5 - 3);
            graphics.drawLine(n2 + 1, n3 + n5 - 3, n2 + n4 - 2, n3 + n5 - 3);
        }
        if (n == 1) {
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2 + n4 - 2, n3);
            graphics.drawLine(n2, n3 + 1, n2 + n4 - 3, n3 + 1);
            graphics.drawLine(n2, n3, n2, n3 + n5 - 2);
            graphics.drawLine(n2 + 1, n3, n2 + 1, n3 + n5 - 2);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(n2, n3 + n5 - 2, n2 + n4 - 2, n3 + n5 - 2);
            graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n2 + n4 - 2, n3 + 1, n2 + n4 - 2, n3 + n5 - 3);
            graphics.drawLine(n2 + 1, n3 + n5 - 3, n2 + n4 - 2, n3 + n5 - 3);
        }
        graphics.setColor(color);
    }

    public static void drawScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2) {
        Color color3 = graphics.getColor();
        if (n == 2) {
            graphics.setColor(color2);
            graphics.fillRect(n3, n4, n5, n6);
            graphics.setColor(color);
            graphics.drawLine(n3, n4, n3, n4 + n6);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6);
        }
        if (n == 1) {
            graphics.setColor(color2);
            graphics.fillRect(n3, n4, n5, n6);
            graphics.setColor(color);
            graphics.drawLine(n3, n4, n3, n4 + n6);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6);
        }
        if (n2 == 1) {
            graphics.setColor(color.brighter());
            graphics.drawLine(n3 + n5 / 2, n4 + 2, n3 + 2, n4 + n6 - 4);
            graphics.setColor(color.darker());
            graphics.drawLine(n3 + n5 / 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 4);
            graphics.drawLine(n3 + 2, n4 + n6 - 4, n3 + n5 - 2, n4 + n6 - 4);
            graphics.setColor(color);
            graphics.drawLine(n3, n4, n3 + n5 - 1, n4);
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        }
        if (n2 == 2) {
            graphics.setColor(color.brighter());
            graphics.drawLine(n3 + n5 / 2, n4 + n6 - 4, n3 + 2, n4 + 2);
            graphics.drawLine(n3 + 2, n4 + 2, n3 + n5 - 2, n4 + 2);
            graphics.setColor(color.darker());
            graphics.drawLine(n3 + n5 / 2, n4 + n6 - 4, n3 + n5 - 2, n4 + 2);
            graphics.setColor(color);
            graphics.drawLine(n3, n4, n3 + n5, n4);
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5, n4 + n6 - 1);
        }
        if (n2 == 3) {
            graphics.setColor(color);
            graphics.fillRect(n3 + 2, n4, n5 - 4, n6);
        }
        graphics.setColor(color3);
    }

    public static void drawWinUpperLeft(Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        if (n == 4) {
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2 + n4, n3);
            graphics.drawLine(n2, n3, n2, n3 + n5);
        }
        if (n == 3) {
            graphics.drawLine(n2 + n4 / 2, n3 + n5 / 2, n2 + n4, n3 + n5 / 2);
            graphics.drawLine(n2 + n4 / 2, n3 + n5 / 2, n2 + n4 / 2, n3 + n5);
        }
        graphics.setColor(color2);
    }

    public static void drawWinUpper(Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        if (n == 4) {
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2 + n4, n3);
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3 + n5 - 1, n2 + n4, n3 + n5 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3 + n5, n2 + n4, n3 + n5);
        }
        if (n == 3) {
            graphics.drawLine(n2, n3 + n5 / 2, n2 + n4, n3 + n5 / 2);
        }
        graphics.setColor(color2);
    }

    public static void drawWinUpperRight(Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        if (n == 4) {
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2 + n4, n3);
            graphics.setColor(Color.black);
            graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
        }
        if (n == 3) {
            graphics.drawLine(n2 + n4 / 2, n3 + n5 / 2, n2 + n4 / 2, n3 + n5);
            graphics.drawLine(n2, n3 + n5 / 2, n2 + n4 / 2, n3 + n5 / 2);
            graphics.setColor(color.darker());
            int n6 = 0;
            while (n6 < 3) {
                graphics.fillRect(n2 + n4 / 2 + (3 + n6), n3 + ++n6 + n5 / 2, 1, n5 / 2);
            }
        }
        graphics.setColor(color2);
    }

    public static void drawWinLeft(Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        if (n == 4) {
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2, n3 + n5);
            graphics.setColor(Color.black);
            graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5);
            graphics.setColor(Color.white);
            graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
        }
        if (n == 3) {
            graphics.drawLine(n2 + n4 / 2, n3, n2 + n4 / 2, n3 + n5);
        }
        graphics.setColor(color2);
    }

    public static void drawWinRight(Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        if (n == 4) {
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(Color.black);
            graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2, n3 + n5);
            graphics.setColor(Color.black);
            graphics.drawLine(n2 + 1, n3, n2 + 1, n3 + n5);
        }
        if (n == 3) {
            graphics.drawLine(n2 + n4 / 2, n3, n2 + n4 / 2, n3 + n5);
            graphics.setColor(color.darker());
            graphics.fillRect(n2 + n4 / 2 + 3, n3, 3, n5);
        }
        graphics.setColor(color2);
    }

    public static void drawWinLowerLeft(Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        if (n == 4) {
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3 + n5 - 1, n2 + n4, n3 + n5 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2, n3 + n5 - 1);
        }
        if (n == 3) {
            graphics.drawLine(n2 + n4 / 2, n3 + n5 / 2, n2 + n4 / 2, n3);
            graphics.drawLine(n2 + n4 / 2, n3 + n5 / 2, n2 + n4, n3 + n5 / 2);
            graphics.setColor(color.darker());
            int n6 = 0;
            while (n6 < 3) {
                graphics.fillRect(n2 + n4 / 2 + ++n6, n3 + n5 / 2 + (2 + n6), n4 / 2, 1);
            }
        }
        graphics.setColor(color2);
    }

    public static void drawWinBottom(Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        if (n == 4) {
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3 + n5 - 1, n2 + n4, n3 + n5 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3, n2 + n4, n3);
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3 + 1, n2 + n4, n3 + 1);
        }
        if (n == 3) {
            graphics.drawLine(n2, n3 + n5 / 2, n2 + n4, n3 + n5 / 2);
            graphics.setColor(color.darker());
            graphics.fillRect(n2, n3 + n5 / 2 + 3, n4, 3);
        }
        graphics.setColor(color2);
    }

    public static void drawWinLowerRight(Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        if (n == 4) {
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(Color.black);
            graphics.drawLine(n2, n3 + n5 - 1, n2 + n4, n3 + n5 - 1);
            graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5 - 1);
        }
        if (n == 3) {
            graphics.drawLine(n2 + n4 / 2, n3, n2 + n4 / 2, n3 + n5 / 2);
            graphics.drawLine(n2 + n4 / 2, n3 + n5 / 2, n2, n3 + n5 / 2);
            graphics.setColor(color.darker());
            graphics.fillRect(n2 + n4 / 2 + 3, n3, 3, n5 / 2 + 3);
            graphics.fillRect(n2, n3 + n5 / 2 + 3, n4 / 2 + 6, 3);
        }
        graphics.setColor(color2);
    }

    public static void drawEtchedRect(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawLine(0, 0, n3 - 1, 0);
        graphics.drawLine(0, 1, 0, n4 - 2);
        graphics.setColor(color2);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(1, 2, 1, n4 - 3);
        graphics.setColor(color4);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.setColor(color3);
        graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 3);
        graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
        graphics.setColor(color5);
    }

    public static Insets getEtchedInsets() {
        return ETCHED_INSETS;
    }

    public static void drawGroove(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        Color color3 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
        graphics.setColor(color2);
        graphics.drawLine(1, n4 - 3, 1, 1);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        graphics.setColor(color3);
    }

    public static Insets getGrooveInsets() {
        return GROOVE_INSETS;
    }

    public static void drawBezel(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        if (bl) {
            if (bl2) {
                graphics.setColor(color2);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            }
            graphics.setColor(color);
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
        } else {
            if (bl2) {
                graphics.setColor(color2);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.drawLine(2, 1, n3 - 3, 1);
                graphics.setColor(color3);
                graphics.drawLine(2, 2, 2, n4 - 4);
                graphics.drawLine(3, 2, n3 - 4, 2);
                graphics.setColor(color);
                graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 3, 2, n3 - 3, n4 - 4);
                graphics.setColor(color2);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 1);
            } else {
                graphics.setColor(color4);
                graphics.drawLine(0, 0, 0, n4 - 1);
                graphics.drawLine(1, 0, n3 - 2, 0);
                graphics.setColor(color3);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.drawLine(2, 1, n3 - 3, 1);
                graphics.setColor(color);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 3);
                graphics.setColor(color2);
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
                graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
            }
            graphics.setColor(color5);
        }
    }

    public static void drawLoweredBezel(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        graphics.setColor(color2);
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.drawLine(1, 0, n3 - 2, 0);
        graphics.setColor(color);
        graphics.drawLine(1, 1, 1, n4 - 2);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.setColor(color4);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        graphics.setColor(color3);
        graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
        graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 1);
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = -1;
        if (n != 0) {
            char c = Character.toUpperCase((char)n);
            char c2 = Character.toLowerCase((char)n);
            int n5 = string.indexOf(c);
            int n6 = string.indexOf(c2);
            n4 = n5 == -1 ? n6 : (n6 == -1 ? n5 : (n6 < n5 ? n6 : n5));
        }
        graphics.drawString(string, n2, n3);
        if (n4 != -1) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n7 = n2 + fontMetrics.stringWidth(string.substring(0, n4));
            int n8 = n3;
            int n9 = fontMetrics.charWidth(string.charAt(n4));
            int n10 = 1;
            graphics.fillRect(n7, n8 + fontMetrics.getDescent() - 1, n9, n10);
        }
    }

    public static void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = n; i < n + n3; i += 2) {
            graphics.drawLine(i, n2, i, n2);
            graphics.drawLine(i, n2 + n4 - 1, i, n2 + n4 - 1);
        }
        for (int i = n2; i < n2 + n4; i += 2) {
            graphics.drawLine(n, i, n, i);
            graphics.drawLine(n + n3 - 1, i, n + n3 - 1, i);
        }
    }

    public static Font getDerivedFont(Font font, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        float f4;
        int n5 = n / n4;
        int n6 = n2 / (n3 + 2);
        int n7 = 0;
        int n8 = 0;
        Font font2 = null;
        FontRenderContext fontRenderContext = null;
        AffineTransform affineTransform = new AffineTransform();
        if (n4 == 132) {
            affineTransform.scale(f2, f);
        } else {
            affineTransform.setToScale(1.0, 1.0);
            f3 = 0.0f;
        }
        if (f3 == 0.0f) {
            for (f4 = 1.0f; f4 < 36.0f; f4 += 1.0f) {
                font2 = font.deriveFont(f4);
                font2 = font2.deriveFont(affineTransform);
                fontRenderContext = new FontRenderContext(font2.getTransform(), true, true);
                LineMetrics lineMetrics = font2.getLineMetrics("Wy", fontRenderContext);
                n7 = (int)font2.getStringBounds("W", fontRenderContext).getWidth() + 2;
                n8 = (int)(font2.getStringBounds("y", fontRenderContext).getHeight() + (double)lineMetrics.getDescent() + (double)lineMetrics.getLeading());
                if (n5 >= n7 && n6 >= n8) {
                    continue;
                }
                break;
            }
        } else {
            font2 = font.deriveFont(f3);
        }
        if (f4 > 1.0f) {
            font2 = font.deriveFont(f4 -= 1.0f);
        }
        font2 = font2.deriveFont(affineTransform);
        return font2;
    }

    public static void positionPopup(Component component, JPopupMenu jPopupMenu, int n, int n2) {
        Dimension dimension = jPopupMenu.getSize();
        if (dimension.width == 0) {
            dimension = jPopupMenu.getPreferredSize();
        }
        Point point = new Point(n + dimension.width, n2 + dimension.height);
        SwingUtilities.convertPointToScreen(point, component);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = 0;
        int n4 = 0;
        if (point.y > dimension2.height - 25) {
            n4 = n2 - dimension.height;
        }
        if (point.x > dimension2.width) {
            n3 = n - dimension.width;
        }
        jPopupMenu.show(component, n3 != 0 ? n3 : n, n4 != 0 ? n4 : n2);
    }

    public static String getDefaultFont() {
        if (defaultFont == null) {
            String[] stringArray = windowsFonts;
            if (OperatingSystem.isMacOS()) {
                stringArray = macFonts;
            } else if (OperatingSystem.isUnix()) {
                stringArray = nixFonts;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!GUIGraphicsUtils.isFontNameExists(stringArray[i])) continue;
                defaultFont = stringArray[i];
                break;
            }
            if (defaultFont == null) {
                defaultFont = "";
            }
        }
        return defaultFont;
    }

    public static boolean isFontNameExists(String string) {
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fontArray.length; ++i) {
            if (fontArray[i].getFontName().indexOf(46) >= 0 || !fontArray[i].getFontName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static ImageIcon createImageIcon(String string) {
        URL uRL = null;
        ClassLoader classLoader = GUIGraphicsUtils.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            uRL = classLoader.getResource(string);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return new ImageIcon(uRL);
    }

    public static ImageIcon getOpenLockIcon() {
        if (lockImgOpen == null) {
            lockImgOpen = GUIGraphicsUtils.createImageIcon("lock-open.png");
        }
        return lockImgOpen;
    }

    public static ImageIcon getClosedLockIcon() {
        if (lockImgClose == null) {
            lockImgClose = GUIGraphicsUtils.createImageIcon("lock.png");
        }
        return lockImgClose;
    }

    public static final List<Image> getApplicationIcons() {
        if (tnicon == null) {
            tnicon = new ArrayList<Image>();
            tnicon.add(new ImageIcon(ClassLoader.getSystemClassLoader().getResource("tn5250j-16x16.png")).getImage());
            tnicon.add(new ImageIcon(ClassLoader.getSystemClassLoader().getResource("tn5250j-32x32.png")).getImage());
            tnicon.add(new ImageIcon(ClassLoader.getSystemClassLoader().getResource("tn5250j-48x48.png")).getImage());
        }
        return tnicon;
    }

    static {
        windowsFonts = new String[]{"Andale Mono", "Letter Gothic Bold", "Lucida Sans Typewriter Regular", "Lucida Sans Typewriter Bold", "Lucida Console", "Courier New Bold", "Courier New", "Courier"};
        nixFonts = new String[]{"Lucida Sans Typewriter Regular", "Lucida Sans Typewriter Bold", "Courier New Bold", "Courier New", "Courier Bold", "Courier"};
        macFonts = new String[]{"Monaco", "Courier New Bold", "Courier New", "Courier"};
    }
}

