/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tn5250j.SessionPanel;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.scripting.ExecuteScriptAction;
import org.tn5250j.scripting.InterpreterDriverManager;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.Macronizer;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public final class LoadMacroMenu {
    private static Vector macroVector = new Vector();
    private static final TN5250jLogger log = TN5250jLogFactory.getLogger(LoadMacroMenu.class);

    public static void loadMacros(SessionPanel sessionPanel, JMenu jMenu) {
        Object object;
        int n;
        final SessionPanel sessionPanel2 = sessionPanel;
        Vector<String> vector = new Vector<String>();
        jMenu.addSeparator();
        String[] stringArray = Macronizer.getMacroList();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        Collections.sort(vector);
        for (n = 0; n < vector.size(); ++n) {
            AbstractAction abstractAction = new AbstractAction((String)vector.get(n)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    sessionPanel2.executeMacro(actionEvent);
                }
            };
            object = jMenu.add(abstractAction);
            ((Component)object).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        LoadMacroMenu.doOptionsPopup(mouseEvent, sessionPanel2);
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        LoadMacroMenu.doOptionsPopup(mouseEvent, sessionPanel2);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        LoadMacroMenu.doOptionsPopup(mouseEvent, sessionPanel2);
                    }
                }
            });
        }
        LoadMacroMenu.scriptDir("scripts", jMenu, sessionPanel);
        String string = "";
        object = "";
        try {
            string = new File("scripts").getCanonicalPath();
            object = new File(ConfigureFactory.getInstance().getProperty("emulator.settingsDirectory") + "scripts").getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!string.equals(object)) {
            LoadMacroMenu.scriptDir(ConfigureFactory.getInstance().getProperty("emulator.settingsDirectory") + "scripts", jMenu, sessionPanel);
        }
    }

    private static void doOptionsPopup(MouseEvent mouseEvent, SessionPanel sessionPanel) {
        JPopupMenu jPopupMenu = new JPopupMenu("Macro Options");
        AbstractAction abstractAction = new AbstractAction(LangTool.getString("popup.delete") + " " + ((JMenuItem)mouseEvent.getSource()).getText()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer(((JMenuItem)actionEvent.getSource()).getText());
                stringBuffer.delete(0, LangTool.getString("popup.delete").length() + 1);
                Macronizer.removeMacroByName(stringBuffer.toString());
            }
        };
        jPopupMenu.add(abstractAction);
        final SessionPanel sessionPanel2 = sessionPanel;
        abstractAction = new AbstractAction(LangTool.getString("popup.execute") + " " + ((JMenuItem)mouseEvent.getSource()).getText()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer(((JMenuItem)actionEvent.getSource()).getText());
                stringBuffer.delete(0, LangTool.getString("popup.execute").length() + 1);
                Macronizer.invoke(stringBuffer.toString(), sessionPanel2);
            }
        };
        jPopupMenu.add(abstractAction);
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent((JMenuItem)mouseEvent.getSource(), mouseEvent, sessionPanel);
        GUIGraphicsUtils.positionPopup(sessionPanel, jPopupMenu, mouseEvent2.getX(), mouseEvent2.getY());
    }

    public static void scriptDir(String string, JMenu jMenu, SessionPanel sessionPanel) {
        File file = new File(string);
        try {
            macroVector = new Vector();
            LoadMacroMenu.loadScripts(macroVector, file.getCanonicalPath(), file, sessionPanel);
            LoadMacroMenu.createScriptsMenu(jMenu, macroVector, 0);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    private static void loadScripts(Vector vector, String string, File file, SessionPanel sessionPanel) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        Arrays.sort(fileArray, new MacroCompare());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                Object object;
                File file2 = fileArray[i];
                String string2 = file2.getName();
                if (file2.isHidden()) continue;
                if (file2.isDirectory()) {
                    object = new Vector<String>();
                    ((Vector)object).addElement(string2.replace('_', ' '));
                    LoadMacroMenu.loadScripts((Vector)object, string + string2 + '/', file2, sessionPanel);
                    vector.addElement(object);
                    continue;
                }
                if (!InterpreterDriverManager.isScriptSupported(string2)) continue;
                object = string2.replace('_', ' ');
                int n = ((String)object).lastIndexOf(46);
                if (n > 0) {
                    object = ((String)object).substring(0, n);
                }
                ExecuteScriptAction executeScriptAction = new ExecuteScriptAction((String)object, file2.getAbsolutePath(), sessionPanel){
                    private static final long serialVersionUID = 1L;
                };
                vector.addElement(executeScriptAction);
                continue;
            }
            catch (SecurityException securityException) {
                log.warn(securityException.getMessage());
            }
        }
    }

    private static void createScriptsMenu(JMenu jMenu, Vector vector, int n) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add("Delete");
        for (int i = n; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof ExecuteScriptAction) {
                jMenu.add((ExecuteScriptAction)e);
                continue;
            }
            if (!(e instanceof Vector)) continue;
            Vector vector2 = (Vector)e;
            String string = (String)vector2.elementAt(0);
            JMenu jMenu2 = new JMenu(string);
            LoadMacroMenu.createScriptsMenu(jMenu2, vector2, 1);
            if (jMenu2.getMenuComponentCount() == 0) {
                jMenu2.add(LangTool.getString("popup.noScripts"));
            }
            jMenu.add(jMenu2);
        }
    }

    public static class MacroCompare
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = object.toString();
            String string2 = object2.toString();
            return string.compareToIgnoreCase(string2);
        }
    }
}

