/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tn5250j.SessionPanel;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.scripting.InterpreterDriverManager;

public class Macronizer {
    private static Properties macros;
    private static boolean macrosExist;

    public static void init() {
        if (macros != null) {
            return;
        }
        macrosExist = Macronizer.loadMacros();
    }

    private static boolean loadMacros() {
        macros = ConfigureFactory.getInstance().getProperties("macros");
        if (macros != null && macros.size() > 0) {
            return true;
        }
        return Macronizer.checkScripts();
    }

    private static final void saveMacros() {
        ConfigureFactory.getInstance().saveSettings("macros", "------ Macros --------");
    }

    public static final boolean isMacrosExist() {
        return macrosExist;
    }

    public static final int getNumOfMacros() {
        return macros.size();
    }

    public static final String[] getMacroList() {
        String[] stringArray = new String[macros.size()];
        Set<Object> set = macros.keySet();
        Iterator<Object> iterator = set.iterator();
        String string = null;
        int n = 0;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            int n2 = string.indexOf(".");
            stringArray[n++] = string.substring(n2 + 1);
        }
        return stringArray;
    }

    public static final String getMacroByNumber(int n) {
        String string = "macro" + n + ".";
        Set<Object> set = macros.keySet();
        Iterator<Object> iterator = set.iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            return (String)macros.get(string2);
        }
        return null;
    }

    public static final String getMacroByName(String string) {
        Set<Object> set = macros.keySet();
        Iterator<Object> iterator = set.iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string2.endsWith(string)) continue;
            return (String)macros.get(string2);
        }
        return null;
    }

    public static final void removeMacroByName(String string) {
        Set<Object> set = macros.keySet();
        Iterator<Object> iterator = set.iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string2.endsWith(string)) continue;
            macros.remove(string2);
            Macronizer.saveMacros();
            return;
        }
    }

    public static final void setMacro(String string, String string2) {
        int n = 0;
        if (macrosExist && Macronizer.getMacroByName(string) != null) {
            Set<Object> set = macros.keySet();
            Iterator<Object> iterator = set.iterator();
            String string3 = null;
            String string4 = null;
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (!string3.endsWith(string)) continue;
                string4 = string3.substring(0, string3.indexOf(string));
                macros.put(string4 + string, string2);
            }
        } else {
            while (Macronizer.getMacroByNumber(++n) != null) {
            }
            macros.put("macro" + n + "." + string, string2);
            macrosExist = true;
        }
        Macronizer.saveMacros();
    }

    public static void showRunScriptDialog(SessionPanel sessionPanel) {
        String string;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Enter script to run");
        final JTextField jTextField = new JTextField();
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jTextField, "Center");
        Object[] objectArray = new Object[]{jPanel};
        Object[] objectArray2 = new String[]{"Run", "Cancel"};
        JOptionPane jOptionPane = new JOptionPane(objectArray, 3, -1, null, objectArray2, objectArray2[0]);
        JDialog jDialog = jOptionPane.createDialog(sessionPanel, "Run Script");
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                super.windowOpened(windowEvent);
                jTextField.requestFocus();
            }
        });
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (!(object instanceof Integer) && (string = (String)object).equals(objectArray2[0]) && jTextField.getText().length() > 0) {
            Macronizer.invoke(jTextField.getText(), sessionPanel);
        }
    }

    public static final void invoke(String string, SessionPanel sessionPanel) {
        String string2 = Macronizer.getMacroByName(string);
        if (string2 != null) {
            sessionPanel.getScreen().sendKeys(string2);
        } else {
            try {
                if (!string.endsWith(".py")) {
                    string = string + ".py";
                }
                InterpreterDriverManager.executeScriptFile(sessionPanel, "scripts" + File.separatorChar + string);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    private static boolean checkScripts() {
        File file = new File("scripts");
        File file2 = new File(ConfigureFactory.getInstance().getProperty("emulator.settingsDirectory") + "scripts");
        return file.isDirectory() || file2.isDirectory();
    }
}

