/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.FTPStatusEvent;
import org.tn5250j.event.FTPStatusListener;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.gui.GenericTn5250JFrame;
import org.tn5250j.gui.TN5250jFileChooser;
import org.tn5250j.gui.TN5250jFileFilter;
import org.tn5250j.mailtools.SendEMailDialog;
import org.tn5250j.sql.AS400Xtfr;
import org.tn5250j.sql.SqlWizard;
import org.tn5250j.tools.FTP5250Prot;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.filters.XTFRFileFilter;

public class XTFRFile
extends GenericTn5250JFrame
implements ActionListener,
FTPStatusListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private FTP5250Prot ftpProtocol;
    private AS400Xtfr axtfr;
    private GridBagConstraints gbc;
    private JTextField user;
    private JPasswordField password;
    private JTextField systemName;
    private JTextField hostFile;
    private JTextField localFile;
    private JRadioButton allFields;
    private JRadioButton selectedFields;
    private JComboBox decimalSeparator;
    private JComboBox fileFormat;
    private JCheckBox useQuery;
    private JButton queryWizard;
    private JTextArea queryStatement;
    private JButton customize;
    private JButton xtfrButton;
    private JRadioButton intDesc;
    private JRadioButton txtDesc;
    private JPanel as400QueryP;
    private JPanel as400p;
    boolean fieldsSelected;
    boolean emailIt;
    tnvt vt;
    XTFRFileFilter htmlFilter;
    XTFRFileFilter KSpreadFilter;
    XTFRFileFilter OOFilter;
    XTFRFileFilter ExcelFilter;
    XTFRFileFilter DelimitedFilter;
    XTFRFileFilter FixedWidthFilter;
    XTFRFileFilter fileFilter;
    ProgressMonitor pm;
    JProgressBar progressBar;
    JTextArea taskOutput;
    JLabel fieldsLabel;
    JLabel textDescLabel;
    JLabel label;
    JLabel note;
    ProgressOptionPane monitor;
    JDialog dialog;
    XTFRFileFilter filter;
    SessionPanel session;
    static String messageProgress;

    public XTFRFile(Frame frame, tnvt tnvt2, SessionPanel sessionPanel) {
        this(frame, tnvt2, sessionPanel, null);
    }

    public XTFRFile(Frame frame, tnvt tnvt2, SessionPanel sessionPanel, Properties properties) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.session = sessionPanel;
        this.vt = tnvt2;
        this.ftpProtocol = new FTP5250Prot(this.vt);
        this.ftpProtocol.addFTPStatusListener(this);
        this.axtfr = new AS400Xtfr(this.vt);
        this.axtfr.addFTPStatusListener(this);
        this.createProgressMonitor();
        this.initFileFilters();
        this.initXTFRInfo(properties);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (XTFRFile.this.ftpProtocol != null && XTFRFile.this.ftpProtocol.isConnected()) {
                    XTFRFile.this.ftpProtocol.disconnect();
                }
            }
        });
        messageProgress = LangTool.getString("xtfr.messageProgress");
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void initFileFilters() {
        this.htmlFilter = new XTFRFileFilter(new String[]{"html", "htm"}, "Hyper Text Markup Language");
        this.htmlFilter.setOutputFilterName("org.tn5250j.tools.filters.HTMLOutputFilter");
        this.KSpreadFilter = new XTFRFileFilter("ksp", "KSpread KDE Spreadsheet");
        this.KSpreadFilter.setOutputFilterName("org.tn5250j.tools.filters.KSpreadOutputFilter");
        this.OOFilter = new XTFRFileFilter("sxc", "OpenOffice");
        this.OOFilter.setOutputFilterName("org.tn5250j.tools.filters.OpenOfficeOutputFilter");
        this.ExcelFilter = new XTFRFileFilter("xls", "Excel");
        this.ExcelFilter.setOutputFilterName("org.tn5250j.tools.filters.ExcelOutputFilter");
        this.DelimitedFilter = new XTFRFileFilter(new String[]{"csv", "tab"}, "Delimited");
        this.DelimitedFilter.setOutputFilterName("org.tn5250j.tools.filters.DelimitedOutputFilter");
        this.FixedWidthFilter = new XTFRFileFilter("txt", "Fixed Width");
        this.FixedWidthFilter.setOutputFilterName("org.tn5250j.tools.filters.FixedWidthOutputFilter");
    }

    @Override
    public void statusReceived(FTPStatusEvent fTPStatusEvent) {
        if (this.monitor.isCanceled()) {
            this.ftpProtocol.setAborted();
        } else {
            final int n = fTPStatusEvent.getCurrentRecord();
            final int n2 = fTPStatusEvent.getFileLength();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (n >= n2) {
                        XTFRFile.this.progressBar.setValue(n2);
                        XTFRFile.this.label.setText(LangTool.getString("xtfr.labelComplete"));
                        XTFRFile.this.note.setText(XTFRFile.this.getTransferredNote(n2));
                        XTFRFile.this.monitor.setDone();
                        if (XTFRFile.this.emailIt) {
                            XTFRFile.this.emailMe();
                        }
                    } else {
                        XTFRFile.this.progressBar.setValue(n);
                        XTFRFile.this.note.setText(XTFRFile.this.getProgressNote(n, n2));
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private String getProgressNote(int n, int n2) {
        Object[] objectArray = new Object[]{Integer.toString(n), Integer.toString(n2)};
        try {
            return MessageFormat.format(messageProgress, objectArray);
        }
        catch (Exception exception) {
            System.out.println(" getProgressNote: " + exception.getMessage());
            return "Record " + n + " of " + n2;
        }
    }

    private void emailMe() {
        SendEMailDialog sendEMailDialog = new SendEMailDialog((Frame)this.getParent(), this.session, this.localFile.getText());
    }

    private String getTransferredNote(int n) {
        Object[] objectArray = new Object[]{Integer.toString(n)};
        try {
            return MessageFormat.format(LangTool.getString("xtfr.messageTransferred"), objectArray);
        }
        catch (Exception exception) {
            System.out.println(" getTransferredNote: " + exception.getMessage());
            return n + " records transferred!";
        }
    }

    @Override
    public void commandStatusReceived(FTPStatusEvent fTPStatusEvent) {
        final String string = fTPStatusEvent.getMessage() + '\n';
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                XTFRFile.this.taskOutput.setText(XTFRFile.this.taskOutput.getText() + string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void fileInfoReceived(FTPStatusEvent fTPStatusEvent) {
        this.hostFile.setText(this.ftpProtocol.getFullFileName(this.hostFile.getText()));
        if (this.allFields.isSelected()) {
            this.doTransfer();
        } else {
            this.selectFields();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("SAVE")) {
            this.saveXTFRInfo();
        }
        if (actionEvent.getActionCommand().equals("LOAD")) {
            this.loadXTFRInfo();
        }
        if (actionEvent.getActionCommand().equals("XTFR") || actionEvent.getActionCommand().equals("EMAIL")) {
            this.saveXTFRFields();
            this.emailIt = actionEvent.getActionCommand().equals("EMAIL");
            this.initializeMonitor();
            this.dialog.setVisible(true);
            if (this.useQuery.isSelected()) {
                this.axtfr.login(this.user.getText(), new String(this.password.getPassword()));
                this.axtfr.setDecimalChar(this.getDecimalChar());
                this.axtfr.connect(this.systemName.getText());
            } else if (this.ftpProtocol != null && this.ftpProtocol.connect(this.systemName.getText(), 21)) {
                if (this.ftpProtocol.login(this.user.getText(), new String(this.password.getPassword()))) {
                    this.ftpProtocol.setDecimalChar(this.getDecimalChar());
                    this.ftpProtocol.getFileInfo(this.hostFile.getText(), this.intDesc.isSelected());
                }
            } else {
                this.disconnect();
            }
        }
        if (actionEvent.getActionCommand().equals("BROWSEPC")) {
            this.getPCFile();
        }
        if (actionEvent.getActionCommand().equals("CUSTOMIZE")) {
            this.filter.getOutputFilterInstance().setCustomProperties();
        }
    }

    private char getDecimalChar() {
        String string = (String)this.decimalSeparator.getSelectedItem();
        return string.charAt(1);
    }

    private void initializeMonitor() {
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(0);
        this.label.setText(LangTool.getString("xtfr.labelInProgress"));
        this.note.setText(LangTool.getString("xtfr.labelFileInfo"));
        this.progressBar.setStringPainted(false);
        this.monitor.reset();
    }

    private void disconnect() {
        if (this.ftpProtocol != null) {
            this.ftpProtocol.disconnect();
            this.ftpProtocol = null;
        }
    }

    private void doTransfer() {
        this.progressBar.setMaximum(this.ftpProtocol.getFileSize());
        this.progressBar.setStringPainted(true);
        this.fileFilter = this.getFilterByDescription();
        if (this.useQuery.isSelected()) {
            this.axtfr.setOutputFilter(this.fileFilter.getOutputFilterInstance());
            this.axtfr.getFile(this.hostFile.getText(), this.fileFilter.setExtension(this.localFile.getText()), this.queryStatement.getText().trim(), this.intDesc.isSelected());
        } else {
            this.ftpProtocol.setOutputFilter(this.fileFilter.getOutputFilterInstance());
            this.ftpProtocol.getFile(this.hostFile.getText(), this.fileFilter.setExtension(this.localFile.getText()));
        }
    }

    private XTFRFileFilter getFilterByDescription() {
        String string = (String)this.fileFormat.getSelectedItem();
        if (this.KSpreadFilter.getDescription().equals(string)) {
            return this.KSpreadFilter;
        }
        if (this.OOFilter.getDescription().equals(string)) {
            return this.OOFilter;
        }
        if (this.ExcelFilter.getDescription().equals(string)) {
            return this.ExcelFilter;
        }
        if (this.DelimitedFilter.getDescription().equals(string)) {
            return this.DelimitedFilter;
        }
        if (this.FixedWidthFilter.getDescription().equals(string)) {
            return this.FixedWidthFilter;
        }
        return this.htmlFilter;
    }

    private void createProgressMonitor() {
        this.progressBar = new JProgressBar(0, 0);
        this.progressBar.setValue(0);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        JPanel jPanel = new JPanel();
        this.note = new JLabel();
        this.note.setForeground(Color.blue);
        this.label = new JLabel();
        this.label.setForeground(Color.blue);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.label, "North");
        jPanel.add((Component)this.note, "Center");
        jPanel.add((Component)this.progressBar, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.monitor = new ProgressOptionPane(jPanel2);
        this.taskOutput.setRows(6);
        this.dialog = this.monitor.createDialog(this, LangTool.getString("xtfr.progressTitle"));
    }

    private void startWizard() {
        try {
            SqlWizard sqlWizard = new SqlWizard(this.systemName.getText().trim(), this.user.getText(), new String(this.password.getPassword()));
            sqlWizard.setQueryTextArea(this.queryStatement);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(this, LangTool.getString("messages.noAS400Toolbox"), "Error", 0, null);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private void getPCFile() {
        String string = System.getProperty("user.dir");
        TN5250jFileChooser tN5250jFileChooser = new TN5250jFileChooser(string);
        this.filter = this.getFilterByDescription();
        tN5250jFileChooser.addChoosableFileFilter(this.filter);
        int n = tN5250jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = tN5250jFileChooser.getSelectedFile();
            this.filter = null;
            this.filter = tN5250jFileChooser.getFileFilter() instanceof XTFRFileFilter ? (XTFRFileFilter)tN5250jFileChooser.getFileFilter() : this.htmlFilter;
            this.localFile.setText(this.filter.setExtension(file));
        }
    }

    private void initXTFRInfo(Properties properties) {
        BorderLayout borderLayout = new BorderLayout();
        Border border = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(borderLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(border);
        this.as400p = new JPanel();
        this.as400p.setBorder(BorderFactory.createTitledBorder(LangTool.getString("xtfr.labelAS400")));
        this.as400p.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(LangTool.getString("xtfr.labelSystemName"));
        this.systemName = new JTextField(this.vt.getHostName());
        this.systemName.setColumns(30);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)jLabel, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        this.as400p.add((Component)this.systemName, this.gbc);
        JLabel jLabel2 = new JLabel(LangTool.getString("xtfr.labelHostFile"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)jLabel2, this.gbc);
        this.hostFile = new JTextField();
        this.hostFile.setColumns(30);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        this.as400p.add((Component)this.hostFile, this.gbc);
        JLabel jLabel3 = new JLabel(LangTool.getString("xtfr.labelUserId"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)jLabel3, this.gbc);
        this.user = new JTextField();
        this.user.setColumns(15);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.as400p.add((Component)this.user, this.gbc);
        JLabel jLabel4 = new JLabel(LangTool.getString("xtfr.labelPassword"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)jLabel4, this.gbc);
        this.password = new JPasswordField();
        this.password.setColumns(15);
        this.password.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                XTFRFile.this.txtONKeyPressed(keyEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.as400p.add((Component)this.password, this.gbc);
        this.useQuery = new JCheckBox(LangTool.getString("xtfr.labelUseQuery"));
        this.useQuery.addItemListener(this);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)this.useQuery, this.gbc);
        this.queryWizard = new JButton(LangTool.getString("xtfr.labelQueryWizard"));
        this.queryWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XTFRFile.this.startWizard();
            }
        });
        this.queryWizard.setEnabled(false);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 4;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 0, 5);
        this.as400p.add((Component)this.queryWizard, this.gbc);
        this.fieldsLabel = new JLabel(LangTool.getString("xtfr.labelFields"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 5;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)this.fieldsLabel, this.gbc);
        this.allFields = new JRadioButton(LangTool.getString("xtfr.labelAllFields"));
        this.allFields.setSelected(true);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 5;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(0, 5, 0, 5);
        this.as400p.add((Component)this.allFields, this.gbc);
        this.selectedFields = new JRadioButton(LangTool.getString("xtfr.labelSelectedFields"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 5;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(0, 5, 0, 10);
        this.as400p.add((Component)this.selectedFields, this.gbc);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.allFields);
        buttonGroup.add(this.selectedFields);
        this.textDescLabel = new JLabel(LangTool.getString("xtfr.labelTxtDesc"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 6;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)this.textDescLabel, this.gbc);
        this.txtDesc = new JRadioButton(LangTool.getString("xtfr.labelTxtDescFull"));
        this.txtDesc.setSelected(true);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 6;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(0, 5, 5, 5);
        this.as400p.add((Component)this.txtDesc, this.gbc);
        this.intDesc = new JRadioButton(LangTool.getString("xtfr.labelTxtDescInt"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 6;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(0, 5, 5, 10);
        this.as400p.add((Component)this.intDesc, this.gbc);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.txtDesc);
        buttonGroup2.add(this.intDesc);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(LangTool.getString("xtfr.labelpc")));
        JLabel jLabel5 = new JLabel(LangTool.getString("xtfr.labelFileFormat"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        jPanel3.add((Component)jLabel5, this.gbc);
        this.fileFormat = new JComboBox();
        this.fileFormat.setPreferredSize(new Dimension(220, 25));
        this.fileFormat.addItem(this.htmlFilter.getDescription());
        this.fileFormat.addItem(this.OOFilter.getDescription());
        this.fileFormat.addItem(this.ExcelFilter.getDescription());
        this.fileFormat.addItem(this.KSpreadFilter.getDescription());
        this.fileFormat.addItem(this.DelimitedFilter.getDescription());
        this.fileFormat.addItem(this.FixedWidthFilter.getDescription());
        this.fileFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XTFRFile.this.filter = XTFRFile.this.getFilterByDescription();
                if (XTFRFile.this.filter.getOutputFilterInstance().isCustomizable()) {
                    XTFRFile.this.customize.setEnabled(true);
                } else {
                    XTFRFile.this.customize.setEnabled(false);
                }
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 5, 0, 5);
        jPanel3.add((Component)this.fileFormat, this.gbc);
        this.customize = new JButton(LangTool.getString("xtfr.labelCustomize"));
        this.customize.setPreferredSize(new Dimension(110, 25));
        this.customize.setActionCommand("CUSTOMIZE");
        this.customize.addActionListener(this);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 5, 0, 10);
        jPanel3.add((Component)this.customize, this.gbc);
        this.fileFormat.setSelectedIndex(0);
        JLabel jLabel6 = new JLabel(LangTool.getString("xtfr.labelPCFile"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        jPanel3.add((Component)jLabel6, this.gbc);
        this.localFile = new JTextField();
        this.localFile.setColumns(15);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 0, 5);
        jPanel3.add((Component)this.localFile, this.gbc);
        JButton jButton = new JButton(LangTool.getString("xtfr.labelPCBrowse"));
        jButton.setActionCommand("BROWSEPC");
        jButton.addActionListener(this);
        jButton.setPreferredSize(new Dimension(110, 25));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 0, 10);
        jPanel3.add((Component)jButton, this.gbc);
        this.decimalSeparator = new JComboBox();
        this.decimalSeparator.setPreferredSize(new Dimension(220, 25));
        this.decimalSeparator.addItem(LangTool.getString("xtfr.period"));
        this.decimalSeparator.addItem(LangTool.getString("xtfr.comma"));
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.getDefault());
        if (decimalFormat.getDecimalFormatSymbols().getDecimalSeparator() == '.') {
            this.decimalSeparator.setSelectedIndex(0);
        } else {
            this.decimalSeparator.setSelectedIndex(1);
        }
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 10, 5);
        jPanel3.add((Component)new JLabel(LangTool.getString("xtfr.labelDecimal")), this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 5, 5);
        jPanel3.add((Component)this.decimalSeparator, this.gbc);
        jPanel2.add((Component)this.as400p, "North");
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 10, 10));
        this.xtfrButton = new JButton(LangTool.getString("xtfr.labelXTFR"));
        this.xtfrButton.addActionListener(this);
        this.xtfrButton.setActionCommand("XTFR");
        jPanel4.add(this.xtfrButton);
        JButton jButton2 = new JButton(LangTool.getString("xtfr.labelXTFREmail"));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("EMAIL");
        jPanel4.add(jButton2);
        JButton jButton3 = new JButton(LangTool.getString("xtfr.labelXTFRSave"));
        jButton3.addActionListener(this);
        jButton3.setActionCommand("SAVE");
        jPanel4.add(jButton3);
        JButton jButton4 = new JButton(LangTool.getString("xtfr.labelXTFRLoad"));
        jButton4.addActionListener(this);
        jButton4.setActionCommand("LOAD");
        jPanel4.add(jButton4);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        this.setTitle(LangTool.getString("xtfr.title"));
        this.as400QueryP = new JPanel();
        this.as400QueryP.setLayout(new BorderLayout());
        this.queryStatement = new JTextArea(2, 40);
        JScrollPane jScrollPane = new JScrollPane(this.queryStatement);
        this.queryStatement.setLineWrap(true);
        this.as400QueryP.add((Component)jScrollPane, "Center");
        this.initXTFRFields(properties);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
    }

    private void txtONKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.xtfrButton.doClick();
        }
    }

    private void initXTFRFields(Properties properties) {
        if (properties == null) {
            SessionConfig sessionConfig = this.session.getSession().getConfiguration();
            properties = sessionConfig.getProperties();
        }
        if (properties.containsKey("xtfr.fileName")) {
            this.hostFile.setText(properties.getProperty("xtfr.fileName"));
        }
        if (properties.containsKey("xtfr.user")) {
            this.user.setText(properties.getProperty("xtfr.user"));
        }
        if (properties.containsKey("xtfr.useQuery")) {
            if (properties.getProperty("xtfr.useQuery").equals("true")) {
                this.useQuery.setSelected(true);
            } else {
                this.useQuery.setSelected(false);
            }
        }
        if (properties.containsKey("xtfr.queryStatement")) {
            this.queryStatement.setText(properties.getProperty("xtfr.queryStatement"));
        }
        if (properties.containsKey("xtfr.allFields")) {
            if (properties.getProperty("xtfr.allFields").equals("true")) {
                this.allFields.setSelected(true);
            } else {
                this.allFields.setSelected(false);
            }
        }
        if (properties.containsKey("xtfr.txtDesc")) {
            if (properties.getProperty("xtfr.txtDesc").equals("true")) {
                this.txtDesc.setSelected(true);
            } else {
                this.txtDesc.setSelected(false);
            }
        }
        if (properties.containsKey("xtfr.intDesc")) {
            if (properties.getProperty("xtfr.intDesc").equals("true")) {
                this.intDesc.setSelected(true);
            } else {
                this.intDesc.setSelected(false);
            }
        }
        if (properties.containsKey("xtfr.fileFormat")) {
            this.fileFormat.setSelectedItem(properties.getProperty("xtfr.fileFormat"));
        }
        if (properties.containsKey("xtfr.localFile")) {
            this.localFile.setText(properties.getProperty("xtfr.localFile"));
        }
        if (properties.containsKey("xtfr.decimalSeparator")) {
            this.decimalSeparator.setSelectedItem(properties.get("xtfr.decimalSeparator"));
        }
    }

    private void saveXTFRFields() {
        SessionConfig sessionConfig = this.session.getSession().getConfiguration();
        Properties properties = sessionConfig.getProperties();
        this.saveXTFRFields(properties);
        sessionConfig.setModified();
    }

    private void saveXTFRFields(Properties properties) {
        if (this.hostFile.getText().trim().length() > 0) {
            properties.setProperty("xtfr.fileName", this.hostFile.getText().trim());
        } else {
            properties.remove("xtfr.fileName");
        }
        if (this.user.getText().trim().length() > 0) {
            properties.setProperty("xtfr.user", this.user.getText().trim());
        } else {
            properties.remove("xtfr.user");
        }
        if (this.useQuery.isSelected()) {
            properties.setProperty("xtfr.useQuery", "true");
        } else {
            properties.remove("xtfr.useQuery");
        }
        if (this.queryStatement.getText().trim().length() > 0) {
            properties.setProperty("xtfr.queryStatement", this.queryStatement.getText().trim());
        } else {
            properties.remove("xtfr.queryStatement");
        }
        if (this.allFields.isSelected()) {
            properties.setProperty("xtfr.allFields", "true");
        } else {
            properties.remove("xtfr.allFields");
        }
        if (this.txtDesc.isSelected()) {
            properties.setProperty("xtfr.txtDesc", "true");
        } else {
            properties.remove("xtfr.txtDesc");
        }
        if (this.intDesc.isSelected()) {
            properties.setProperty("xtfr.intDesc", "true");
        } else {
            properties.remove("xtfr.intDesc");
        }
        properties.setProperty("xtfr.fileFormat", (String)this.fileFormat.getSelectedItem());
        if (this.localFile.getText().trim().length() > 0) {
            properties.setProperty("xtfr.localFile", this.localFile.getText().trim());
        } else {
            properties.remove("xtfr.localFile");
        }
        properties.setProperty("xtfr.decimalSeparator", (String)this.decimalSeparator.getSelectedItem());
    }

    private void saveXTFRInfo() {
        Properties properties = new Properties();
        properties.setProperty("xtfr.destination", "FROM");
        this.saveXTFRFields(properties);
        String string = System.getProperty("user.dir");
        TN5250jFileChooser tN5250jFileChooser = new TN5250jFileChooser(string);
        TN5250jFileFilter tN5250jFileFilter = new TN5250jFileFilter("dtf", "Transfer from AS/400");
        tN5250jFileChooser.addChoosableFileFilter(tN5250jFileFilter);
        int n = tN5250jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = tN5250jFileChooser.getSelectedFile();
            file = new File(tN5250jFileFilter.setExtension(file));
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, "------ Transfer Details --------");
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadXTFRInfo() {
        Properties properties = new Properties();
        String string = System.getProperty("user.dir");
        TN5250jFileChooser tN5250jFileChooser = new TN5250jFileChooser(string);
        TN5250jFileFilter tN5250jFileFilter = new TN5250jFileFilter("dtf", "Transfer from AS/400");
        tN5250jFileChooser.addChoosableFileFilter(tN5250jFileFilter);
        int n = tN5250jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = tN5250jFileChooser.getSelectedFile();
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (properties.containsKey("xtfr.destination") && properties.get("xtfr.destination").equals("FROM")) {
            this.initXTFRFields(properties);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.useQuery) {
            if (this.useQuery.isSelected()) {
                this.queryWizard.setEnabled(true);
                this.as400p.remove(this.fieldsLabel);
                this.as400p.remove(this.allFields);
                this.as400p.remove(this.selectedFields);
                this.as400p.remove(this.textDescLabel);
                this.as400p.remove(this.txtDesc);
                this.as400p.remove(this.intDesc);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 0;
                this.gbc.gridy = 5;
                this.gbc.gridheight = 2;
                this.gbc.gridwidth = 3;
                this.gbc.fill = 1;
                this.gbc.anchor = 17;
                this.gbc.insets = new Insets(5, 10, 10, 10);
                this.as400p.add((Component)this.as400QueryP, this.gbc);
            } else {
                this.queryWizard.setEnabled(false);
                this.as400p.remove(this.as400QueryP);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 0;
                this.gbc.gridy = 5;
                this.gbc.anchor = 17;
                this.gbc.insets = new Insets(5, 10, 5, 5);
                this.as400p.add((Component)this.fieldsLabel, this.gbc);
                this.allFields.setSelected(true);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 1;
                this.gbc.gridy = 5;
                this.gbc.anchor = 10;
                this.gbc.insets = new Insets(0, 5, 0, 5);
                this.as400p.add((Component)this.allFields, this.gbc);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 2;
                this.gbc.gridy = 5;
                this.gbc.anchor = 10;
                this.gbc.insets = new Insets(0, 5, 0, 10);
                this.as400p.add((Component)this.selectedFields, this.gbc);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 0;
                this.gbc.gridy = 6;
                this.gbc.anchor = 17;
                this.gbc.insets = new Insets(5, 10, 5, 5);
                this.as400p.add((Component)this.textDescLabel, this.gbc);
                this.txtDesc.setSelected(true);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 1;
                this.gbc.gridy = 6;
                this.gbc.anchor = 10;
                this.gbc.insets = new Insets(0, 5, 5, 5);
                this.as400p.add((Component)this.txtDesc, this.gbc);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 2;
                this.gbc.gridy = 6;
                this.gbc.anchor = 10;
                this.gbc.insets = new Insets(0, 5, 5, 10);
                this.as400p.add((Component)this.intDesc, this.gbc);
            }
            this.validate();
            this.repaint();
        }
    }

    private void selectFields() {
        FFDTableModel fFDTableModel = new FFDTableModel();
        JTable jTable = new JTable(fFDTableModel);
        jTable.setSelectionMode(0);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 200));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel jPanel = new JPanel();
        jPanel.add(jScrollPane);
        Object[] objectArray = new Object[]{jPanel};
        Object[] objectArray2 = new String[]{LangTool.getString("xtfr.tableSelectAll"), LangTool.getString("xtfr.tableSelectNone"), LangTool.getString("xtfr.tableDone")};
        int n = 0;
        block4: while (n != 2) {
            n = JOptionPane.showOptionDialog(null, objectArray, LangTool.getString("xtfr.titleFieldSelection"), -1, -1, null, objectArray2, objectArray2[1]);
            switch (n) {
                case 0: {
                    this.ftpProtocol.selectAll();
                    continue block4;
                }
                case 1: {
                    this.ftpProtocol.selectNone();
                    continue block4;
                }
            }
            this.fieldsSelected = this.ftpProtocol.isFieldsSelected();
            if (!this.ftpProtocol.isFieldsSelected()) continue;
            this.doTransfer();
        }
    }

    private class ProgressOptionPane
    extends JOptionPane {
        private static final long serialVersionUID = 1L;

        ProgressOptionPane(Object object) {
            super(object, 1, -1, null, new Object[]{UIManager.getString("OptionPane.cancelButtonText")}, null);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }

        public void setDone() {
            Object[] objectArray = this.getOptions();
            objectArray[0] = LangTool.getString("xtfr.tableDone");
            this.setOptions(objectArray);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void reset() {
            Object[] objectArray = this.getOptions();
            objectArray[0] = UIManager.getString("OptionPane.cancelButtonText");
            this.setOptions(objectArray);
            XTFRFile.this.monitor.setValue(null);
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        public boolean isCanceled() {
            if (this == null) {
                return false;
            }
            Object object = this.getValue();
            return object != null;
        }

        @Override
        public JDialog createDialog(Component component, String string) {
            Frame frame = JOptionPane.getFrameForComponent(component);
            final JDialog jDialog = new JDialog(frame, string, false);
            Container container = jDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this, "Center");
            jDialog.pack();
            jDialog.setLocationRelativeTo(component);
            jDialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    ProgressOptionPane.this.setValue(null);
                }

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                    if (!this.gotFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (jDialog.isVisible() && propertyChangeEvent.getSource() == ProgressOptionPane.this && (propertyChangeEvent.getPropertyName().equals("value") || propertyChangeEvent.getPropertyName().equals("inputValue"))) {
                        if (XTFRFile.this.ftpProtocol != null) {
                            XTFRFile.this.ftpProtocol.setAborted();
                        }
                        jDialog.setVisible(false);
                        jDialog.dispose();
                    }
                }
            });
            return jDialog;
        }
    }

    class FFDTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        final String[] cols = new String[]{LangTool.getString("xtfr.tableColA"), LangTool.getString("xtfr.tableColB")};

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.cols[n];
        }

        @Override
        public int getRowCount() {
            return XTFRFile.this.ftpProtocol.getNumberOfFields();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return new Boolean(XTFRFile.this.ftpProtocol.isFieldSelected(n));
            }
            if (n2 == 1) {
                return XTFRFile.this.ftpProtocol.getFieldName(n);
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.fireTableCellUpdated(n, n2);
            XTFRFile.this.ftpProtocol.setFieldSelected(n, (Boolean)object);
        }
    }
}

