/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.encoder;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import org.tn5250j.tools.encoder.Encoder;
import org.tn5250j.tools.encoder.EncoderException;

public abstract class AbstractImageEncoder
implements Encoder {
    protected Image img = null;
    protected OutputStream ofile = null;

    public void encode(Image image, OutputStream outputStream) throws IOException, EncoderException {
        this.img = image;
        this.ofile = outputStream;
        this.saveImage();
    }

    @Override
    public void encode(Component component, OutputStream outputStream) throws IOException, EncoderException {
        this.encode(AbstractImageEncoder.snapshot(component), outputStream);
    }

    public static Image snapshot(Component component) {
        Image image = component.createImage(component.getSize().width, component.getSize().height);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, component.getSize().width, component.getSize().height);
            component.paint(graphics);
        }
        return image;
    }

    public abstract void saveImage() throws IOException, EncoderException;

    public byte createByte(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        byte by = 0;
        if (n8 == 1) {
            by = (byte)(by | 1);
        }
        if (n7 == 1) {
            by = (byte)(by | 2);
        }
        if (n6 == 1) {
            by = (byte)(by | 4);
        }
        if (n5 == 1) {
            by = (byte)(by | 8);
        }
        if (n4 == 1) {
            by = (byte)(by | 0x10);
        }
        if (n3 == 1) {
            by = (byte)(by | 0x20);
        }
        if (n2 == 1) {
            by = (byte)(by | 0x40);
        }
        if (n == 1) {
            by = (byte)(by | 0x80);
        }
        return by;
    }

    public static byte byteFromInt(int n) {
        return (byte)(n & 0xFF);
    }

    public static byte[] bytesFromLong(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return byArray;
    }

    public static byte byteFromChar(char c) {
        char c2 = c;
        byte by = 0;
        boolean bl = false;
        for (int i = 0; i <= 7; ++i) {
            if ((c2 & (byte)Math.pow(2.0, i)) == 0) continue;
            by = (byte)(by | (byte)Math.pow(2.0, i));
        }
        return by;
    }

    public byte compressColor(int n) {
        return this.compressColor(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public byte compressColor(int n, int n2, int n3) {
        return (byte)(n & 0xE0 | n2 >> 3 & 0x1C | n3 >> 6 & 3);
    }

    protected void error(String string) throws EncoderException {
        throw new EncoderException(string);
    }
}

