/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.encoder;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tn5250j.tools.encoder.Encoder;
import org.tn5250j.tools.encoder.EncoderException;

public class EncodeComponent {
    public static final Encoding PNG = new Encoding("PNG", "Portable Network Graphics", "org.tn5250j.tools.encoder.PNGEncoder", " PNG Load Error");
    public static final Encoding[] ENCODINGS = new Encoding[]{PNG};

    public static void encode(Encoding encoding, Component component, OutputStream outputStream) throws IOException, EncoderException {
        Encoder encoder = encoding.getEncoder();
        if (encoder == null) {
            throw new EncoderException("Graphics Encoder could not be loaded.");
        }
        encoder.encode(component, outputStream);
    }

    public static void encode(Encoding encoding, Component component, File file) throws IOException, EncoderException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        EncodeComponent.encode(encoding, component, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public static class Encoding {
        private String shortName;
        private String longName;
        private String encoderClass;
        private String failureMessage;
        private Encoder encoder;

        public Encoding(String string, String string2, String string3, String string4) {
            this.shortName = string;
            this.longName = string2;
            this.encoderClass = string3;
            this.failureMessage = string4;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getLongName() {
            return this.longName;
        }

        public String toString() {
            return this.getLongName() + " (" + this.getShortName() + ")";
        }

        public String getFailureMessage() {
            return this.failureMessage != null ? this.failureMessage : "There was a failure loading encoder.";
        }

        public Encoder getEncoder() {
            if (this.encoder == null) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(this.encoderClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz != null) {
                    try {
                        this.encoder = (Encoder)clazz.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
            return this.encoder;
        }
    }
}

