/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.encoder;

import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.util.zip.Deflater;
import org.tn5250j.tools.encoder.AbstractImageEncoder;
import org.tn5250j.tools.encoder.EncoderException;

public class PNGEncoder
extends AbstractImageEncoder {
    private long[] crc_table = null;

    @Override
    public void saveImage() throws IOException, EncoderException {
        int n;
        int n2;
        if (this.img == null) {
            this.error("PNG encoding error: Image is NULL.");
        }
        PixelGrabber pixelGrabber = new PixelGrabber(this.img, 0, 0, this.img.getWidth(null), this.img.getHeight(null), false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            this.error("PNG encoding error: Unable to retrieve pixels from image.");
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n3 = colorModel.getPixelSize();
        int n4 = (int)Math.pow(2.0, n3);
        if (n3 != 8 && n3 != 16 && n3 != 24 && n3 != 32) {
            this.error("PNG encoding error: PNG method must have 8 or 16 bit colors.");
        }
        int[] nArray = null;
        byte[] byArray = null;
        if (n3 >= 16) {
            nArray = (int[])pixelGrabber.getPixels();
        } else {
            byArray = (byte[])pixelGrabber.getPixels();
        }
        this.ofile.write(PNGEncoder.byteFromInt(137));
        this.ofile.write(PNGEncoder.byteFromInt(80));
        this.ofile.write(PNGEncoder.byteFromInt(78));
        this.ofile.write(PNGEncoder.byteFromInt(71));
        this.ofile.write(PNGEncoder.byteFromInt(13));
        this.ofile.write(PNGEncoder.byteFromInt(10));
        this.ofile.write(PNGEncoder.byteFromInt(26));
        this.ofile.write(PNGEncoder.byteFromInt(10));
        long l = PNGEncoder.start_crc();
        this.ofile.write(PNGEncoder.bytesFromLong(13L));
        this.ofile.write(PNGEncoder.byteFromChar('I'));
        this.ofile.write(PNGEncoder.byteFromChar('H'));
        this.ofile.write(PNGEncoder.byteFromChar('D'));
        this.ofile.write(PNGEncoder.byteFromChar('R'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('I'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('H'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('D'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('R'));
        int n5 = this.img.getWidth(null);
        int n6 = this.img.getHeight(null);
        l = this.update_crc(l, PNGEncoder.bytesFromLong(n5));
        l = this.update_crc(l, PNGEncoder.bytesFromLong(n6));
        l = this.update_crc(l, PNGEncoder.byteFromInt(8));
        l = n3 >= 16 ? this.update_crc(l, PNGEncoder.byteFromInt(2)) : this.update_crc(l, PNGEncoder.byteFromInt(3));
        l = this.update_crc(l, PNGEncoder.byteFromInt(0));
        l = this.update_crc(l, PNGEncoder.byteFromInt(0));
        l = this.update_crc(l, PNGEncoder.byteFromInt(0));
        this.ofile.write(PNGEncoder.bytesFromLong(n5));
        this.ofile.write(PNGEncoder.bytesFromLong(n6));
        this.ofile.write(PNGEncoder.byteFromInt(8));
        if (n3 >= 16) {
            this.ofile.write(PNGEncoder.byteFromInt(2));
        } else {
            this.ofile.write(PNGEncoder.byteFromInt(3));
        }
        this.ofile.write(PNGEncoder.byteFromInt(0));
        this.ofile.write(PNGEncoder.byteFromInt(0));
        this.ofile.write(PNGEncoder.byteFromInt(0));
        this.ofile.write(PNGEncoder.bytesFromLong(PNGEncoder.end_crc(l)));
        if (n3 == 8) {
            l = PNGEncoder.start_crc();
            this.ofile.write(PNGEncoder.bytesFromLong(n4 * 3));
            this.ofile.write(PNGEncoder.byteFromChar('P'));
            this.ofile.write(PNGEncoder.byteFromChar('L'));
            this.ofile.write(PNGEncoder.byteFromChar('T'));
            this.ofile.write(PNGEncoder.byteFromChar('E'));
            l = this.update_crc(l, PNGEncoder.byteFromChar('P'));
            l = this.update_crc(l, PNGEncoder.byteFromChar('L'));
            l = this.update_crc(l, PNGEncoder.byteFromChar('T'));
            l = this.update_crc(l, PNGEncoder.byteFromChar('E'));
            for (int i = 0; i < n4; ++i) {
                n2 = PNGEncoder.byteFromInt(colorModel.getRed(i));
                n = PNGEncoder.byteFromInt(colorModel.getGreen(i));
                byte by = PNGEncoder.byteFromInt(colorModel.getBlue(i));
                l = this.update_crc(l, (byte)n2);
                l = this.update_crc(l, (byte)n);
                l = this.update_crc(l, by);
                this.ofile.write(n2);
                this.ofile.write(n);
                this.ofile.write(by);
            }
            this.ofile.write(PNGEncoder.bytesFromLong(PNGEncoder.end_crc(l)));
        }
        byte[] byArray2 = null;
        byArray2 = n3 == 8 ? new byte[byArray.length + n6] : new byte[nArray.length * 3 + n6];
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            byArray2[n2] = 0;
        }
        n2 = 0;
        n2 = n3 >= 16 ? this.compress(byArray2, nArray, colorModel, n5, n6) : this.compress(byArray2, byArray, n5, n6);
        l = PNGEncoder.start_crc();
        this.ofile.write(PNGEncoder.bytesFromLong(n2));
        this.ofile.write(PNGEncoder.byteFromChar('I'));
        this.ofile.write(PNGEncoder.byteFromChar('D'));
        this.ofile.write(PNGEncoder.byteFromChar('A'));
        this.ofile.write(PNGEncoder.byteFromChar('T'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('I'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('D'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('A'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('T'));
        this.ofile.write(byArray2, 0, n2);
        for (n = 0; n < n2; ++n) {
            l = this.update_crc(l, byArray2[n]);
        }
        this.ofile.write(PNGEncoder.bytesFromLong(PNGEncoder.end_crc(l)));
        l = PNGEncoder.start_crc();
        this.ofile.write(PNGEncoder.bytesFromLong(0L));
        this.ofile.write(PNGEncoder.byteFromChar('I'));
        this.ofile.write(PNGEncoder.byteFromChar('E'));
        this.ofile.write(PNGEncoder.byteFromChar('N'));
        this.ofile.write(PNGEncoder.byteFromChar('D'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('I'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('E'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('N'));
        l = this.update_crc(l, PNGEncoder.byteFromChar('D'));
        this.ofile.write(PNGEncoder.bytesFromLong(PNGEncoder.end_crc(l)));
    }

    public int compress(byte[] byArray, int[] nArray, ColorModel colorModel, int n, int n2) throws EncoderException {
        byte[] byArray2 = new byte[nArray.length * 3 + n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i * (n * 3 + 1)] = PNGEncoder.byteFromInt(0);
            for (int j = 0; j < n * 3; j += 3) {
                byArray2[i * (n * 3 + 1) + j + 1] = (byte)colorModel.getRed(nArray[i * n + (int)Math.floor(j / 3)]);
                byArray2[i * (n * 3 + 1) + j + 2] = (byte)colorModel.getGreen(nArray[i * n + (int)Math.floor(j / 3)]);
                byArray2[i * (n * 3 + 1) + j + 3] = (byte)colorModel.getBlue(nArray[i * n + (int)Math.floor(j / 3)]);
            }
        }
        return this.compressInternal(byArray, byArray2);
    }

    public int compress(byte[] byArray, byte[] byArray2, int n, int n2) throws EncoderException {
        byte[] byArray3 = new byte[byArray2.length + n2];
        for (int i = 0; i < n2; ++i) {
            byArray3[i * (n + 1)] = PNGEncoder.byteFromInt(0);
            for (int j = 0; j < n; ++j) {
                byArray3[i * (n + 1) + j + 1] = byArray2[i * n + j];
            }
        }
        return this.compressInternal(byArray, byArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compressInternal(byte[] byArray, byte[] byArray2) throws EncoderException {
        Deflater deflater = new Deflater(-1);
        try {
            deflater.setInput(byArray2, 0, byArray2.length);
            deflater.finish();
            deflater.deflate(byArray);
            if (!deflater.finished()) {
                this.error("PNG encoding error: Deflater could not compress image data.");
            }
            int n = deflater.getTotalOut();
            return n;
        }
        finally {
            deflater.end();
        }
    }

    private void make_crc_table() {
        this.crc_table = new long[256];
        for (int i = 0; i < 256; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                if ((l & 1L) != 0L) {
                    l = 0xEDB88320L ^ l >> 1;
                    continue;
                }
                l >>= 1;
            }
            this.crc_table[i] = l;
        }
    }

    private static final long start_crc() {
        return 0xFFFFFFFFL;
    }

    private static final long end_crc(long l) {
        return l ^ 0xFFFFFFFFL;
    }

    private long update_crc(long l, byte[] byArray) {
        long l2 = l;
        for (int i = 0; i < byArray.length; ++i) {
            l2 = this.update_crc(l2, byArray[i]);
        }
        return l2;
    }

    private long update_crc(long l, byte by) {
        if (this.crc_table == null) {
            this.make_crc_table();
        }
        return this.crc_table[(int)((l ^ (long)by) & 0xFFL)] ^ l >> 8;
    }
}

