/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class DelimitedOutputFilter
implements OutputFilterInterface {
    PrintStream fout = null;
    static String delimiter = ",";
    static String stringQualifier = "\"";
    StringBuffer sb = new StringBuffer();

    @Override
    public void createFileInstance(String string) throws FileNotFoundException {
        this.fout = new PrintStream(new FileOutputStream(string));
    }

    @Override
    public void parseFields(byte[] byArray, ArrayList arrayList, StringBuffer stringBuffer) {
        block3: for (int i = 0; i < arrayList.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)arrayList.get(i);
            if (!fileFieldDef.isWriteField()) continue;
            switch (fileFieldDef.getFieldType()) {
                case 'P': 
                case 'S': {
                    stringBuffer.append(fileFieldDef.parseData(byArray).trim() + delimiter);
                    continue block3;
                }
                default: {
                    stringBuffer.append(stringQualifier + fileFieldDef.parseData(byArray).trim() + stringQualifier + delimiter);
                }
            }
        }
        this.fout.println(stringBuffer);
    }

    @Override
    public void writeHeader(String string, String string2, ArrayList arrayList, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)arrayList.get(i);
            if (!fileFieldDef.isWriteField()) continue;
            stringBuffer.append(fileFieldDef.getFieldName() + delimiter);
        }
        this.fout.println(stringBuffer.toString().toCharArray());
    }

    @Override
    public void writeFooter(ArrayList arrayList) {
        this.fout.flush();
        this.fout.close();
    }

    @Override
    public boolean isCustomizable() {
        return true;
    }

    @Override
    public void setCustomProperties() {
        new DelimitedDialog(new JFrame());
    }

    class DelimitedDialog {
        public DelimitedDialog(JFrame jFrame) {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("delm.labelOptions")));
            jPanel.setLayout(new AlignLayout(2, 5, 5));
            JLabel jLabel = new JLabel(LangTool.getString("delm.labelField"));
            JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.addItem(",");
            jComboBox.addItem(";");
            jComboBox.addItem(":");
            jComboBox.addItem("|");
            jComboBox.addItem(LangTool.getString("delm.labelTab"));
            jComboBox.addItem(LangTool.getString("delm.labelSpace"));
            jComboBox.addItem(LangTool.getString("delm.labelNone"));
            if (delimiter.length() > 0) {
                if (delimiter.equals("\t")) {
                    jComboBox.setSelectedItem(LangTool.getString("delm.labelTab"));
                } else if (delimiter.equals(" ")) {
                    jComboBox.setSelectedItem(LangTool.getString("delm.labelSpace"));
                } else {
                    if (!(delimiter.equals(",") || delimiter.equals(";") || delimiter.equals(":") || delimiter.equals("|"))) {
                        jComboBox.addItem(delimiter);
                    }
                    jComboBox.setSelectedItem(delimiter);
                }
            } else {
                jComboBox.setSelectedItem(LangTool.getString("delm.labelNone"));
            }
            jComboBox.setEditable(true);
            JLabel jLabel2 = new JLabel(LangTool.getString("delm.labelText"));
            JComboBox<String> jComboBox2 = new JComboBox<String>();
            jComboBox2.addItem("\"");
            jComboBox2.addItem("'");
            jComboBox2.addItem(LangTool.getString("delm.labelNone"));
            if (stringQualifier.length() > 0) {
                if (!stringQualifier.equals("'") && !stringQualifier.equals("\"")) {
                    jComboBox2.addItem(stringQualifier);
                }
                jComboBox2.setSelectedItem(stringQualifier);
            } else {
                jComboBox2.setSelectedItem(LangTool.getString("delm.labelNone"));
            }
            jComboBox2.setEditable(true);
            jPanel.add(jLabel);
            jPanel.add(jComboBox);
            jPanel.add(jLabel2);
            jPanel.add(jComboBox2);
            Object[] objectArray = new Object[]{jPanel};
            Object[] objectArray2 = new String[]{UIManager.getString("OptionPane.okButtonText"), UIManager.getString("OptionPane.cancelButtonText")};
            int n = JOptionPane.showOptionDialog(jFrame, objectArray, LangTool.getString("delm.title"), -1, -1, null, objectArray2, objectArray2[0]);
            switch (n) {
                case 0: {
                    delimiter = (String)jComboBox.getSelectedItem();
                    if (delimiter.equals(LangTool.getString("delm.labelSpace"))) {
                        delimiter = " ";
                    }
                    if (delimiter.equals(LangTool.getString("delm.labelTab"))) {
                        delimiter = "\t";
                    }
                    if (delimiter.equals(LangTool.getString("delm.labelNone"))) {
                        delimiter = "";
                    }
                    if (!(stringQualifier = (String)jComboBox2.getSelectedItem()).equals(LangTool.getString("delm.labelNone"))) break;
                    stringQualifier = "";
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }
}

