/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class ExcelOutputFilter
implements OutputFilterInterface {
    DataOutputStream fout = null;
    int row = 0;
    StringBuffer sb;
    Vector formats;

    @Override
    public void createFileInstance(String string) throws FileNotFoundException {
        try {
            this.fout = new DataOutputStream(new FileOutputStream(string));
        }
        catch (Exception exception) {
            System.out.println("create file " + exception.getMessage());
        }
        this.row = 0;
        this.sb = new StringBuffer();
        this.formats = null;
    }

    @Override
    public void parseFields(byte[] byArray, ArrayList arrayList, StringBuffer stringBuffer) {
        int n = 0;
        ++this.row;
        boolean bl = false;
        block3: for (int i = 0; i < arrayList.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)arrayList.get(i);
            if (!fileFieldDef.isWriteField()) continue;
            switch (fileFieldDef.getFieldType()) {
                case 'P': 
                case 'S': {
                    this.writeDouble(fileFieldDef.parseData(byArray), n++, fileFieldDef.getPrecision());
                    continue block3;
                }
                default: {
                    this.writeLabel(fileFieldDef.parseData(byArray), n++);
                }
            }
        }
    }

    private void writeLabel(String string, int n) {
        int n2 = string.length();
        try {
            this.writeShort(4);
            this.writeShort(8 + n2);
            this.writeShort(this.row);
            this.writeShort(n);
            this.fout.write(0);
            this.fout.write(0);
            this.fout.write(0);
            this.fout.writeByte(n2);
            this.fout.writeBytes(string);
        }
        catch (IOException iOException) {
            System.out.println("write label: " + iOException.getMessage());
        }
    }

    private void writeDouble(String string, int n, int n2) {
        try {
            this.writeShort(3);
            this.writeShort(15);
            this.writeShort(this.row);
            this.writeShort(n);
            this.fout.writeByte(0);
            this.fout.writeByte(n2);
            this.fout.writeByte(this.formats.indexOf(Integer.toString(n2)));
            double d = Double.parseDouble(string);
            this.writeLong(Double.doubleToLongBits(d));
        }
        catch (IOException iOException) {
            System.out.println("write double: " + iOException.getMessage());
        }
    }

    private void writeFormat(int n, int n2, int n3) {
        int n4;
        if (this.formats == null) {
            this.formats = new Vector();
        }
        this.sb.setLength(0);
        if (n2 > 0) {
            for (n4 = n2; n4 > 0; --n4) {
                this.sb.insert(0, '0');
            }
            this.sb.insert(0, "#0.");
        } else {
            this.sb.append("#0");
        }
        n4 = this.sb.length();
        if (!this.formats.contains(Integer.toString(n2))) {
            this.formats.add(Integer.toString(n2));
            try {
                this.writeShort(30);
                this.writeShort(1 + n4);
                this.fout.writeByte(n4);
                this.fout.writeBytes(this.sb.toString());
            }
            catch (IOException iOException) {
                System.out.println("write label: " + iOException.getMessage());
            }
        }
    }

    public void writeLong(long l) throws IOException {
        this.fout.write((int)l & 0xFF);
        this.fout.write((int)(l >>> 8) & 0xFF);
        this.fout.write((int)(l >>> 16) & 0xFF);
        this.fout.write((int)(l >>> 24) & 0xFF);
        this.fout.write((int)(l >>> 32) & 0xFF);
        this.fout.write((int)(l >>> 40) & 0xFF);
        this.fout.write((int)(l >>> 48) & 0xFF);
        this.fout.write((int)(l >>> 56) & 0xFF);
    }

    public void writeShort(int n) throws IOException {
        this.fout.write(n & 0xFF);
        this.fout.write(n >>> 8 & 0xFF);
    }

    @Override
    public void writeHeader(String string, String string2, ArrayList arrayList, char c) {
        byte[] byArray = new byte[]{9, 8, 6, 0, 0, 0, 16, 0, 0, 0};
        byte[] byArray2 = new byte[]{0, 2, 10, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0};
        try {
            FileFieldDef fileFieldDef;
            int n;
            this.fout.write(byArray);
            this.fout.write(byArray2);
            int n2 = 0;
            block5: for (n = 0; n < arrayList.size(); ++n) {
                fileFieldDef = (FileFieldDef)arrayList.get(n);
                if (!fileFieldDef.isWriteField()) continue;
                switch (fileFieldDef.getFieldType()) {
                    case 'P': 
                    case 'S': {
                        this.writeFormat(fileFieldDef.getFieldLength(), fileFieldDef.getPrecision(), ++n2);
                        continue block5;
                    }
                }
            }
            n2 = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                fileFieldDef = (FileFieldDef)arrayList.get(n);
                if (!fileFieldDef.isWriteField()) continue;
                this.writeLabel(fileFieldDef.getFieldName(), n2++);
            }
        }
        catch (IOException iOException) {
            System.out.println("header " + iOException.getMessage());
        }
    }

    @Override
    public void writeFooter(ArrayList arrayList) {
        try {
            this.fout.write(10);
            this.fout.write(0);
            this.fout.write(0);
            this.fout.write(0);
            this.fout.flush();
            this.fout.close();
        }
        catch (IOException iOException) {
            System.out.println("write footer: " + iOException.getMessage());
        }
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public void setCustomProperties() {
    }
}

