/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import org.tn5250j.framework.tn5250.tnvt;

public class FileFieldDef {
    private int startOffset;
    private int bufferLength;
    private int length;
    private int numDigits;
    private int decPos;
    private char type;
    private String txtDesc;
    private String fieldName;
    private String data;
    private boolean writeField;
    private char decChar;
    private boolean translateIt;
    private tnvt vt;
    private StringBuffer sbdata;

    public FileFieldDef(tnvt tnvt2, char c) {
        this.decChar = c;
        this.vt = tnvt2;
        this.translateIt = true;
    }

    public String parseData(byte[] byArray) {
        int n;
        if (!this.translateIt) {
            return this.sbdata.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(this.bufferLength);
        int n2 = this.startOffset + this.length - 1;
        switch (this.type) {
            case 'P': {
                int n3;
                int n4;
                for (n = this.startOffset - 1; n < n2 - 1; ++n) {
                    n4 = byArray[n];
                    n3 = n4 >> 4 & 0xF;
                    int n5 = n4 & 0xF;
                    stringBuffer.append(n3);
                    stringBuffer.append(n5);
                }
                n = byArray[n2 - 1];
                n4 = n >> 4 & 0xF;
                n3 = n & 0xF;
                stringBuffer.append(n4);
                if ((n3 | 0xD) == 13) {
                    stringBuffer.insert(0, '-');
                    break;
                }
                stringBuffer.insert(0, '+');
                break;
            }
            case 'S': {
                for (int i = this.startOffset - 1; i < n2; ++i) {
                    stringBuffer.append(byArray[i] & 0xF);
                }
                if ((byArray[n2 - 1] & 0xF0) == 208) {
                    stringBuffer.insert(0, '-');
                    break;
                }
                stringBuffer.insert(0, '+');
                break;
            }
            default: {
                for (int i = this.startOffset - 1; i < n2; ++i) {
                    stringBuffer.append(this.vt.getCodePage().ebcdic2uni(byArray[i] & 0xFF));
                }
            }
        }
        if (this.decPos > 0) {
            n = stringBuffer.length();
            stringBuffer.insert(n - this.decPos, this.decChar);
        }
        this.data = stringBuffer.toString();
        return this.data;
    }

    public void setFieldData(String string) {
        if (this.sbdata == null) {
            this.sbdata = new StringBuffer(this.length);
        }
        this.sbdata.setLength(0);
        this.sbdata.append(string);
    }

    public String toString() {
        return this.fieldName + " " + this.startOffset + " " + this.length + " " + this.getBufferOutLength() + " " + this.numDigits + " " + this.decPos + " " + this.type + " " + this.txtDesc;
    }

    public char getFieldType() {
        return this.type;
    }

    public int getPrecision() {
        return this.decPos;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public void setStartOffset(String string) {
        this.startOffset = Integer.parseInt(string);
    }

    public int getBufferOutLength() {
        return this.bufferLength;
    }

    public int getFieldLength() {
        return this.length;
    }

    public void setFieldLength(String string) {
        this.length = Integer.parseInt(string);
    }

    public void setNumDigits(String string) {
        this.numDigits = Integer.parseInt(string);
    }

    public void setDecPositions(String string) {
        this.decPos = Integer.parseInt(string);
    }

    public void setFieldType(String string) {
        this.type = string.charAt(0);
        this.bufferLength = this.type == 'P' ? this.length * 2 - 1 : this.length;
    }

    public void setFieldText(String string) {
        this.txtDesc = string;
    }

    public void setNeedsTranslation(boolean bl) {
        this.translateIt = bl;
    }

    public boolean isWriteField() {
        return this.writeField;
    }

    public void setWriteField(boolean bl) {
        this.writeField = bl;
    }
}

