/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class FixedWidthOutputFilter
implements OutputFilterInterface {
    PrintStream fout = null;
    StringBuffer sb = new StringBuffer();

    @Override
    public void createFileInstance(String string) throws FileNotFoundException {
        this.fout = new PrintStream(new FileOutputStream(string));
    }

    @Override
    public void parseFields(byte[] byArray, ArrayList arrayList, StringBuffer stringBuffer) {
        block3: for (int i = 0; i < arrayList.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)arrayList.get(i);
            if (!fileFieldDef.isWriteField()) continue;
            switch (fileFieldDef.getFieldType()) {
                case 'P': 
                case 'S': {
                    stringBuffer.append(this.getFixedLength(byArray, fileFieldDef));
                    continue block3;
                }
                default: {
                    stringBuffer.append(this.getFixedLength(byArray, fileFieldDef));
                }
            }
        }
        this.fout.println(stringBuffer);
    }

    private String getFixedLength(byte[] byArray, FileFieldDef fileFieldDef) {
        this.sb.setLength(0);
        switch (fileFieldDef.getFieldType()) {
            case 'P': 
            case 'S': {
                this.sb.append(fileFieldDef.parseData(byArray));
                this.formatNumeric(this.sb);
                while (this.sb.length() < fileFieldDef.getFieldLength()) {
                    this.sb.insert(0, ' ');
                }
                break;
            }
            default: {
                this.sb.append(fileFieldDef.parseData(byArray));
                while (this.sb.length() < fileFieldDef.getFieldLength()) {
                    this.sb.append(' ');
                }
                break block0;
            }
        }
        return this.sb.toString();
    }

    private void formatNumeric(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            stringBuffer.append('0');
            return;
        }
        int n = stringBuffer.length();
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl && n2 < n) {
            switch (stringBuffer.charAt(n2)) {
                case ' ': 
                case '+': 
                case '0': {
                    stringBuffer.setCharAt(n2, ' ');
                    break;
                }
                case '-': {
                    stringBuffer.setCharAt(n2, ' ');
                    bl2 = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (bl) continue;
            ++n2;
        }
        if (n2 > 0) {
            --n2;
        }
        if (bl2) {
            stringBuffer.setCharAt(n2, '-');
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append('0');
        }
    }

    @Override
    public void writeHeader(String string, String string2, ArrayList arrayList, char c) {
    }

    @Override
    public void writeFooter(ArrayList arrayList) {
        this.fout.flush();
        this.fout.close();
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public void setCustomProperties() {
    }
}

