/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class HTMLOutputFilter
implements OutputFilterInterface {
    PrintStream fout = null;

    @Override
    public void createFileInstance(String string) throws FileNotFoundException {
        this.fout = new PrintStream(new FileOutputStream(string));
    }

    @Override
    public void parseFields(byte[] byArray, ArrayList arrayList, StringBuffer stringBuffer) {
        stringBuffer.append("<TR>");
        stringBuffer.append('\n');
        for (int i = 0; i < arrayList.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)arrayList.get(i);
            if (!fileFieldDef.isWriteField()) continue;
            stringBuffer.append("<TD>");
            stringBuffer.append(fileFieldDef.parseData(byArray));
            stringBuffer.append("</TD>");
            stringBuffer.append('\n');
        }
        stringBuffer.append("</TR>");
        stringBuffer.append('\n');
        this.fout.println(stringBuffer);
    }

    @Override
    public void writeHeader(String string, String string2, ArrayList arrayList, char c) {
        try {
            this.fout.write("<HTML>".getBytes());
            this.fout.write("\n".getBytes());
            this.fout.write("<HEAD>".getBytes());
            this.fout.write(10);
            String string3 = "<TITLE>" + string2 + " - " + string + "</TITLE>";
            this.fout.write(string3.getBytes());
            this.fout.write(10);
            this.fout.write("   <META http-equiv=".getBytes());
            this.fout.write(34);
            this.fout.write("GENERATOR".getBytes());
            this.fout.write(34);
            this.fout.write(" content".getBytes());
            this.fout.write(34);
            this.fout.write("tn5250j Data Transfer".getBytes());
            this.fout.write(34);
            this.fout.write(">".getBytes());
            this.fout.write(10);
            this.fout.write("   <META http-equiv=".getBytes());
            this.fout.write(34);
            this.fout.write("Content-Type".getBytes());
            this.fout.write(34);
            this.fout.write(" content=".getBytes());
            this.fout.write(34);
            this.fout.write("text/html;charset=windows-1252".getBytes());
            this.fout.write(34);
            this.fout.write(">".getBytes());
            this.fout.write(10);
            this.fout.write("</HEAD>".getBytes());
            this.fout.write(10);
            this.fout.write("<BODY>".getBytes());
            this.fout.write(10);
            this.fout.write("<TABLE BORDER>".getBytes());
            this.fout.write(10);
            this.fout.write("<TR ALIGN=center>".getBytes());
            this.fout.write(10);
            for (int i = 0; i < arrayList.size(); ++i) {
                FileFieldDef fileFieldDef = (FileFieldDef)arrayList.get(i);
                if (!fileFieldDef.isWriteField()) continue;
                string3 = "<TH>" + fileFieldDef.getFieldName() + "</TH>";
                this.fout.write(string3.getBytes());
                this.fout.write(10);
            }
            this.fout.write("</TR>".getBytes());
            this.fout.write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeFooter(ArrayList arrayList) {
        try {
            this.fout.write("</TABLE>".getBytes());
            this.fout.write(10);
            this.fout.write("</BODY>".getBytes());
            this.fout.write(10);
            this.fout.write("</HTML>".getBytes());
            this.fout.write(10);
            this.fout.flush();
            this.fout.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public void setCustomProperties() {
    }
}

