/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class KSpreadOutputFilter
implements OutputFilterInterface {
    private int row;
    StringBuffer sb;
    PrintStream fout = null;

    @Override
    public void createFileInstance(String string) throws FileNotFoundException {
        this.fout = new PrintStream(new FileOutputStream(string));
        this.row = 0;
        this.sb = new StringBuffer();
    }

    @Override
    public void parseFields(byte[] byArray, ArrayList arrayList, StringBuffer stringBuffer) {
        ++this.row;
        int n = 1;
        for (int i = 0; i < arrayList.size(); ++i) {
            FileFieldDef fileFieldDef = (FileFieldDef)arrayList.get(i);
            if (!fileFieldDef.isWriteField()) continue;
            stringBuffer.append("    <cell row=\"" + this.row + "\"");
            stringBuffer.append(" column=\"" + n++ + "\" > \n");
            switch (fileFieldDef.getFieldType()) {
                case 'P': 
                case 'S': {
                    stringBuffer.append("     <format precision=\"" + fileFieldDef.getPrecision() + "\" > \n     </format>\n");
                    break;
                }
                default: {
                    stringBuffer.append("     <format/>\n");
                }
            }
            stringBuffer.append("    <text>");
            stringBuffer.append(this.tr2xml(fileFieldDef.parseData(byArray)));
            stringBuffer.append("</text> </cell>\n");
        }
        this.fout.println(stringBuffer);
        this.fout.flush();
    }

    private String tr2xml(String string) {
        this.sb.setLength(0);
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    this.sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    this.sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    this.sb.append("&amp;");
                    continue block5;
                }
                default: {
                    this.sb.append(string.charAt(i));
                }
            }
        }
        return this.sb.toString();
    }

    @Override
    public void writeHeader(String string, String string2, ArrayList arrayList, char c) {
        String string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE spreadsheet > <spreadsheet mime=\"application/x-kspread\" editor=\"KSpread\" >\n <paper format=\"A4\" orientation=\"Portrait\" >\n  <borders right=\"20\" left=\"20\" bottom=\"20\" top=\"20\" />\n  <head/>\n  <foot/>\n </paper>\n <locale positivePrefixCurrencySymbol=\"True\" negativeMonetarySignPosition=\"4\" negativePrefixCurrencySymbol=\"True\" fracDigits=\"2\" thousandsSeparator=\".\" dateFormat=\"%A %d %B %Y\" timeFormat=\"%H:%M:%S\" monetaryDecimalSymbol=\"" + c + "\"" + " weekStartsMonday=\"True\"" + " negativeSign=\"-\"" + " positiveSign=\"+\"" + " positiveMonetarySignPosition=\"4\"" + " decimalSymbol=\"" + c + "\"" + " dateFormatShort=\"%d.%m.%Y\" />\n" + " <map markerColumn=\"1\" activeTable=\"Table1\" markerRow=\"1\" >\n" + "  <table columnnumber=\"0\" borders=\"0\" hide=\"0\" grid=\"1\" formular=\"0\" lcmode=\"0\" name=\"Table1\" >";
        try {
            this.fout.write(string3.getBytes());
            this.fout.write(10);
            ++this.row;
            int n = 1;
            for (int i = 0; i < arrayList.size(); ++i) {
                FileFieldDef fileFieldDef = (FileFieldDef)arrayList.get(i);
                if (!fileFieldDef.isWriteField()) continue;
                this.fout.print("   <cell row=\"" + this.row + "\"");
                this.fout.print(" column=\"" + n++ + "\" >\n");
                this.fout.print("    <format>\n");
                this.fout.print("     <font size=\"11\" style=\"\" bold=\"yes\" weight=\"75\" />\n");
                this.fout.print("    </format>\n    <text>");
                this.fout.print(fileFieldDef.getFieldName());
                this.fout.print("</text>\n   </cell>\n");
            }
            this.fout.flush();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    @Override
    public void writeFooter(ArrayList arrayList) {
        try {
            this.fout.write("  </table>\n".getBytes());
            this.fout.write(" </map>\n".getBytes());
            this.fout.write("</spreadsheet>\n".getBytes());
            this.fout.flush();
            this.fout.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public void setCustomProperties() {
    }
}

