/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.logging;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.logging.ConsoleLogger;
import org.tn5250j.tools.logging.Log4jLogger;
import org.tn5250j.tools.logging.TN5250jLogger;

public final class TN5250jLogFactory {
    private static Map<String, TN5250jLogger> _loggers = new HashMap<String, TN5250jLogger>();
    private static boolean log4j;
    private static String customLogger;
    private static int level;

    TN5250jLogFactory() {
    }

    public static TN5250jLogger getLogger(Class<?> clazz) {
        return TN5250jLogFactory.getLogger(clazz.getName());
    }

    public static TN5250jLogger getLogger(String string) {
        TN5250jLogger tN5250jLogger = null;
        if (_loggers.containsKey(string)) {
            tN5250jLogger = _loggers.get(string);
        } else if (customLogger != null) {
            try {
                Class<?> clazz = Class.forName(customLogger);
                Object obj = clazz.newInstance();
                if (obj instanceof TN5250jLogger) {
                    tN5250jLogger = (TN5250jLogger)obj;
                }
            }
            catch (Exception exception) {}
        } else {
            tN5250jLogger = log4j ? new Log4jLogger() : new ConsoleLogger();
            tN5250jLogger.initialize(string);
            tN5250jLogger.setLevel(level);
            _loggers.put(string, tN5250jLogger);
        }
        return tN5250jLogger;
    }

    public static boolean isLog4j() {
        return log4j;
    }

    public static void setLogLevels(int n) {
        if (level != n) {
            level = n;
            TN5250jLogger tN5250jLogger = null;
            Set<String> set = _loggers.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                tN5250jLogger = _loggers.get(iterator.next());
                tN5250jLogger.setLevel(n);
            }
        }
    }

    static {
        level = 2;
        try {
            Properties properties = ConfigureFactory.getInstance().getProperties("sessions");
            level = Integer.parseInt(properties.getProperty("emul.logLevel", Integer.toString(2)));
            String string = System.getProperty(TN5250jLogFactory.class.getName());
            if (string == null) {
                try {
                    Class.forName("org.apache.log4j.Logger");
                    log4j = true;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

