/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.system;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Properties;
import org.tn5250j.ExternalProgramConfig;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class OperatingSystem {
    private static final TN5250jLogger LOG = TN5250jLogFactory.getLogger("org.tn5250j.tools.system.OperatingSystem");
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";
    private static final int UNIX = 201527;
    private static final int WINDOWS_9x = 1600;
    private static final int WINDOWS_NT = 1638;
    private static final int OS2 = 57005;
    private static final int MAC_OS_X = 2748;
    private static final int UNKNOWN = 2989;
    private static final int LINUX = 4919;
    private static int os;
    private static boolean java14;

    public static final Rectangle getScreenBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int n6 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (OperatingSystem.isMacOS()) {
            n4 = 0;
            n3 = 22;
            n2 = n5;
            n = n6 - n3 - 4;
        } else if (OperatingSystem.isWindows()) {
            n4 = -4;
            n3 = -4;
            n2 = n5 - 2 * n4;
            n = n6 - 2 * n3;
        } else {
            n4 = 0;
            n3 = 0;
            n2 = n5;
            n = n6;
        }
        return new Rectangle(n4, n3, n2, n);
    }

    public static final boolean isWindows() {
        return os == 1600 || os == 1638;
    }

    public static final boolean isUnix() {
        return os == 201527 || os == 2748 || os == 4919;
    }

    public static final boolean isMacOS() {
        return os == 2748;
    }

    public static final boolean hasJava14() {
        return java14;
    }

    public static void displayURL(String string) {
        block16: {
            Object object;
            Object object2;
            if (OperatingSystem.launchExternalProgram(string)) {
                return;
            }
            String string2 = null;
            String string3 = "";
            URL uRL = null;
            try {
                uRL = new URL(string);
                string3 = uRL.getProtocol();
                if (string3.startsWith("http")) {
                    string3 = "http";
                }
            }
            catch (MalformedURLException malformedURLException) {
                LOG.warn(malformedURLException.getMessage());
            }
            Properties properties = ConfigureFactory.getInstance().getProperties("sessions");
            if (properties.getProperty("emul.protocol." + string3, "").trim().length() > 0) {
                String string4 = properties.getProperty("emul.protocol." + string3).trim();
                object2 = new Object[]{string};
                if (string4.lastIndexOf("{0}") == -1) {
                    string4 = string4 + " {0}";
                }
                object = new MessageFormat(string4);
                try {
                    string2 = ((Format)object).format(object2);
                }
                catch (Exception exception) {
                    LOG.warn("Unable to parse the url " + string + " using command " + string4);
                }
            }
            if (string2 != null && string2.trim().length() > 0) {
                OperatingSystem.execute(string2);
            } else {
                boolean bl = OperatingSystem.isWindows();
                object2 = null;
                try {
                    if (bl) {
                        object2 = "rundll32 url.dll,FileProtocolHandler " + string;
                        object = Runtime.getRuntime().exec((String)object2);
                        break block16;
                    }
                    object2 = "netscape -remote openURL(" + string + ")";
                    object = Runtime.getRuntime().exec((String)object2);
                    try {
                        int n = ((Process)object).waitFor();
                        if (n != 0) {
                            object2 = "netscape " + string;
                            object = Runtime.getRuntime().exec((String)object2);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.warn("Error bringing up browser, cmd='" + (String)object2 + "'");
                        LOG.warn("Caught: " + interruptedException);
                    }
                }
                catch (IOException iOException) {
                    LOG.warn("Could not invoke browser, command=" + (String)object2);
                    LOG.warn("Caught: " + iOException);
                }
            }
        }
    }

    private static boolean launchExternalProgram(String string) {
        try {
            Properties properties = ExternalProgramConfig.getInstance().getEtnPgmProps();
            String string2 = properties.getProperty("etn.pgm.support.total.num");
            if (string2 != null && string2.length() > 0) {
                int n = Integer.parseInt(string2);
                for (int i = 1; i <= n; ++i) {
                    String string3 = properties.getProperty("etn.pgm." + i + ".command.name");
                    if (!string.toLowerCase().startsWith(string3.toLowerCase())) continue;
                    String string4 = string.substring(string3.length() + 1);
                    string4 = string4.replace(',', ' ');
                    String string5 = OperatingSystem.isWindows() ? properties.getProperty("etn.pgm." + i + ".command.window") + " " + string4 : properties.getProperty("etn.pgm." + i + ".command.unix") + " " + string4;
                    LOG.info("Execute External Program: " + string5);
                    OperatingSystem.execute(string5);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            LOG.warn("Unable to run External Program: " + exception.getMessage());
        }
        return false;
    }

    public static int execute(String string) {
        int n = -1;
        try {
            LOG.info("Executing command='" + string + "'");
            Process process = Runtime.getRuntime().exec(string);
            n = 0;
        }
        catch (IOException iOException) {
            LOG.warn("Error processing command, command='" + string + "'");
            LOG.warn("Caught: " + iOException.getMessage());
        }
        return n;
    }

    static {
        if (System.getProperty("mrj.version") != null) {
            os = 2748;
        } else {
            String string = System.getProperty("os.name");
            if (string.indexOf("Windows 9") != -1 || string.indexOf("Windows M") != -1) {
                os = 1600;
            } else if (string.indexOf("Windows") != -1) {
                os = 1638;
            } else if (string.indexOf("OS/2") != -1) {
                os = 57005;
            } else if (File.separatorChar == '/') {
                os = 201527;
            } else if (string.toLowerCase().indexOf("linux") != -1) {
                os = 4919;
            } else {
                os = 2989;
                LOG.warn("Unknown operating system: " + string);
            }
        }
        if (System.getProperty("java.version").compareTo("1.4") >= 0) {
            java14 = true;
        }
    }
}

