/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Array
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private AS400DataType arrayType = null;
    private int arraySize = -1;
    private boolean allowChanges = true;

    public AS400Array() {
    }

    public AS400Array(AS400DataType type, int size) {
        if (size < 0) {
            throw new ExtendedIllegalArgumentException("size (" + String.valueOf(size) + ")", 1);
        }
        this.allowChanges = false;
        this.arrayType = (AS400DataType)type.clone();
        this.arraySize = size;
    }

    public Object clone() {
        try {
            AS400Array nObj = (AS400Array)super.clone();
            nObj.arrayType = this.arrayType == null ? null : (AS400DataType)this.arrayType.clone();
            return nObj;
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        AS400DataType element = this.arrayType;
        int size = this.arraySize;
        if (element == null) {
            throw new ExtendedIllegalStateException("Type", 4);
        }
        if (size == -1) {
            throw new ExtendedIllegalStateException("NumberOfElements", 4);
        }
        this.allowChanges = false;
        return this.arraySize * this.arrayType.getByteLength();
    }

    public Object getDefaultValue() {
        int size = this.arraySize == -1 ? 0 : this.arraySize;
        Object[] returnArray = new Object[size];
        Object elementDefaultValue = this.arrayType == null ? null : this.arrayType.getDefaultValue();
        for (int i = 0; i < size; ++i) {
            returnArray[i] = elementDefaultValue;
        }
        return returnArray;
    }

    public int getInstanceType() {
        return 0;
    }

    public Class getJavaType() {
        return Object[].class;
    }

    public int getNumberOfElements() {
        return this.arraySize;
    }

    public AS400DataType getType() {
        return this.arrayType == null ? null : (AS400DataType)this.arrayType.clone();
    }

    public void setNumberOfElements(int size) {
        if (!this.allowChanges) {
            throw new ExtendedIllegalStateException("NumberOfElements", 5);
        }
        if (size < 0) {
            throw new ExtendedIllegalArgumentException("size (" + String.valueOf(size) + ")", 1);
        }
        this.arraySize = size;
    }

    public void setType(AS400DataType type) {
        if (!this.allowChanges) {
            throw new ExtendedIllegalStateException("Type", 5);
        }
        this.arrayType = (AS400DataType)type.clone();
    }

    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[this.getByteLength()];
        this.toBytes(javaValue, as400Value, 0);
        return as400Value;
    }

    public int toBytes(Object javaValue, byte[] as400Value) {
        return this.toBytes(javaValue, as400Value, 0);
    }

    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        AS400DataType element = this.arrayType;
        int size = this.arraySize;
        if (element == null) {
            throw new ExtendedIllegalStateException("Type", 4);
        }
        if (size == -1) {
            throw new ExtendedIllegalStateException("NumberOfElements", 4);
        }
        this.allowChanges = false;
        Object[] javaArray = (Object[])javaValue;
        if (javaArray.length != size) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 1);
        }
        for (int i = 0; i < size; ++i) {
            offset += element.toBytes(javaArray[i], as400Value, offset);
        }
        return element.getByteLength() * size;
    }

    public Object toObject(byte[] as400Value) {
        return this.toObject(as400Value, 0);
    }

    public Object toObject(byte[] as400Value, int offset) {
        AS400DataType element = this.arrayType;
        int size = this.arraySize;
        if (element == null) {
            throw new ExtendedIllegalStateException("Type", 4);
        }
        if (size == -1) {
            throw new ExtendedIllegalStateException("NumberOfElements", 4);
        }
        this.allowChanges = false;
        int elementSize = element.getByteLength();
        Object[] returnArray = new Object[size];
        for (int i = 0; i < size; ++i) {
            returnArray[i] = element.toObject(as400Value, offset);
            offset += elementSize;
        }
        return returnArray;
    }
}

